<?php
/**
 * 2007-2016 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2016 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

include_once _PS_MODULE_DIR_ . 'pk_sizeguide/models/SizeGuide.php';

class pk_sizeguide extends Module
{
    private $_html = '';

    public function __construct()
    {
        $this->name = 'pk_sizeguide';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'promokit.eu';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = 'Promokit Size Guide';
        $this->description = 'Show size guide popup';

        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);

        $this->defaults = array(
            'show_measure' => 1,
            'show_global' => 1,
            'content' => '',
            'global' => '',
        );
        $this->pref = 'PKSG';
        $this->templateFile = 'module:'.$this->name.'/views/templates/hook/'.$this->name.'.tpl';
        $this->templateFileComb = 'combinations.tpl';
    }

    public function install()
    {
        if (parent::install() &&
            $this->registerHook('displayHeader') &&
            $this->registerHook('displayGuide') &&
            $this->registerHook('displayAdminProductsExtra') &&
            $this->registerHook('actionProductUpdate') &&
            $this->registerHook('actionAdminProductsControllerSaveAfter') &&
            $this->registerHook('actionProductDelete') &&
            $this->registerHook('actionUpdateQuantity') &&
            $this->registerHook('actionValidateOrder') &&
            $this->createTables()) {
            $this->setDefaults();
            return true;
        } else {
            return false;
        }

    }

    public function uninstall()
    {
        foreach ($this->defaults as $default => $value) {
            Configuration::deleteByName($this->pref . '_' . $default);
        }

        return parent::uninstall() && $this->deleteTables();
    }

    protected function createTables()
    {
        $res = (bool) Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_sizeguide` (
				`id_sizeguide_guides` int(10) unsigned NOT NULL AUTO_INCREMENT,
				`id_shop` int(10) unsigned NOT NULL,
				PRIMARY KEY (`id_sizeguide_guides`, `id_shop`)
			) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
		');

        $res &= Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_sizeguide_guides` (
			  `id_sizeguide_guides` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `active` tinyint(1) unsigned NOT NULL DEFAULT \'0\',
			  PRIMARY KEY (`id_sizeguide_guides`)
			) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
		');

        $res &= Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_sizeguide_guides_lang` (
			  `id_sizeguide_guides` int(10) unsigned NOT NULL,
			  `id_lang` int(10) unsigned NOT NULL,
			  `title` varchar(255) NOT NULL,
			  `description` text NOT NULL,
			  PRIMARY KEY (`id_sizeguide_guides`,`id_lang`)
			) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
		');

        $res &= Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_sizeguide_product` (
				`id_product` int(10) unsigned NOT NULL,
				`id_guide` int(10) unsigned NOT NULL,
				 PRIMARY KEY (`id_product`)
				) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
		');

        return $res;
    }

    protected function deleteTables()
    {
        $guides = $this->getGuides();
        foreach ($guides as $guide) {
            $to_del = new SizeGuide($guide['id_guide']);
            $to_del->delete();
        }

        return Db::getInstance()->execute('
			DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'pk_sizeguide`, `' . _DB_PREFIX_ . 'pk_sizeguide_guides`, `' . _DB_PREFIX_ . 'pk_sizeguide_product`, `' . _DB_PREFIX_ . 'pk_sizeguide_guides_lang`;
		');
    }

    public function setDefaults()
    {
        foreach ($this->defaults as $default => $value) {
            $content = array();
            if ($default == 'content') {
                foreach (Language::getLanguages(false) as $lang) {
                    $content[(int)$lang['id_lang']] = '<h2 class="title-measure">How to Take Clothing Measurements</h2><ol class="text-measure"><li>Get a flexible measuring tape. These are often sold in craft stores</li><li><strong>Neck:</strong><ul><li>Measure around the base of the neck in inches.</li><li>Round up to the nearest half inch.</li></ul></li><li><strong>Chest:</strong><ul><li>Wrap tape measure under armpits around fullest part of chest (usually right above nipples</li></ul></li><li><strong>Sleeve:</strong><ul><li>Bend your elbow and rest your hand on your hip.</li><li>Have someone measure from the middle of the back of your neck to your wrist by putting the tape measure over your shoulder, around your elbow and to your wrist.</li></ul></li><li><strong>Waist:</strong><ul><li>Wrap tape measure around where you normally wear your pants. Keep tape measure a little loose by keeping a finger between the tape measure and your waist.</li></ul></li><li><strong>Inseam:</strong><ul><li>Put on a pair of shoes.Have someone measure from your crotch to back of the heel, where you want your pants to end.</li></ul></li><li><strong>Hands:</strong><ul><li>Measure around the hand at the fullest part (exclude thumb). The number of inches shows the size of the glove.</li></ul></li></ol>';
                }
                Configuration::updateValue($this->pref . '_' . $default, $content, true);
            } elseif ($default == 'global') {
                foreach (Language::getLanguages(false) as $lang) {
                    $content[(int)$lang['id_lang']] = '<table class="table table-sizegudie"><tbody><tr><td style="text-align: left;">CLOTHES</td></tr></tbody></table><table class="table table-sizegudie"><thead><tr><th>MEASURE</th><th>XS/34</th><th>S/36</th><th>M/38-40</th><th>L/40-42</th></tr></thead><tbody><tr class="background-odd"><td>UK</td><td>6</td><td>8</td><td>10</td><td>12</td></tr><tr><td>USA</td><td>4</td><td>6</td><td>8</td><td>10</td></tr><tr class="background-odd"><td>FRA</td><td>36</td><td>38</td><td>40</td><td>42</td></tr><tr><td>Waist (cm)</td><td>64</td><td>68</td><td>72</td><td>76</td></tr><tr class="background-odd"><td>Chest (cm)</td><td>81</td><td>85</td><td>89</td><td>93</td></tr><tr><td>Seat (cm)</td><td>89</td><td>93</td><td>97</td><td>101</td></tr><tr class="background-odd"><td>Inseam (cm)</td><td>81</td><td>82</td><td>83</td><td>84</td></tr></tbody></table><p><br /><br /></p><table class="table table-sizegudie"><tbody><tr><td style="text-align: left;">SHOES</td></tr></tbody></table><table class="table table-sizegudie"><thead><tr><th>FOOT IN INCHES</th><th>FOOT IN CM</th><th>USA</th><th>Euro</th><th>UK</th></tr></thead><tbody><tr class="background-odd"><td>9¼</td><td>23.5</td><td>6</td><td>39</td><td>5</td></tr><tr><td>9½</td><td>24.1</td><td>6.5</td><td>39.5</td><td>5.5</td></tr><tr class="background-odd"><td>9¾</td><td>24.8</td><td>7.5</td><td>40</td><td>6</td></tr><tr><td>10</td><td>25.4</td><td>8</td><td>41</td><td>7</td></tr><tr class="background-odd"><td>10¼</td><td>25.7</td><td>8.5</td><td>41.5</td><td>7.5</td></tr><tr><td>10½</td><td>26</td><td>9</td><td>42</td><td>8</td></tr><tr class="background-odd"><td>10¾</td><td>27.3</td><td>9.5</td><td>42.5</td><td>9.5</td></tr></tbody></table><table class="table table-sizegudie"><tbody><tr><td style="text-align: left;">CLOTHES</td></tr></tbody></table><table class="table table-sizegudie"><thead><tr><th>MEASURE</th><th>XS/34</th><th>S/36</th><th>M/38-40</th><th>L/40-42</th></tr></thead><tbody><tr class="background-odd"><td>UK</td><td>6</td><td>8</td><td>10</td><td>12</td></tr><tr><td>USA</td><td>4</td><td>6</td><td>8</td><td>10</td></tr><tr class="background-odd"><td>FRA</td><td>36</td><td>38</td><td>40</td><td>42</td></tr><tr><td>Waist (cm)</td><td>64</td><td>68</td><td>72</td><td>76</td></tr><tr class="background-odd"><td>Chest (cm)</td><td>81</td><td>85</td><td>89</td><td>93</td></tr><tr><td>Seat (cm)</td><td>89</td><td>93</td><td>97</td><td>101</td></tr><tr class="background-odd"><td>Inseam (cm)</td><td>81</td><td>82</td><td>83</td><td>84</td></tr></tbody></table><p><br /><br /></p><table class="table table-sizegudie"><tbody><tr><td style="text-align: left;">SHOES</td></tr></tbody></table><table class="table table-sizegudie"><thead><tr><th>FOOT IN INCHES</th><th>FOOT IN CM</th><th>USA</th><th>Euro</th><th>UK</th></tr></thead><tbody><tr class="background-odd"><td>9¼</td><td>23.5</td><td>6</td><td>39</td><td>5</td></tr><tr><td>9½</td><td>24.1</td><td>6.5</td><td>39.5</td><td>5.5</td></tr><tr class="background-odd"><td>9¾</td><td>24.8</td><td>7.5</td><td>40</td><td>6</td></tr><tr><td>10</td><td>25.4</td><td>8</td><td>41</td><td>7</td></tr><tr class="background-odd"><td>10¼</td><td>25.7</td><td>8.5</td><td>41.5</td><td>7.5</td></tr><tr><td>10½</td><td>26</td><td>9</td><td>42</td><td>8</td></tr><tr class="background-odd"><td>10¾</td><td>27.3</td><td>9.5</td><td>42.5</td><td>9.5</td></tr></tbody></table>';
                }
                Configuration::updateValue($this->pref.'_'.$default, $content, true);
            } else {
                Configuration::updateValue($this->pref.'_'.$default, $value);
            }

        }
    }

    public function getContent()
    {
        $this->context->controller->addJS($this->_path . 'views/assets/js/admin.js');

        if (Tools::isSubmit('submitGuide') || Tools::isSubmit('delete_id_guide')) {
            if ($this->_postValidation()) {
                $this->_postProcess();
                $this->_html .= $this->renderForm();
                $this->_html .= $this->renderList();
            } else {
                $this->_html .= $this->renderAddForm();
            }
        } elseif (Tools::isSubmit('addGuide') || (Tools::isSubmit('id_guide') && $this->guideExists((int) Tools::getValue('id_guide')))) {
            return $this->renderAddForm();
        } elseif (Tools::isSubmit('submitpksizechartModule')) {
            $this->_postProcessChart();
            $this->context->smarty->assign('module_dir', $this->_path);
            $this->_html .= $this->renderForm() . $this->renderList();
        } else {
            $this->context->smarty->assign('module_dir', $this->_path);
            $this->_html .= $this->renderForm() . $this->renderList();
        }
        return $this->_html;
    }

    private function _postValidation()
    {
        $errors = array();

        if (Tools::isSubmit('submitGuide')) {
            if (Tools::isSubmit('id_guide')) {
                if (!Validate::isInt(Tools::getValue('id_guide')) && !$this->guideExists(Tools::getValue('id_guide'))) {
                    $errors[] = $this->l('Invalid id_guide');
                }
            }
            $languages = Language::getLanguages(false);
            foreach ($languages as $language) {
                if (Tools::strlen(Tools::getValue('title_' . $language['id_lang'])) > 255) {
                    $errors[] = $this->l('The title is too long.');
                }
            }
            $id_lang_default = (int) Configuration::get('PS_LANG_DEFAULT');
            if (Tools::strlen(Tools::getValue('title_' . $id_lang_default)) == 0) {
                $errors[] = $this->l('The title is not set.');
            }
        }
        elseif (Tools::isSubmit('delete_id_guide') && (!Validate::isInt(Tools::getValue('delete_id_guide')) || !$this->guideExists((int) Tools::getValue('delete_id_guide')))) {
            $errors[] = $this->l('Invalid id_guide');
        }
        if (count($errors)) {
            $this->_html .= $this->displayError(implode('<br />', $errors));
            return false;
        }

        return true;
    }

    private function _postProcess()
    {
        $errors = array();

        if (Tools::isSubmit('submitGuide')) {
            if (Tools::getValue('id_guide')) {
                $guide = new SizeGuide((int) Tools::getValue('id_guide'));
                if (!Validate::isLoadedObject($guide)) {
                    $this->_html .= $this->displayError($this->l('Invalid id_guide'));
                    return false;
                }
            } else {
                $guide = new SizeGuide();
            }

            $guide->active = 1;

            $languages = Language::getLanguages(false);
            foreach ($languages as $language) {
                $guide->title[$language['id_lang']] = Tools::getValue('title_' . $language['id_lang']);
                $guide->description[$language['id_lang']] = Tools::getValue('description_' . $language['id_lang']);
            }

            if (!$errors) {
                if (!Tools::getValue('id_guide')) {
                    if (!$guide->add()) {
                        $errors[] = $this->displayError($this->l('The guide could not be added.'));
                    }
                }

                elseif (!$guide->update()) {
                    $errors[] = $this->displayError($this->l('The guide could not be updated.'));
                }
                $this->clearCache();
            }
        }
        elseif (Tools::isSubmit('delete_id_guide')) {
            $guide = new SizeGuide((int) Tools::getValue('delete_id_guide'));
            $res = $guide->delete();
            $this->clearCache();
            if (!$res) {
                $this->_html .= $this->displayError('Could not delete.');
            } else {
                Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', true) . '&conf=1&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name);
            }
        }

        if (count($errors)) {
            $this->_html .= $this->displayError(implode('<br />', $errors));
        } elseif (Tools::isSubmit('submitGuide') && Tools::getValue('id_guide')) {
            Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', true) . '&conf=4&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name);
        } elseif (Tools::isSubmit('submitGuide')) {
            Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules', true) . '&conf=3&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name);
        }

    }

    public function renderList()
    {
        $guides = $this->getGuides();
        $this->context->smarty->assign(
            array(
                'link' => $this->context->link,
                'guides' => $guides,
            )
        );
        return $this->display(__FILE__, 'list.tpl');
    }

    public function renderAddForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Guide informations'),
                    'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->l('Title'),
                        'name' => 'title',
                        'lang' => true,
                    ),

                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Description'),
                        'name' => 'description',
                        'autoload_rte' => true,
                        'lang' => true,
                    ),
                    array(
                        'type' => 'table_creator',
                        'label' => $this->l('Generate table and add to editor'),
                        'name' => 'table_creator',
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),
        );

        if (Tools::isSubmit('id_guide') && $this->guideExists((int) Tools::getValue('id_guide'))) {
            $guide = new SizeGuide((int) Tools::getValue('id_guide'));
            $fields_form['form']['input'][] = array('type' => 'hidden', 'name' => 'id_guide');
        }

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $lang = new Language((int) Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $this->fields_form = array();
        $helper->module = $this;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitGuide';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $language = new Language((int) Configuration::get('PS_LANG_DEFAULT'));
        $helper->tpl_vars = array(
            'base_url' => $this->context->shop->getBaseURL(),
            'language' => array(
                'id_lang' => $language->id,
                'iso_code' => $language->iso_code,
            ),
            'fields_value' => $this->getValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
            'module_path' => $this->_path,
            'image_baseurl' => $this->_path . 'views/assets/images/',
        );

        $helper->override_folder = '/';

        return $helper->generateForm(array($fields_form));
    }

    public function getGuides($active = null)
    {
        return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT hs.`id_sizeguide_guides` as id_guide, hssl.`title`, hssl.`description`
			FROM ' . _DB_PREFIX_ . 'pk_sizeguide hs
			LEFT JOIN ' . _DB_PREFIX_ . 'pk_sizeguide_guides hss ON (hs.id_sizeguide_guides = hss.id_sizeguide_guides)
			LEFT JOIN ' . _DB_PREFIX_ . 'pk_sizeguide_guides_lang hssl ON (hss.id_sizeguide_guides = hssl.id_sizeguide_guides)
			WHERE id_shop = ' . $this->context->shop->id . '
			AND hssl.id_lang = ' . $this->context->language->id
        );
    }

    public function getValues()
    {
        $fields = array();

        if (Tools::isSubmit('id_guide') && $this->guideExists((int) Tools::getValue('id_guide'))) {
            $guide = new SizeGuide((int) Tools::getValue('id_guide'));
            $fields['id_guide'] = (int) Tools::getValue('id_guide', $guide->id);
        } else {
            $guide = new SizeGuide();
        }

        $languages = Language::getLanguages(false);

        foreach ($languages as $lang) {
            $fields['title'][$lang['id_lang']] = Tools::getValue('title_' . (int) $lang['id_lang'], $guide->title[$lang['id_lang']]);
            $fields['description'][$lang['id_lang']] = Tools::getValue('description_' . (int) $lang['id_lang'], $guide->description[$lang['id_lang']]);
        }

        return $fields;
    }

    public function guideExists($id_guide)
    {
        $req = 'SELECT hs.`id_sizeguide_guides` as id_guide
				FROM `' . _DB_PREFIX_ . 'pk_sizeguide` hs
				WHERE hs.`id_sizeguide_guides` = ' . (int) $id_guide;
        $row = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($req);

        return ($row);
    }

    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitpksizechartModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
        . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'module_path' => $this->_path,
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }
    public function getAttributes()
    {
        $attributes = AttributeGroup::getAttributesGroups($this->context->language->id);
        $selectAttributes = array();

        foreach ($attributes as $attribute) {
            $selectAttributes[$attribute['id_attribute_group']]['id_option'] = $attribute['id_attribute_group'];
            $selectAttributes[$attribute['id_attribute_group']]['name'] = $attribute['name'];
        }

        return $selectAttributes;
    }

    protected function getConfigForm()
    {

        return array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Settings'),
                    'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Show how to measure tab'),
                        'name' => 'show_measure',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled'),
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('How to measure tab'),
                        'name' => 'content',
                        'autoload_rte' => true,
                        'lang' => true,
                        'cols' => 60,
                        'rows' => 30,
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Show global size guide'),
                        'name' => 'show_global',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled'),
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Global size guide'),
                        'name' => 'global',
                        'autoload_rte' => true,
                        'lang' => true,
                        'cols' => 60,
                        'rows' => 30,
                    ),
                    array(
                        'type' => 'table_creator',
                        'label' => $this->l('Generate table and add to editor'),
                        'name' => 'table_creator',
                    ),

                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),
        );
    }

    protected function getConfigFormValues()
    {
        $var = array();

        foreach ($this->defaults as $default => $value) {

            if ($default == 'content' || $default == 'global') {
                foreach (Language::getLanguages(false) as $lang) {
                    $var[$default][(int) $lang['id_lang']] = Configuration::get($this->pref . '_' . $default, (int) $lang['id_lang']);
                }
            } elseif ($default == 'newval') {
                $var[$default] = 1;
            } else {
                $var[$default] = Configuration::get($this->pref . '_' . $default);
            }

        }
        return $var;

    }

    protected function _postProcessChart()
    {
        foreach ($this->defaults as $default => $value) {
            if ($default == 'content') {
                $message_trads = array();
                foreach ($_POST as $key => $value) {
                    if (preg_match('/content_/i', $key)) {
                        $id_lang = preg_split('/content_/i', $key);
                        $message_trads[(int) $id_lang[1]] = $value;
                    }
                }
                Configuration::updateValue($this->pref . '_' . $default, $message_trads, true);
            } elseif ($default == 'global') {
                $message_trads = array();
                foreach ($_POST as $key => $value) {
                    if (preg_match('/global_/i', $key)) {
                        $id_lang = preg_split('/global_/i', $key);
                        $message_trads[(int) $id_lang[1]] = $value;
                    }
                }
                Configuration::updateValue($this->pref . '_' . $default, $message_trads, true);
            } elseif ($default == 'newval') {
                if (Tools::getValue($default)) {
                    Configuration::updateValue($this->pref . '_' . $default, mt_rand(1, 9999));
                }
            } else {
                Configuration::updateValue($this->pref . '_' . $default, (Tools::getValue($default)));
            }

        }
        $this->_clearCache($this->templateFile);
    }

    public function clearCache()
    {
        $this->_clearCache($this->templateFile);
    }

    public function hookDisplayHeader()
    {
        if ($this->context->controller->php_self == 'product') {
            $this->context->controller->addCSS($this->_path . 'views/assets/css/styles.css');
            $this->context->controller->registerJavascript($this->name, 'modules/'.$this->name.'/views/assets/js/scripts.js', array('position' => 'bottom', 'priority' => 200, 'attributes' => 'async'));
        }

    }

    public function hookDisplayAdminProductsExtra($params)
    {
        $guides = $this->getGuides();
        $selected = SizeGuide::getProductGuide((int)$params['id_product']);

        $this->context->smarty->assign(array(
            'guides' => $guides,
            'selectedGuide' => 1,
        ));

        return $this->display(__FILE__, 'views/templates/admin/addtab.tpl');
    }

    public function hookActionUpdateQuantity()
    {
        $this->_clearcache($this->templateFileComb);
    }

    public function hookActionValidateOrder()
    {
        $this->_clearcache($this->templateFileComb);
    }

    public function hookActionProductUpdate($params)
    {
        $this->_clearcache($this->templateFileComb);
    }
    public function hookDisplayGuide($params)
    {
        return $this->_prepareHook($params);
    }

    public function hookActionAdminProductsControllerSaveAfter($params)
    {
        $this->_clearcache($this->templateFileComb);

        $id_product = (int)Tools::getValue('id_product');
        $id_guide = (int)Tools::getValue('id_sizeguide');

        if ($id_guide) {
            SizeGuide::assignProduct($id_product, $id_guide);
        } else {
            SizeGuide::unassignProduct($id_product);
        }

    }

    public function hookActionProductDelete($params)
    {
        $this->_clearcache($this->templateFileComb);
        $id_product = (int) Tools::getValue('id_product');
        SizeGuide::unassignProduct($id_product);
    }

    public function _prepareHook($params)
    {
        $product = (int) Tools::getValue('id_product');
        $id_guide = SizeGuide::getProductGuide((int) Tools::getValue('id_product'));
        $show_global = Configuration::get($this->pref . '_show_global');

        if ($id_guide || $show_global) {
            if ($id_guide) {
                $guide = new SizeGuide((int)$id_guide, $this->context->language->id);
                $cache_id = $this->name.'|'.(int)$id_guide;
            } else {
                $cache_id = $this->name;
            }

            if (!$this->isCached($this->templateFile, $this->getCacheId($cache_id))) {
                if ($id_guide) {
                    $this->smarty->assign(
                        array('guide' => $guide)
                    );
                }
                $this->smarty->assign(
                    array(
                        'howto' => Configuration::get($this->pref . '_content', $this->context->language->id),
                        'show_measure' => Configuration::get($this->pref . '_show_measure'),
                        'show_global' => $show_global,
                        'global' => Configuration::get($this->pref . '_global', $this->context->language->id),
                    )
                );

            }
            return $this->fetch($this->templateFile, $this->getCacheId($cache_id));
        }
    }

    public function getAttributeCombinations($id_product, $id_lang, $groupByIdAttributeGroup = true)
    {
        if (!Combination::isFeatureActive()) {
            return array();
        }
        $sql = 'SELECT pa.*, product_attribute_shop.*, ag.`id_attribute_group`, ag.`is_color_group`, agl.`name` AS group_name, al.`name` AS attribute_name,
					a.`id_attribute`
				FROM `' . _DB_PREFIX_ . 'product_attribute` pa
				' . Shop::addSqlAssociation('product_attribute', 'pa') . '
				LEFT JOIN `' . _DB_PREFIX_ . 'product_attribute_combination` pac ON pac.`id_product_attribute` = pa.`id_product_attribute`
				LEFT JOIN `' . _DB_PREFIX_ . 'attribute` a ON a.`id_attribute` = pac.`id_attribute`
				LEFT JOIN `' . _DB_PREFIX_ . 'attribute_group` ag ON ag.`id_attribute_group` = a.`id_attribute_group`
				LEFT JOIN `' . _DB_PREFIX_ . 'attribute_lang` al ON (a.`id_attribute` = al.`id_attribute` AND al.`id_lang` = ' . (int) $id_lang . ')
				LEFT JOIN `' . _DB_PREFIX_ . 'attribute_group_lang` agl ON (ag.`id_attribute_group` = agl.`id_attribute_group` AND agl.`id_lang` = ' . (int) $id_lang . ')
				WHERE pa.`id_product` = ' . (int) $id_product . '
				GROUP BY pa.`id_product_attribute`' . ($groupByIdAttributeGroup ? ',ag.`id_attribute_group`' : '') . '
				ORDER BY pa.`id_product_attribute`';
        $res = Db::getInstance()->executeS($sql);
        //Get quantity of each variations
        foreach ($res as $key => $row) {
            $cache_key = $row['id_product'] . '_' . $row['id_product_attribute'] . '_quantity';
            if (!Cache::isStored($cache_key)) {
                Cache::store(
                    $cache_key,
                    StockAvailable::getQuantityAvailableByProduct($row['id_product'], $row['id_product_attribute'])
                );
            }
            $res[$key]['quantity'] = Cache::retrieve($cache_key);
        }
        return $res;
    }

}
