$(document).ready(function(){
  $('body').on( "click", "#table_generator", function() {
    create_table();
  });
});

function create_table() {
  var tbl_display = document.getElementById("tbl_display"),
      tbl_display1 = document.getElementById("tbl_display"),
      no_rows =  $('.nrows').val(),
      no_col =  $('.ncol').val(),
      tbl = document.createElement('table'),
      tblHead = document.createElement('thead'),
      tblrow = document.createElement("tr");

  tbl.setAttribute("class", "table table-bordered table-sizegudie");
  tbl.appendChild(tblHead);
  tblHead.appendChild(tblrow);

  for(r=0; r< no_col; r++) {  
    var tblHeadCell = document.createElement('th');  
    tblrow.appendChild(tblHeadCell);  
    var thText = document.createTextNode("th"+r);  
    tblHeadCell.appendChild(thText);  
  } 

  if ($('.header_row').prop('checked')){  
    var tblHeadCell = document.createElement('th'); 
    tblHeadCell.className = "nobordered-cell"; 
    tblrow.insertBefore(tblHeadCell,tblrow.firstChild);
    var thText = document.createTextNode("");  
    tblHeadCell.appendChild(thText);   
  }
  
  var tblBody = document.createElement("tbody");  
  for (var p = 0; p < no_rows; p++) {  
    var row = document.createElement("tr");  
    if ($('.header_row').prop('checked')){  
      var cell = document.createElement("td");  
      cell.className = "bordered-cell";
      var cellText = document.createTextNode("header");  
      cell.appendChild(cellText);  
      row.appendChild(cell);
    }  
    for (var q = 0; q < no_col; q++) {  
      var cell = document.createElement("td");  
      var cellText = document.createTextNode("cell"+p+","+q);  
      cell.appendChild(cellText);  
      row.appendChild(cell);  
    } 
    tblBody.appendChild(row);
  } 
  tbl.appendChild(tblBody);  
  AddNotes(tbl);  
}   

function AddNotes(content) {
  tinymce.activeEditor.execCommand('mceInsertContent', false , content.outerHTML); 
}
