<!-- Block testimonial module -->
{extends file='page.tpl'}
{block name='page_content'}
<h2 class="page-heading">
    {l s='Add Testimonial' mod='pk_testimonials'}
</h2>
<div class="hidden pk_addtestimonials" data-options="{$json_opts}"></div>
<div class="hidden pk_addtestimonials_text" data-options='{
    "field_error": "{l s="Please fill in all the required fields" mod="pk_testimonials"}",
    "captcha_error": "{l s="Please type captcha words correctly and try again!" mod="pk_testimonials"}",
    "success": "{l s="Your message has been sent and will be published soon" mod="pk_testimonials"}",
    "DB_error": "{l s="Can not add testimonial to DB" mod="pk_testimonials"}",
    "other": "{l s="Something is wrong. Please try agains" mod="pk_testimonials"}"
}'></div>
{if ($customer.is_logged == 1)}
<span class="subtitle">{l s='We welcome your testimonials - please enter yours using the form below' mod='pk_testimonials'}</span>
<div id="block_testimonials_submit">
  <form class="testimonialForm custom-inputs" id="testimonialForm" name="testimonialForm" method="post" enctype="multipart/form-data" action="">
    <fieldset>
      <ol>
        <li class="testim-name form-group hidden">
          <label for="name" class="i-name f-label">{l s='Name' mod='pk_testimonials'}<em>*</em></label>
          <input name="testimonial_submitter_name"  value="{$customer.firstname}" id="testimonial_submitter_name" class="required form-control" maxlength="20" type="text" /></li>
        <li class="testim-email hidden">
          <label for="name" class="i-email f-label">{l s='Email' mod='pk_testimonials'}<em>*</em></label>
          <input name="testimonial_submitter_email"  value="{$customer.email}" id="testimonial_submitter_email" class="required form-control" maxlength="40" type="email" /></li>
        <li class="testim-summary">
          <label for="testimonial_title" class="i-other f-label">{l s='Summary' mod='pk_testimonials'}<em>*</em></label>
          <input name="testimonial_title" value="" id="testimonial_title" class="required form-control"  maxlength="40" type="text" /></li>
        <li class="testim-body">
          <label for="testimonial_main_message" class="i-message t-label">{l s='Your Testimonial' mod='pk_testimonials'}</label>
          <textarea cols="33" rows="5" name="testimonial_main_message" id="testimonial_main_message" class="required form-control" maxlength="1000"></textarea></li>
      </ol>
      <div class='alert'></div>
    </fieldset>
    {if $opts.recaptcha && $customer.is_guest == 1}
      <fieldset>
        <div id="captcha_body"></div>
      </fieldset>
    {/if}
    <input type="submit" class="button btn" name="testimonial" value="{l s='Submit Testimonial' mod='pk_testimonials'}"  />
  </form>
</div>
{else}
  {l s='You must be loggen in to write a testimonial' mod='pk_testimonials'}
{/if}
{/block}
<!-- /Block testimonial module -->