$(document).ready(function(){

  $(".sortable").sortable({
    forcePlaceholderSize: true
      }).bind("sortupdate", function(e, ui) {
        var ids = ui.item.attr("id").split("_");
        var way = (ui.start_index < ui.end_index)? 1 : 0;
        var data = ids[0]+"[]=";

        $.each(e.target.children, function(index, element) {
          $(element).find("input[type=hidden]").val(index+1);
          data += "&"+ids[0]+"[]="+$(element).attr("id");
        });

        $.ajax({
          type: "POST",
          headers: { "cache-control": "no-cache" },
          async: false,
          url: tsDir + 'ajax.php',
          //url: currentIndex + "&token=" + token + "&" + "rand=" + new Date().getTime(),
          data: data + "&action=updatePositions&id_hook="+ids[0]+"&id_module="+ids[1]+"&way="+way,
          success: function(data) {
            var d = jQuery.parseJSON(data);
            if (d.hasError == true) {
              showErrorMessage(d.errors);
            } else {
              start = 0;
              $.each(e.target.children, function(index, element) {
                $(element).find(".positions").html(++start);
              });
              showSuccessMessage(update_success_msg);
            }
          }
        });
      });

  $(".tabs .tab[id^=tab_menu]").click(function() {
    var curMenu=$(this);
    if (!$(this).hasClass("selected")) {
      $(".tabs .tab[id^=tab_menu]").removeClass("selected");
      curMenu.addClass("selected");
      var index=curMenu.attr("id").split("tab_menu_")[1];
      $(".curvedContainer .tabcontent").animate({ opacity: 0 }, 0).css("display","none");
      $(".curvedContainer #tab_content_"+index).css("display","block").animate({ opacity: 1 }, 200);
      $(".tabs input[name=\'tab_number\']").removeAttr("checked");
      $(".tabs").find("#tab_"+index).attr("checked", "checked");
    }
  });

  var preset_item = '.preset';
  $(preset_item).click(function(){ // changing text fonts
    $(preset_item).parent().find('.preset').removeClass('active');
    $(this).addClass('active');
  });

  /*  ui switcher */
  $(".cb-enable").click(function(){
    $(this).closest(".switch").removeClass('mod-disabled');
      var parent = $(this).parents(".switch");
      $(".cb-disable",parent).removeClass("sel");
      $(this).addClass("sel");
      $(".checkbox",parent).attr("checked", true);
  });
  $(".cb-disable").click(function(){
    $(this).closest(".switch").addClass('mod-disabled');
      var parent = $(this).parents(".switch");
      $(".cb-enable",parent).removeClass("sel");
      $(this).addClass("sel");
      $(".checkbox",parent).attr("checked", false);
  });
  //

  $('.control-wrapper').each(function(index, element) {

    if ( $(this).data('parent') ) {

      var parent = $(this).data('parent'),
          state = $(this).data('state'),
          parent_state = $("[name='" + parent + "']:checked").val();

      if (parent_state != state) {
        $(this).hide(0);
      }

    }
  });

    $("#location").live("keyup", function(event, ui) { // button changer
      var name = $(this).val();
      var exploded = name.split(',');

      if ($.isNumeric(exploded[0]) && $.isNumeric(exploded[1])) {
        $("#coordinates").find('.lat').text(exploded[0]);
        $("#coordinates").find('.lon').text(exploded[1]);
        $("#location_lat").val(exploded[0]);
        $("#location_lng").val(exploded[1]);
      } else {
        $.getJSON("//maps.google.com/maps/api/geocode/json?address="+name+"&sensor=false",function(data) {
          var location = data.results[0].geometry.location;
            $("#coordinates").find('.lat').text(location.lat);
            $("#coordinates").find('.lon').text(location.lng);
            $("#location_lat").val(location.lat);
            $("#location_lng").val(location.lng);
        });
      }
    });

    // hightlight menu items
    $(".layout_build").hover(function() {
        $('#subtab-AdminPspagebuilderManagement').addClass('hightlight-item hover');
      },function(){
        $('#subtab-AdminPspagebuilderManagement').removeClass('hightlight-item hover');
    });
    //

    $(".module-icon").hover(function() {
        $(this).parent().find(".module-preview").removeClass('hide');
      },function(){
        $(this).parent().find(".module-preview").addClass('hide');
    });
    
    $(".preset-image").click(function(){
      $('.preset-image').removeClass('selected');
      $(this).addClass('selected');
    });

    // used in radio_image.tpl
    $('.import-preset').click(function(){
      $('.preset-import').toggle();
    });

    // used in date.tpl
    $(function(){
      $(".datepicker").datepicker();
    });

    // used in theme_update.tpl
    var $cubtn = $('.check_updates');
    var $epid = $('.empty_pid');
    var pid = $('#gs_envato_purchase_id').val();

    if (pid === '') {
      $cubtn.hide();
      $epid.show();
    }

    $cubtn.click(function(){
      requestTfItemDetails(pid);
    });

    function successCallback() {

    }

});

function showErr(txt) {
  $('.update-unavailable .like-label').text(txt);
  $('.update-unavailable').show();
  $('.check_updates').hide();
  $('.theme_update').css({'background': '#ff9933'})
}

function requestTfItemDetails(purchaseid) {
  var newVersion = $('input[name="versions"]').val();
  $.ajax({
    type: "GET",
    url: 'https://promokit.eu/envato.php',
    data: "code="+purchaseid+'&ver='+newVersion,
    success: function(response) {

      $('#item_key').val(response);
      
      if (response === 'error') {
        showErr('Something goes wrong, pelase try again');
      } else {
        if (response !== '') {
          $.ajax({
            type: "POST",
            headers: { "cache-control": "no-cache" },
            async: false,
            url: tsDir + 'ajax.php',
            data: "action=getUpdates",
            success: function(data) {
              var d = jQuery.parseJSON(data);
              $('.check_updates').hide();
              if (d === "") {
                $('.update-unavailable').show();
              } else if (d.length < 70) {
                $('.versions-list').text(d);
                $('.update-available').show();
                $('.theme_update').addClass('available-update');
              } else {
                showErr('Update service is temporary unavailable! Please try again later.');
              }
            }
          });
        } else {
          showErr('Update service is temporary unavailable! Please try again later.');
        }
      }

    }
  });

}