// Generated by CoffeeScript 1.6.2
/*
countdown is a simple jquery plugin for countdowns

Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.

@source: http://github.com/rendro/countdown/
@autor: Robert Fleischmann
@version: 1.0.1
*/

(function(){!function(n){n.countdown=function(t,e){var r,o=this;return this.el=t,this.$el=n(t),this.$el.data("countdown",this),this.init=function(){return o.options=n.extend({},n.countdown.defaultOptions,e),o.options.refresh&&(o.interval=setInterval(function(){return o.render()},o.options.refresh)),o.render(),o},r=function(t){var e,r;return t=Date.parse(n.isPlainObject(o.options.date)?o.options.date:new Date(o.options.date)),(r=(t-Date.parse(new Date))/1e3)<=0&&(r=0,o.interval&&o.stop(),o.options.onEnd.apply(o)),e={years:0,days:0,hours:0,min:0,sec:0,millisec:0},r>=31557600&&(e.years=Math.floor(r/31557600),r-=365.25*e.years*86400),r>=86400&&(e.days=Math.floor(r/86400),r-=86400*e.days),r>=3600&&(e.hours=Math.floor(r/3600),r-=3600*e.hours),r>=60&&(e.min=Math.floor(r/60),r-=60*e.min),e.sec=r,e},this.leadingZeros=function(n,t){for(null==t&&(t=2),n=String(n);n.length<t;)n="0"+n;return n},this.update=function(n){return o.options.date=n,o},this.render=function(){return o.options.render.apply(o,[r(o.options.date)]),o},this.stop=function(){return o.interval&&clearInterval(o.interval),o.interval=null,o},this.start=function(t){return null==t&&(t=o.options.refresh||n.countdown.defaultOptions.refresh),o.interval&&clearInterval(o.interval),o.render(),o.options.refresh=t,o.interval=setInterval(function(){return o.render()},o.options.refresh),o},this.init()},n.countdown.defaultOptions={date:"June 7, 2087 15:03:25",refresh:1e3,onEnd:n.noop,render:function(t){return n(this.el).html(t.years+" years, "+t.days+" days, "+this.leadingZeros(t.hours)+" hours, "+this.leadingZeros(t.min)+" min and "+this.leadingZeros(t.sec)+" sec")}},n.fn.countdown=function(t){return n.each(this,function(e,r){var o;if(!(o=n(r)).data("countdown"))return o.data("countdown",new n.countdown(r,t))})}}(jQuery)}).call(this);

/**
 * Copyright 2012, Digital Fusion
 * Licensed under the MIT license.
 * http://teamdf.com/jquery-plugins/license/
 *
 * @author Sam Sehnert
 * @desc A small plugin that checks whether elements are within
 *       the user visible viewport of a web browser.
 *       only accounts for vertical position, not horizontal.
 */
(function($){var $w=$(window);$.fn.visible=function(partial,hidden,direction){if(this.length<1)
return;var $t=this.length>1?this.eq(0):this,t=$t.get(0),vpWidth=$w.width(),vpHeight=$w.height(),direction=(direction)?direction:'both',clientSize=hidden===!0?t.offsetWidth*t.offsetHeight:!0;if(typeof t.getBoundingClientRect==='function'){var rec=t.getBoundingClientRect(),tViz=rec.top>=0&&rec.top<vpHeight,bViz=rec.bottom>0&&rec.bottom<=vpHeight,lViz=rec.left>=0&&rec.left<vpWidth,rViz=rec.right>0&&rec.right<=vpWidth,vVisible=partial?tViz||bViz:tViz&&bViz,hVisible=partial?lViz||rViz:lViz&&rViz;if(direction==='both')
return clientSize&&vVisible&&hVisible;else if(direction==='vertical')
return clientSize&&vVisible;else if(direction==='horizontal')
return clientSize&&hVisible}else{var viewTop=$w.scrollTop(),viewBottom=viewTop+vpHeight,viewLeft=$w.scrollLeft(),viewRight=viewLeft+vpWidth,offset=$t.offset(),_top=offset.top,_bottom=_top+$t.height(),_left=offset.left,_right=_left+$t.width(),compareTop=partial===!0?_bottom:_top,compareBottom=partial===!0?_top:_bottom,compareLeft=partial===!0?_right:_left,compareRight=partial===!0?_left:_right;if(direction==='both')
return!!clientSize&&((compareBottom<=viewBottom)&&(compareTop>=viewTop))&&((compareRight<=viewRight)&&(compareLeft>=viewLeft));else if(direction==='vertical')
return!!clientSize&&((compareBottom<=viewBottom)&&(compareTop>=viewTop));else if(direction==='horizontal')
return!!clientSize&&((compareRight<=viewRight)&&(compareLeft>=viewLeft))}}})(jQuery);

$(document).ready(function() {

    var is_touch_device = 'ontouchstart' in document.documentElement,
        timer,
        dd_cont = '.dd_container',
        dd_el_hover = '.dd_el_hover',
        dd_el = '.dd_el',
        w = $(window).width();

    $(document).on("mouseenter", dd_el, function() {
        if ($(this).not('.parent')) {
            clearTimeout(timer);
            $(dd_cont).not($(this).parent().not(dd_el_hover)).stop().slideUp(200, 'easeOutExpo');
            $(this).children(dd_cont).stop().slideDown(500, 'easeOutExpo');
            $(this).addClass('dd_el_hover');
        }
    });

    $(document).on("mouseleave", dd_el, function() {
        if ($(this).not('.parent')) {
            var $self = $(this).children(dd_cont);
            timer = setTimeout(function() {
                $self.stop().slideUp(200, 'easeOutExpo');
            }, 500);
            $(this).removeClass('dd_el_hover');
        }
    });

    // grid/list view. change DOM
    //if (listing_view_buttons == true) {

        var $list_btn = $("#view_list"),
            $grid_btn = $("#view_grid"),
            $products = $("#products"),
            $product_list = $(".product_list");

        $(document).on("click", ".view_btn", function(e) {
            $('.view_btn').removeClass("active");
            if ($(this).is("#view_grid")) {
                $(this).addClass("active");
                $products.addClass("view_grid").removeClass("view_list");
                $product_list.animate({opacity: "0"}, 0);
                $product_list.delay(200).animate({opacity: "1"}, 300);
            }
            if ($(this).is("#view_list")) {
                $(this).addClass("active");
                $products.addClass("view_list").removeClass("view_grid");
                $product_list.animate({opacity: "0"}, 0);
                $product_list.delay(200).animate({opacity: "1"}, 300);
            }
        });

        

    //}

    $('#search_block_top').hover(
        function () {
            $(this).addClass("hvr");
            $(".ac_results").removeClass('hidden');
        },
        function () {
            $(this).delay(200).removeClass("hvr");
    });

    $(document).on("mouseover", ".ac_results", function(e) {
        $('#search_block_top').addClass("hvr");
    });
    $(document).on("mouseleave", ".ac_results", function(e) {
        $('#search_block_top').delay(200).removeClass("hvr");
        $(this).addClass('hidden');
    });

    // #scroll
    if ( $('#scrollTop')[0] ) {

        $(window).scroll(function () {
            var position = $("#scrollTop").offset();

            //$("#scrollTop").text(position.top);
            if (position.top < 1200) {
                $("#scrollTop").fadeOut(600);
            } else {
                $("#scrollTop").fadeIn(600);
            }
        });

        $("#scrollTop a").click(function(){
            $("html, body").animate({ scrollTop: 0 }, "slow");
            return false;
        });

    }

    // #menu
    if (typeof theme_cfg !== 'undefined') {

        if (theme_cfg.gs_sticky_menu == 1) {

            $('#header').height($('#header').height());
            var sticky_sect = $('.header-main'),
                ht = theme_cfg.header_type;

            if (ht == 1 || ht == 5) {
                var sticky_sect = $('.header-main');
            }
            if (ht == 2 || ht == 3) {
                var sticky_sect = $('#pk_top_sticky_sect');
            }
            if (ht == 4 || ht == 7) {
                var sticky_sect = $('.header-bottom');
            }
            if (ht == 6) {
                $('#header .header-main').height($('#header .header-main').height());
                var sticky_sect = $('.header-main-back');
            }

            if ($('#header').children().hasClass('headerbuilder')) {
                var sticky_sect = $('.headerbuilder');
            }

            if (typeof theme_cfg.gs_sticky_menu_class !== 'undefined' && theme_cfg.gs_sticky_menu_class !== '') {
                var sticky_sect = $('.'+theme_cfg.gs_sticky_menu_class);
            }

            if ( sticky_sect[0] && ($(window).width() > 980)) {
                var stickyNavTop = sticky_sect.offset();
                var stickyNav = function(){
                    var scrollTop = $(window).scrollTop();
                    if (scrollTop > stickyNavTop.top) {
                        sticky_sect.addClass('sticky');
                    } else {
                        sticky_sect.removeClass('sticky');
                    }
                };

                stickyNav();
                $(window).scroll(function() {
                    stickyNav();
                });
            }
        }
    }

    $(function(){
        $('.sections-titles .page-product-heading').click(function(){
            $(".sections-titles h3").removeClass("active");
            $(this).addClass("active");
            var labelId = $(this).data("tab-label");
            $(".sections").find("[data-tab]").fadeOut(200, function () {
                $(this).addClass("d-hidden");
            });
            $(".sections").find('[data-tab='+labelId+']').delay(200).fadeIn(400, function () {
                $(this).removeClass('d-hidden');
            });
        });
    });

    $(".accordionButton").click(function(){
        var accid = $(this).data("tab-acc");
        var th = $(".tab-slider-wrapper").find('[data-acc='+accid+']');
        if ($(th).hasClass("show")) {
            $(th).removeClass("show");
        } else {
            $(".accordionContent").removeClass("activeCarousel");
            $(".tab-slider-wrapper").find('[data-acc='+accid+']').addClass("activeCarousel");
        }
    });

    if ( $('.cat_image')[0] ) {
        BackgroundCheck.init({
          targets: '.cat_desc',
          images: '.cat_image'
        });
    }

    var $cBlock = $('.cookie-message');
    $(".cookie-message .btn").click(function(){
        $cBlock.animate({'bottom':'-100px', 'opacity':'0'}, 500);
        $.cookie("cookie-message", "0"); // set cookie
    });

    if ( ($.cookie("cookie-message") == 1) || ($.cookie('cookie-message') === null) ) {
        setTimeout(function() {
            $cBlock.animate({'bottom':'0', 'opacity':'1'}, 500);
        }, 4000);
    }

    // countdown all
    jQuery.each( $('.countdown'), function( i, el ) {

        var titles = $(el).data('titles'),
            date = $(el).data('until'),
            product_id = $(el).data('product_id');

        $(function() {
          $('.countdown-'+product_id).countdown({
            date: date,
            render: function(data) {
            $(this.el).html("<div><i>" + this.leadingZeros(data.days, 2) + "</i><span>"+titles.day+"</span></div><div><i>" + this.leadingZeros(data.hours, 2) + "</i><span>"+titles.hour+"</span></div><div><i>" + this.leadingZeros(data.min, 2) + "</i><span>"+titles.minute+"</span></div><div><i>" + this.leadingZeros(data.sec, 2) + "</i><span>"+titles.second+"</span></div>");
            }
          });
        });

    });

});
