<?php

include_once(_PS_MODULE_DIR_.'pk_themesettings/pk_themesettings.php');

class configHelper extends Module {

    public function getSliders()
    {
        $sliders = array();
        $exclude = array();
        $presets = $this->presets();

        asort($presets);
        
        foreach ($presets as $key => $preset) {
            if (!in_array($preset, $exclude)) {
                $sliders[$key] = ucfirst($preset);
            }
        }
        return $sliders;
    }

	public function presets()
    {
        $presets_dir = _PS_MODULE_DIR_.'/pk_themesettings/presets';
        $presets_list = array();
        if ($handle = opendir($presets_dir)) {

            while (false !== ($file = readdir($handle))) {

                if ($file != "." && $file != ".." && strtolower(substr($file, strrpos($file, '.') + 1)) == 'json') {
                    if (filesize($presets_dir.'/'.$file) != false) {
                        $alias = str_replace('.json', '', $file);
                        $name = str_replace(array('_', '-'), ' ', $alias);
                        $presets_list[$alias] = $name;
                    }
                }
            }
            closedir($handle);
        }

        asort($presets_list);

		return $presets_list;
	}

	public function fontslist()
    {
		$fonts_list = array();
		$fonts = get_fonts();

		foreach ($fonts as $font_name) {
			$fonts_list[$font_name] = $font_name;
		}

		return $fonts_list;
	}

	public function font_weight()
    {
    	$list = array(
    		'100' => '100, Thin',
    		'200' => '200, Extra Light',
    		'300' => '300, Light',
    		'400' => '400, Normal',
    		'500' => '500, Medium',
    		'600' => '600, Semi Bold',
    		'700' => '700, Bold',
    		'800' => '800, Extra Bold',
    		'900' => '900, Black',
    	);
    	return $list;
    }

    public function font_style() {
    	$list = array(
    		'normal' => 'Normal',
    		'italic' => 'Italic',
    	);
    	return $list;
    }

    public function text_transform() {
    	$list = array(
    		'none' => 'None',
    		'uppercase' => 'Uppercase',
    		'lowercase' => 'Lowercase',
    		'capitalize' => 'Capitalize',
    	);
    	return $list;
    }

    public function typography_defaults() {
    	$list = array(
            'font_size'   	=> '13',
            'font_family' 	=> 'Arial',
            'font_weight' 	=> '400',
            'font_style' 	=> 'normal',
            'line_height' 	=> '1',
            'text_transform'=> 'none',
            'color'       	=> '#bdbdbd',
            'letter_spacing'=> '0'
        );
        return $list;
    }

    public function typography_options() {
    	$list = array(
        	'font_family' => $this->fontslist(),
        	'font_weight' => $this->font_weight(),
        	'font_style' => $this->font_style(),
        	'text_transform' => $this->text_transform(),
        );
        return $list;
    }

    public function checkupdates() {

        $update_list = "https://alysum5.promokit.eu/promokit/updates/versions.dat";
        $msg = "";
        if (!$update = @file_get_contents($update_list)) {
            $msg = false;
        } else {
            $versions = explode(",", $update);
            $i = 1;
            foreach ($versions as $key => $version) {
                if (_ALYSUM_VER_ < $version) {
                    $msg .= (($i == 1) ? "" : ",").$version;
                    $i++;
                }
            }
        }

        return $msg;
    }

    public function getPageBuilderLayouts() {

        $list = array('0' => 'Default');
        
        if (Module::isInstalled('pspagebuilder')) {

            require_once(_PS_MODULE_DIR_.'pspagebuilder/classes/profile.php');
            $profile = new PsPagebuilderprofile();
            $listRaw = $profile->getList();

            foreach ($listRaw as $key => $item) {
                $list[$item['id_pagebuilderprofile']] = $item['name'];
            }

        }
        return $list;
    }

    public function getCMSPagesList() {

        $list = array('0' => 'Cookie External Link (Default)');
        $listRaw = CMS::listCms();
        foreach ($listRaw as $key => $item) {
            $list[$item['id_cms']] = $item['meta_title'];
        }
        return $list;
    }

    public function getState()
    {
        $state = $this->getModulesState();
        $html = $this->generateStateHTML($state);
        return $html;
    }

    public function generateStateHTML($state)
    {
        $html = '<div>';
        $html .= '<ul class="state-monitor">';
        foreach ($state as $module_name => $module_state) {
            $html .= '<li>';
            $html .= '<strong>'.$module_name.'</strong>';
            $html .= '<div class="current-module-state">';
            $html .= '<div>State:</div>';
            $html .= '<ul>';
            if ($module_state['state']['installed']) {
                $html .= '<li class="state-good">Installed: <strong>Yes</strong></li>';
            } else {
                $html .= '<li class="state-bad">Installed: <strong>No</strong></li>';
            }
            if ($module_state['state']['enabled']) {
                $html .= '<div class="state-good">Enabled: <strong>Yes</strong></div>';
            } else {
                $html .= '<div class="state-bad">Enabled: <strong>No</strong></div>';
            }
            $html .= '</ul>';
            $html .= '<div>Hooks:</div>';
            $html .= '<ul>';
            if (isset($module_state['hooks']) && !empty($module_state['hooks'])) {
            foreach ($module_state['hooks'] as $hook_name => $hook_state) {
                if ($hook_state) {
                    $html .= '<div class="state-good"><svg class="svgic"><use xlink:href="#si-done"></use></svg>'.$hook_name.'</div>';
                } else {
                    $html .= '<div class="state-bad"><svg class="svgic"><use xlink:href="#si-cross"></use></svg>'.$hook_name.'<i>&nbsp;&larr; (The module should be transplanted to this hook)</i></div>';
                }
            }
            }
            $html .= '</ul>';
            $html .= '</div>';
            $html .= '</li>';
        }
        $html .= '</ul>';
        $html .= '</div>';
        return $html;
    }

    public function getModulesState()
    {
        $theme_modules = $this->context->shop->theme->getModulesToEnable();
        $state = array();
        $exclude = array('contactform', 'pk_contact', 'pk_emailcontrol', 'ps_facetedsearch');
        foreach ($theme_modules as $key => $module) {
            if (!in_array($module, $exclude)) {
                $module_instance = Module::getInstanceByName($module);
                $module_hooks = $this->getHooksList($module_instance);
                foreach ($module_hooks as $key => $hook) {
                    if (
                        ((strpos($hook['name'], 'displayAdmin') === false) && 
                        (strpos($hook['name'], 'display') !== false) && 
                        (strpos($hook['name'], 'displayMobile') === false)) ||
                        (strpos($hook['name'], 'displayAdminProductsExtra') !== false) || 
                        (strtolower($hook['name']) == 'header')
                       ) 
                    {
                        $state[$module]['hooks'][$hook['name']] = $module_instance->isRegisteredInHook($hook['name']);
                    }
                }
                $state[$module]['state']['installed'] = Module::isInstalled($module);
                $state[$module]['state']['enabled'] = Module::isEnabled($module);
            }
        }
        return $state;
    }

    public function getHooksList($module)
    {
        $hooks_list = Hook::getHooks();
        $possible_hooks_list = array();
        foreach ($hooks_list as &$current_hook) {
            $hook_name = $current_hook['name'];
            $retro_hook_name = Hook::getRetroHookName($hook_name);

            if (is_callable(array($module, 'hook' . ucfirst($hook_name))) || is_callable(array($module, 'hook' . ucfirst($retro_hook_name)))) {
                $possible_hooks_list[] = array(
                    'id_hook' => $current_hook['id_hook'],
                    'name' => $hook_name,
                    'title' => $current_hook['title'],
                );
            }
        }

        return $possible_hooks_list;
    }

}