<?php

if (!defined('_PS_VERSION_')) exit;

class InstallDemoData extends Module
{

	public function start($preset) {

		//$this->truncate();
		$module = 'revsliderprestashop';
		if (Module::isEnabled($module)) {
			$installFiles = $this->copyFiles($preset);
			if ($installFiles != '') {
				$response = Module::displayError($installFiles);
			} else {
				$this->clearCache();
        $installBD = $this->installDB($preset);
        if ($installBD === true) {
          $response = Module::displayConfirmation('<strong>'.ucfirst($preset).'</strong> slider has been successfully imported');
        } else {
          $response = Module::displayError($installBD);
        }
			}
		} else {
			$response = Module::displayError('Revolution Slider is not installed');
		}

		return $response;

	}

  public function installDB($preset)
  {
    $sql_file = dirname(__FILE__).'/'.$preset.'.sql';

		if (!file_exists($sql_file)) {

			return 'There is no import file: '.$sql_file;

		} else if (!$sql = file_get_contents($sql_file)) {

			return 'SQL syntax error in import file: '.$sql_file;

		} else {

			$search = array('PREFIX_', 'SHOP_ID', 'LANG_ID');
			$replace = array(_DB_PREFIX_, $this->context->shop->id, $this->context->language->id);

			$queries = str_replace($search, $replace, $sql);
			$queries = preg_split("/;\s*[\r\n]+/", $queries);

			foreach ($queries AS $query) {

				if ($query) {

					try {
		        if (!Db::getInstance()->execute(trim($query))) {
							return 'Error in SQL syntax! '.$query;
						}
          } catch (\Exception $e) {
          	return 'Error in SQL syntax!';
          }

				}
			}
		}

		return true;

  }

  public function copyFiles($preset)
  {
  	$remote_file = 'https://alysum5.promokit.eu/promokit/dummy/'.$preset.'.zip';
  	$local_file = _PS_UPLOAD_DIR_.'files.zip';

    $msg = '';
		if (!@copy($remote_file, $local_file)) {
			$msg .= "Slider \"".$preset."\" is not available";
		} else {
			if (!Tools::ZipTest($local_file)) {
				$msg .= "Zip file seems to be broken";
			} else {
				$zip = new ZipArchive;
				$res = $zip->open($local_file);
				if ($res === TRUE) {
				  $zip->extractTo(_PS_MODULE_DIR_);
				  $zip->close();
				  //unlink($local_file);
				} else {
				  $msg .= "Unable to unzip updated files!";
				}
			}
		}
		return $msg;

  }

  public function clearCache()
  {
  	$modules = array('ps_customtext', 'pk_textblock');
  	foreach ($modules as $module) {
  		$templateFile = 'module:'.$module.'/'.$module.'.tpl';
  		$this->_clearCache($templateFile);
  	}
  }

  public function truncate()
  {
  	$sqls = array(
  		'TRUNCATE `ps_revslider_attachment_images`',
  		'TRUNCATE `ps_revslider_sliders`',
  		'TRUNCATE `ps_revslider_slides`'
  	);
  	foreach ($sqls as $sql) {
  		Db::getInstance()->execute($sql);
  	}
  }

}
