<?php
/**
* Promokit Theme Settings
*
* @package   alysum
* @version   1.8.8
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/
if (!defined('_PS_VERSION_')) exit;
if (!defined('_ALYSUM_VER_')) define('_ALYSUM_VER_', '5.3.5');

include_once(_PS_MODULE_DIR_.'pk_themesettings/inc/config.php');
include_once(_PS_MODULE_DIR_.'pk_themesettings/inc/confighelper.php');
include_once(_PS_MODULE_DIR_.'pk_themesettings/inc/fontlist.php');

class Pk_ThemeSettings extends Module
{
  public function __construct()
  {
    $this->name = 'pk_themesettings';
    $this->displayName = 'Theme Settings';
    $this->description = 'Extended Settings of Your Theme';
    $this->version = "1.8.8";
    $this->theme_name = "Alysum";
    $this->versions = 'TS v.'.$this->version.' | '.$this->theme_name.' v.'._ALYSUM_VER_.' | PS v.'._PS_VERSION_;
    $this->author = 'promokit.eu';
    $this->need_instance = 0;
    $this->bootstrap = true;

    parent::__construct();

    $this->mdb = _DB_PREFIX_.'pk_theme_settings';
    $this->hdb = _DB_PREFIX_.'pk_theme_settings_hooks';

    $this->default_config = $this->local_path.'presets/alysum.json';
    $this->customer_config = $this->local_path.'presets/customer_config.json';
    $this->customcssFile = $this->local_path."assets/css/dynamic/customercss".(int)Context::getContext()->shop->id.".css";
    $this->customjsFile = $this->local_path."assets/js/customerjs_shopid".(int)Context::getContext()->shop->id.".js";
    $this->generatedFile = $this->local_path."assets/css/dynamic/generatedcss".(int)Context::getContext()->shop->id.".css";

    $this->template['main'] = 'module:'.$this->name.'/views/admin/main.tpl';
  }

  public function install()
  {
    if (parent::install() &&
      $this->registerHook('displayHeader') &&
      $this->registerHook('comingsoon') &&
      $this->registerHook('footer_bottom') &&
      $this->registerHook('displayBeforeBodyClosingTag') &&
      $this->createTables() &&
      $this->installDB() &&
      $this->addTab()
    ) {
      return true;
    } else {
      $this->uninstall();
      return false;
    }
  }

  public function createTables()
  {
    $tables = dirname(__FILE__).'/sql/install.sql';
    if (!file_exists($tables)) {

      return $this->displayError($this->l('There is no sql file'));

    } else if (!$sql = file_get_contents($tables)) {

      return $this->displayError($this->l('There is no sql code'));

    } else {

      $queries = str_replace(array('PREFIX_', 'ENGINE_TYPE'), array(_DB_PREFIX_, _MYSQL_ENGINE_), $sql);
      $queries = preg_split("/;\s*[\r\n]+/", $queries);
      foreach ($queries AS $query) {
        if (!empty($query)) {
          if(!Db::getInstance()->execute(trim($query))) {
            return $this->displayError($this->l('Error in SQL syntax of Tables'));
          }
        }
      }

    }
    return $this->displayConfirmation($this->l('Demo Data Installed Successfully'));
  }

  public function installDB()
  {  
    $sql = array();
    $sid = (int)Shop::getContextShopID();
    $start = 'INSERT INTO `'.$this->mdb.'` (`id_shop`, `name`, `value`) VALUES ';
    $start_hook = 'INSERT INTO `'.$this->hdb.'` (`id_shop`, `hook`, `module`, `ordr`, `value`) VALUES ';

    $string = file_get_contents($this->default_config);
    $json_arr = json_decode($string, true);
    if ($json_arr === null) {
      return $this->displayError($this->l('Config file has syntax error'));
    }

    $sqlPart = $sqlHookPart = '';
    foreach ($json_arr as $name => $value) {
      if ($name == "modules") {
        foreach ($value as $hook => $modules) {
          foreach ($modules as $module => $val) {
            $vals = explode(".", $val);
              $sqlHookPart .= '('.$sid.', "'.$hook.'", "'.$module.'", "'.$vals[0].'", "'.$vals[1].'"),';

              if (($id_hook = Hook::getIdByName($hook)) !== false) {
              $mInstance = Module::getInstanceByName($module);
              if (Validate::isLoadedObject($mInstance)) {
                $position = $mInstance->getPosition($id_hook);
                $way = (($vals[0] >= $position) ? 1 : 0);

                if ($position) {
                  $mInstance->updatePosition($id_hook, $way, $vals[0]);
                }

                if ($vals[1] == 0) {
                  $mInstance->disable();
                } else {
                  $mInstance->enable();
                }
              }
            }
          }
        }

      } else {

        if (is_array($value)) {
          $line = "{";
          foreach ($value as $k => $v) {
            $line .= "&quot;".$k."&quot;:&quot;".$v."&quot;,";
          }
          $line .= "}";
          $value = str_replace(',}', '}', $line);
        }
        $sqlPart .= '('.$sid.', "'.$name.'", "'.$value.'"),';
      }
    }

    $sqlPart = substr($sqlPart, 0, -1);
    $sqlHookPart = substr($sqlHookPart, 0, -1);
    $sql[] = $start.$sqlPart.";";
    $sql[] = $start_hook.$sqlHookPart.";";

    if (!$this->runSql($sql))
      return false;

    $this->saveAll();
    return true;
  }

  public function addTab()
  {
    $response = true;
    // First check for parent tab
    $parentTabID = Tab::getIdFromClassName('AdminPkMenu');

    if ($parentTabID) {
        $parentTab = new Tab($parentTabID);
    } else {
        $parentTab = new Tab();
        $parentTab->active = 1;
        $parentTab->name = array();
        $parentTab->class_name = "AdminPkMenu";
        foreach (Language::getLanguages() as $lang) {
            $parentTab->name[$lang['id_lang']] = "Promokit";
        }
        $parentTab->id_parent = 0;
        $parentTab->module ='';
        $response &= $parentTab->add();
    }

    // clear existing tab
    $this->deleteTabs();

    // Check for subtab
    $subTab = new Tab();
    $subTab->active = 1;
    $subTab->name = array();
    $subTab->class_name = "AdminPkThemeSettings";
    $subTab->icon = "explore";
    foreach (Language::getLanguages() as $lang) {
      $subTab->name[$lang['id_lang']] = "Theme Settings";
    }
    $subTab->id_parent = $parentTab->id;
    $subTab->module = $this->name;
    $response &= $subTab->add();

    return $response;
  }

  public function deleteTabs()
  {
    $idTab = Tab::getIdFromClassName('AdminPkThemeSettings');
    $tab = new Tab($idTab);
    $tab->delete();
  }

  public function uninstall()
  {
    $sql = array();
    $sql[] = 'DROP TABLE IF EXISTS `'.$this->mdb.'`';
    $sql[] = 'DROP TABLE IF EXISTS `'.$this->hdb.'`';

    if (!parent::uninstall() OR !$this->runSql($sql) OR !$this->deleteTabs()) {
        return false;
    }
    return true;
  }

  public function updateDBsettigs($new_config = false)
  {// $new_config - used when you need to change preset
    $config_file = $this->default_config;
    if ($new_config != false)
      $config_file = $this->local_path.'presets/'.$new_config.'.json';

    $sql = array();
    $sid = (int)Shop::getContextShopID();
    $string = file_get_contents($config_file);

    //$json_arr = json_decode(html_entity_decode($string), true);
    $json_arr = json_decode($string, true);
    if ($json_arr === null) {
      return $this->displayError($this->l('Config syntax error').' '.$config_file);
    }

    $s = $this->getOptions("updateDBsettigs");
    $s["modules"] = $this->getModulesState();

    $sqlPart = $sqlHookPart = '';

    foreach ($json_arr as $name => $value) {

      if ($name == 'modules') {

        if (!empty($value)) {
          foreach ($value as $hook => $modules) {
            foreach ($modules as $module => $val) {
              $vals = explode(".", $val);
              $update = $this->isRowExist('FROM `'.$this->hdb.'` WHERE `hook`="'.$hook.'" AND `module`="'.$module.'" AND `id_shop` = '.$sid);

              if ($update) {
                $sqlHookPart .= "UPDATE `".$this->hdb."` SET `value` = '".$vals[1]."', `ordr` = '".$vals[0]."' WHERE `hook` = '".$hook."' AND `module` = '".$module."' AND `id_shop` = '".$sid."';";
              } else {
                $sqlHookPart = 'INSERT INTO `'.$this->hdb.'` (`id_shop`, `hook`, `module`, `ordr`, `value`) VALUES ('.$sid.', "'.$hook.'", "'.$module.'", "'.$vals[0].'", "'.$vals[1].'");';
              }

            }
          }
        }

      } else {

        if (is_array($value)) {
          $value = json_encode($value);
        }
        $sqlPart .= "UPDATE `".$this->mdb."` SET `value` = '".$value."' WHERE `name` = '".$name."' AND `id_shop` = '".$sid."';";

      }

    }

    $sql[] = $sqlPart;
    $sql[] = $sqlHookPart;

    $this->runSql($sql);

    return;
  }

  public function runSql($sql)
  {
    //Db::getInstance()->query("FLUSH QUERY CACHE");
    foreach ($sql as $s) {
      if (!empty($s)) {
        if (!Db::getInstance()->Execute($s)) {
          return false;
        }
      }
    }
    return true;
  }

  public function installDemo($preset)
  {
    include_once(_PS_MODULE_DIR_.$this->name.'/inc/import/InstallDemoData.php');
    $import = new InstallDemoData();
    $response = $import->start($preset);
    return $response;
  }

  public function changeBuilderProfile($preset)
  {   
    if (Module::isInstalled('pspagebuilder')) {

      $t1 = _DB_PREFIX_.'pagebuilderprofile';
      $t2 = _DB_PREFIX_.'pagebuilderprofile_shop';
      $query = array();

      $query[] = 'UPDATE `'.$t1.'` prf INNER JOIN `'.$t2.'` prfs ON prfs.id_pagebuilderprofile = prf.id_pagebuilderprofile AND prfs.id_shop = '.$this->context->shop->id.' AND prf.name != "'.$preset.'" SET prf.isdefault = "0";';
      $query[] = 'UPDATE `'.$t1.'` prf INNER JOIN `'.$t2.'` prfs ON prfs.id_pagebuilderprofile = prf.id_pagebuilderprofile AND prfs.id_shop = '.$this->context->shop->id.' AND prf.name = "'.$preset.'" SET prf.isdefault = "1";';

      if ($this->runSql($query)) {
        return $this->displayConfirmation($this->l('Page Builder Profile has been changed to "').$preset.'"');
      } else {
        return $this->displayError($this->l('Can not change Page Builder Profile to "').$preset.'"');
      }
    }
    return;
  }

  public function getContent()
  {
    $this->injectDisplayBackOfficeHeader();

    $s = $this->getOptions("getContent");
    $sid = $this->context->shop->id;

    $msg = '';

    if (Tools::isSubmit('dc_preset_to_import_submit')) {
      $msg .= $this->installDemo(Tools::getValue("dc_preset_to_import"));
    }

    if (Tools::isSubmit('removePreset')) {
      if (isset($_POST['removePreset'])) {
        $preset = $this->local_path.'presets/'.$_POST['removePreset'].'.json';
        $this->deleteFile($preset);
      }
    }

    if (Tools::isSubmit('savePreset'))  {
      //$s = $this->getOptions();
      $s['preset'] = 'customer_config';
      $s['modules'] = $this->getModulesState();
      $json = json_encode($s);

      $this->savePreset($this->customer_config, $json);
    }

    if (Tools::isSubmit('resetThemeSettings'))  {
      $this->updateDBsettigs();
      $this->saveAll();
      $msg .= $this->displayConfirmation($this->l('Settings has beedn reseted'));
    }

    if (Tools::isSubmit('savePresetToFile')) {
      $json = Tools::getValue("preset_to_import");
      $config = json_decode($json);
      if (isset($config->preset)) {
        $this->savePreset($this->local_path.'presets/'.$config->preset.'.json', $json);
      } else {
        $msg .= $this->displayError($this->l('There is an error in preset'));
      }
    }

    if (Tools::isSubmit('submitThemeSettings')) {
      unset($_POST['submitThemeSettings']);
      unset($_POST['savePreset']);
      unset($_POST['removePreset']);
      unset($_POST['importPreset']);
      unset($_POST['savePresetToFile']); // exclude submit button values

      $optionsToSave = $_POST;
      $sql = array();

      if (isset($optionsToSave['preset'])) {
        if ($optionsToSave['preset'] != $s['preset']) {

          $msg .= $this->updateDBsettigs($optionsToSave['preset']); // update preset
          $optionsToSave = $this->getOptions("getContent.new_preset");
          $msg .= $this->changeBuilderProfile($optionsToSave['preset']);
          $this->saveAll(true);

        }
      }

      if (isset($optionsToSave['pp_builder_layout'])) {
        Configuration::updateValue('pp_builder_layout', $optionsToSave['pp_builder_layout']);
      }

      foreach ($optionsToSave as $key => $value) {

        if (($key != "mt_maintenance") && ($key != "customer_css") && ($key != "customer_js") && ($key != "modules") && ($key != "ordr")) {
          if (is_array($value)) {
            $value = htmlspecialchars(json_encode($value), ENT_COMPAT,'UTF-8', true);
          }
          $value = str_replace('"', '\'', $value);

          $update = $this->isRowExist('FROM `'.$this->mdb.'` WHERE name = "'.$key.'" AND id_shop = '.$sid);

          if ($update) {
            $sql[] = 'UPDATE `'.$this->mdb.'` SET value = "'.$value.'" WHERE name = "'.$key.'" AND id_shop = '.$sid.';';
          } else {
            $sql[] = 'INSERT INTO `'.$this->mdb.'` (`id_shop`, `name`, `value`) VALUES ('.$sid.', "'.$key.'", "'.$value.'");';
          }

          if ($key == "amp_enable") {
            if ($value == 1) {
              if (!Module::isInstalled('pk_amp')) {
                $mInstance = Module::getInstanceByName('pk_amp');
                $mInstance->install();
              }
              Module::enableByName('pk_amp');
            } else {
              Module::disableByName('pk_amp');
            }
          }

        } elseif ($key == "mt_maintenance") {

          Configuration::updateValue('PS_SHOP_ENABLE', $value);

        } elseif ($key == "customer_css") {

          $msg .= $this->cssWriter($value);

        } elseif ($key == "customer_js") {

          $msg .= $this->jsWriter($value);

        } elseif ($key == "modules") {

          foreach ($value as $hook => $modules) {
            foreach ($modules as $module => $val) {

              if ($this->isPkModules($module)) {
                $update = $this->isRowExist('FROM `'.$this->hdb.'` WHERE hook = "'.$hook.'" AND module = "'.$module.'" AND id_shop = '.$sid);
              } else {
                $update = true;
              }

              if ($update) {
                $sql[] = 'UPDATE `'.$this->hdb.'` SET `ordr` = "'.(int)$optionsToSave["ordr"][$hook][$module].'", value = '.(int)$val.' WHERE hook = "'.$hook.'" AND module = "'.$module.'" AND id_shop = '.$sid.';';
              } else {
                $sql[] = 'INSERT INTO `'.$this->hdb.'` (`id_shop`, `hook`, `module`, `ordr`, `value`) VALUES ('.$sid.', "'.$hook.'", "'.$module.'", "'.(int)$optionsToSave["ordr"][$hook][$module].'", "'.(int)$val.'");';
              }

            }
          }

        }

      }

      $this->runSql($sql);
      $this->saveAll();

      $msg .= $this->displayConfirmation($this->l('Settings updated'));

    }

    if (Tools::isSubmit('theme_update')) {
      $list = Tools::getValue("versions");
      $versions = explode(",", $list);
      foreach ($versions as $version) {
        $msg .= $this->themeUpdate($version);
      }
    }

    if (Tools::isSubmit('mt_sendnotification')) {
      $msg .= $this->sendNotification();
    }

    return $this->displayForm($msg);
  }

  public function savePosition($num)
  {
    $sql = array('UPDATE `'.$this->mdb.'` SET value = "'.$num.'" WHERE name = "tab_number" AND id_shop = '.(int)Context::getContext()->shop->id.';');
    $this->runSql($sql);
  }

  public function savePreset($file, $data)
  {
    $fp = fopen($file, 'w');

    if (fwrite($fp, $data) === FALSE) {
      return $this->displayError("Can not save preset", array(), 'Modules.Pk_ThemeSettings.Admin');
    }

    fclose($fp);
    return true;
  }

  public function deleteFile($file)
  {
    if (file_exists($file)) {
        return unlink($file);
    }
  }

  public function saveAll($modules = false)
  {
    if ($modules) {
      $this->updateModulesState();
    }

    $theme_settings = $this->getOptions("prepare_smarty");

    $tabId = Tools::getValue('tab_number');
    if (empty($tabId)) {
      $tabId = 1;
    }
    $this->savePosition($tabId); // save back office active tab
    $this->cssWriter();
    // assign global variables to see them in any place of the theme
    $this->setGlobalVars($theme_settings, true);

    $this->_clearCache('*');
  }

  public function isRowExist($sql)
  {
    $check_module = Db::getInstance()->ExecuteS('SELECT EXISTS(SELECT 1 '.$sql.');');
    return reset($check_module[0]);
  }

  public function sendNotification()
  {
    $readyEmails = $this->getEmails();
    $sid = $this->context->shop->id;
    $lid = $this->context->language->id;
    $vars = array();

    if (Configuration::get('PS_LOGO_MAIL') !== false && file_exists(_PS_IMG_DIR_.Configuration::get('PS_LOGO_MAIL', null, null, $sid)))
      $logo = _PS_IMG_DIR_.Configuration::get('PS_LOGO_MAIL', null, null, $sid);
    else {
      if (file_exists(_PS_IMG_DIR_.Configuration::get('PS_LOGO', null, null, $sid)))
        $logo = _PS_IMG_DIR_.Configuration::get('PS_LOGO', null, null, $sid);
      else
        $vars['{shop_logo}'] = '';
    }
    ShopUrl::cacheMainDomainForShop($sid);
    /* don't attach the logo as */

    if (isset($logo))
      $vars['{shop_logo}'] = ImageManager::getMimeTypeByExtension($logo);
    $vars['{email_menu_item}'] = 'color:#ffffff; font-size:15px; line-height:46px; mso-line-height-rule:exactly; font-family: \'Times new roman\'; text-transform:uppercase; text-decoration:none;';
    $vars["{shop_name}"] = Configuration::get('PS_SHOP_NAME');
    $vars["{shop_url}"] = Context::getContext()->link->getPageLink('index', true, $lid);

    $response = Mail::Send(
      $lid,
      'opening',
      Mail::l('Shop Opening', $lid),
      $vars,
      $readyEmails,
      null,
      null,
      null,
      null,
      null,
      _PS_MODULE_DIR_.$this->name."/mails/",
      false,
      $sid
    );

    if ($response == 0) {
      $msg = $this->displayError("Email has not been sent");
    } else {
      $msg = $this->displayConfirmation("Notification has been sent");
    }
    return $msg;

  }

  public function getEmails()
  {
    $file = _PS_MODULE_DIR_.$this->name."/maintenance/emails.txt";
    $filtered = array();

    if (!$fileHolder = @fopen($file, 'r')) {
      $readyEmails = "Cant open storage file";
    } else {
      $readyEmails = "";
      $filecontents = file_get_contents($file);
      $emails = explode(";", $filecontents);
      foreach ($emails as $email)
        if (Validate::isEmail($email))
          $filtered[] = $email;

      if (!empty($filtered))
        $readyEmails = array_unique($filtered);
      fclose($fileHolder);
    }
    return $readyEmails;
  }

  public function updateModulesState()
  {
    $mState = $this->getModulesState();
    $disabledList = $enabledList = array();
    // move module to necessary hooks if it is not there
    foreach ($mState as $hook => $modules) {
      foreach ($modules as $module => $state) {
        $val = explode(".", $state);
        if ($val[1] == 1) { // if module is enabled
          if (($id_hook = Hook::getIdByName($hook)) !== false) {
            $mInstance = Module::getInstanceByName($module);
            if (Validate::isLoadedObject($mInstance)) {
              $position = $mInstance->getPosition($id_hook);
              if (!$position && $hook != 'displayFooter') // if module is not in our hook
                if ($mInstance->isHookableOn($hook))
                  $mInstance->registerHook($hook);
            }
          }
        }
      }
    }

    // order modules like in config
    foreach ($mState as $hook => $modules) {
      foreach ($modules as $module => $state) {
        $val = explode(".", $state);
        if ($val[1] == 1) {
          if (($id_hook = Hook::getIdByName($hook)) !== false) {
            $mInstance = Module::getInstanceByName($module);
            if (Validate::isLoadedObject($mInstance)) {
              $position = $mInstance->getPosition($id_hook);
              $way = (($val[0] >= $position) ? 1 : 0);
              if ($position) {
                $mInstance->updatePosition($id_hook, $way, $val[0]);
              }
            }
          }
        }
        if ($val[1] == 0)
          $disabledList[$module] = $val[1];
        else
          $enabledList[$module] = $val[1];
      }
    }

    foreach ($disabledList as $name => $state)
      if (array_key_exists($name, $enabledList))
        unset($disabledList[$name]);

    foreach ($enabledList as $name => $state)
      if ($this->isEn($name) == "disabled") {
        $mInstance = Module::getInstanceByName($name);
        if (Validate::isLoadedObject($mInstance))
          $mInstance->enable();
      }

  }

  public function checkUpdates()
  {
    $configHelper = new configHelper();
    return $configHelper->checkupdates();
  }

  private function themeUpdate($ver)
  {
    $key = Tools::getValue('item_key');
    if ($key == 'error') {

      return $this->displayError("Purchase ID Error");

    } else {

      $archive = "https://alysum5.promokit.eu/promokit/updates/".$key."/".$ver.".zip";
      
      $filecontents = @file_get_contents($archive);

      if ($filecontents == false) {

        return $this->displayError("There is no file to update!");

      } else {

        $file = _PS_MODULE_DIR_.$this->name.'/update'.$ver.'.zip';

        if (!@copy($archive, $file)) {

          return $this->displayError("No update file to download");

        } else {

          if (!Tools::ZipTest($file)) {

            return $this->displayError("Unable to unzip update");

          } else {

            $zip = new ZipArchive;
            $res = $zip->open($file);
            $res = true;

            if ($res === TRUE) {

              $zip->extractTo(_PS_ROOT_DIR_.'/');
              $zip->close();
              unlink($file);
              $this->_clearCache('*');
              return $this->displayConfirmation("Theme has been successfully updated to version ".$ver.". Click \"Apply Settings\".");

            } else {

              return $this->displayError("Unable to unzip update");

            }
          }
        }
      }
    }

  }

  public function jsWriter($data = false)
  {
    return $this->writeFile($data, $this->customjsFile);
  }

  public function cssWriter($data = false)
  {
    $files = array();
    $response = '';

    if ($data != false) {
      $files[0] = $this->customcssFile;
    }

    $files[1] = $this->generatedFile;

    foreach ($files as $key => $file) {

      if ($key == 0)
        $styles = $data;
      if ($key == 1)
        $styles = $this->cssGenerator();

      $response .= $this->writeFile($styles, $file);
    }
    return $response;

  }

  public function writeFile($data, $file)
  {
    if (!$fileHolder = @fopen($file, 'w')) {

      return $this->displayError('Unable to open file '.$file);

    } else {
      if ($data == '') {
        unlink($file);
      } else {
        if (fwrite($fileHolder, $data) === FALSE) {
          fclose($fileHolder);
          return $this->displayError('Unable to save file '.$file);
        }
        fclose($fileHolder);
      }
    }

  }

  public function addUnitsforCSSRule($rule, $value)
  {
    $rules_with_units_px = array('font-size', 'height', 'max-width', 'width');
    $rules_with_units_em = array('letter-spacing', 'line-height');

    $unit = '';
    if (in_array($rule, $rules_with_units_px) && $value != 'auto') {
      $unit = 'px';
    }
    if (in_array($rule, $rules_with_units_em) && $value != 'auto') {
      $unit = 'em';
    }

    return $unit;
  }

  public function cssGenerator()
  {
    $conf = new Pk_ThemeSettings_Config();
    $pk_options = $conf->getOptionsArray();
    $db_options = $this->getOptions();
    $css = '';

    foreach($pk_options as $options) {

      foreach($options['options_list'] as $option) {

        if (isset($option['output']) && !empty($option['output'])) {

          $typo_css_rules = '';

          if ($option['type'] == 'typography') {

            foreach ($option['default'] as $typo_opt => $typo_val) {

              $rule = str_replace("_", "-", $typo_opt);

              if (!empty($db_options[$option['name']][$typo_opt])) {
                $typo_val = $db_options[$option['name']][$typo_opt];
              }

              if ($rule == 'font-family') {
                $typo_val = "'".$typo_val."'";
              }

              $unit = $this->addUnitsforCSSRule($rule, $typo_val);
              $typo_css_rules .= $rule.':'.$typo_val.$unit.';';

            }

          } else {

            $unit = '';
            $value = $db_options[$option['name']];

            if (isset($option['css_rule'])) {
              $unit = $this->addUnitsforCSSRule($option['css_rule'], $value);
            }

            if ($option['css_rule'] == 'font-family') {
              $value = "'".$db_options[$option['name']]."'";
            }
            $typo_css_rules = $option['css_rule'].":".$value.$unit;


          }

          $css .= $option['output']."{".$typo_css_rules."}\n";

        }
      }
    }

    return $css;
  }

  public function getOptions($who = false)
  {  // get options from database
    $s = array();
    $query = 'SELECT * FROM `'.$this->mdb.'` WHERE id_shop = '.(int)$this->context->shop->id.';';
    if (!$sett = Db::getInstance()->ExecuteS($query)) {
      $this->installDB();
      if (!$sett = Db::getInstance()->ExecuteS($query)) { // try once again
        return false;
      }
    }

    foreach ($sett as $item) {
      foreach ($item as $k => $value) {

        if ($k == "name") $n = $value;
        if ($k == "value") $v = $value;

        if (isset($v) && isset($n)) {
          if (isset($v[0]) && $v[0] == '{') {
            $v = (array)json_decode(htmlspecialchars_decode($v));
          }
          $s[$n] = $v;
        }
      }
    }

    return $s;
  }

  public function getModulesState()
  {  // get options from database
    if (!$sett = Db::getInstance()->ExecuteS('SELECT * FROM `'.$this->hdb.'` WHERE id_shop = '.$this->context->shop->id.';'))
      return false;

    foreach ($sett as $section) {
      $s[$section["hook"]][$section["module"]] = $section["ordr"].".".$section["value"];
    }

    return $s;
  }

  public function readCustomerCode($file)
  {
    if (!$f = @fopen($file, 'r')) {
      return false;//$this->displayError("Unable to open file ".$file;
    } else {
      $code = "";
      if (file_exists($file)) {
        if (filesize($file) > 0) {
          $code = fread($f, filesize($file));
          fclose($f);
        }
      }
      return $code;
    }

  }

  public function getModules()
  {  // get sizes
    $mState = $this->getModulesState();
    $this->getPkModules();

    $token = Tools::getAdminToken('AdminModules'.(Tab::getIdFromClassName('AdminModules')).$this->context->employee->id);

    if (!empty($mState)) {
      foreach ($mState as $key => $value) {
        $hooks[] = $key;
      }
    }

    $details = array(
      'token' => $token
    );

    if (isset($hooks)) {

      foreach ($hooks as $hook) {

        if ($id_hook = Hook::getIdByName($hook)) {

          $modules = Hook::getModulesFromHook($id_hook);

          if ($modules) {

            $details['hooks'][$hook]['modules'] = $modules;
            $details['hooks'][$hook]['hook_id'] = Hook::getIdByName($hook);

            foreach ($modules as $id => $options) {

              $curr = array(0,0);
              if (isset($mState[$hook][$options['name']])) {
                $curr = explode(".", $mState[$hook][$options['name']]);
              }

              $details['hooks'][$hook]['modules'][$id]['current'] = $curr;

            }
          }
        }
      }
    }

    return $details;
  }

  public function isPkModules($module)
  {
    $allModules = $this->getPkModules();
    if (in_array($module, $allModules)) {
      return true;
    }
    return false;
  }

  public function getPkModules()
  {
    $availableModules = Module::getModulesDirOnDisk();
    foreach ($availableModules as $id => $name) {
      if (strpos($name, 'pk_') === false && $name != 'revsliderprestashop' && $name != 'ph_simpleblog') {
        unset($availableModules[$id]);
      }
    }
    return $availableModules;
  }

  public function getModulesWithSettings()
  {
    $modules = array(
      'ps_customersignin', 'ps_languageselector', 'ps_currencyselector'
    );

    return $modules;
  }

  public function ajaxGetProductAttributesQuantity($id_product, $id_product_attribute, $requestedQuantity)
  {
    $available = Product::getQuantity($id_product, $id_product_attribute);
    if ($available >= $requestedQuantity) {
      return 1;
    } else {
      return 0;
    }
  }
  
  public function ajaxProcessUpdateModPositions($id_module, $id_hook, $way, $positions)
  {
    $position = (is_array($positions)) ? array_search($id_hook.'_'.$id_module, $positions) : null;
    $module = Module::getInstanceById($id_module);
    if (Validate::isLoadedObject($module)) {
      if ($module->updatePosition($id_hook, $way, $position)) {
        die(true);
      } else {
        die('{ "hasError" : true, "errors" : "Cannot update module position." }');
      }
    } else {
      die('{ "hasError" : true, "errors" : "This module cannot be loaded." }');
    }
  }

  public function displayForm($message)
  {
    $s = $this->getOptions();
    $modules_list = $this->getModules();

    $id_shop = (int)Context::getContext()->shop->id;

    $logo = "";
    if (file_exists(_PS_IMG_DIR_.Configuration::get('PS_LOGO', null, null, $id_shop)))
      $logo = __PS_BASE_URI__."img/".Configuration::get('PS_LOGO', null, null, $id_shop);

    $conf = new Pk_ThemeSettings_Config();
    $pk_options = $conf->getOptionsArray();

    foreach ($pk_options as $tab => $options) {
      foreach ($options['options_list'] as $key => $value) {
        if ($value['type'] != 'separator' && $value['type'] != 'message' && $value['type'] != 'html') { // skip separator
          if ($value['type'] == 'typography') {
            foreach ($value['default'] as $k => $v) {
              $pk_options[$tab]['options_list'][$key]['current'][$k] = (isset($s[$value['name']][$k]) ? $s[$value['name']][$k] : $v );
            }
          } else {
            $pk_options[$tab]['options_list'][$key]['current'] = (isset($s[$value['name']]) ? $s[$value['name']] : $value['default'] );
          }
        }
      }
    }

    $pk_options['maintenance']['options_list'][0]['current'] = Configuration::get('PS_SHOP_ENABLE');
    $pk_options['homepage']['content'] = $modules_list;
    $pk_options['customer_css']['options_list'][0]['current'] = $this->readCustomerCode($this->customcssFile);
    $pk_options['customer_css']['options_list'][1]['current'] = $this->readCustomerCode($this->customjsFile);

    $this->context->smarty->assign(
      array(
        's' => $s,
        'path' => $this->_path,
        'imgs' => $this->_path.'assets/images/',
        'tpl_path' => _PS_MODULE_DIR_.$this->name.'/views/admin/',
        'action' => Tools::safeOutput($_SERVER['REQUEST_URI']),
        'message' => $message,
        'fontFiles' => "",
        'token' => Tools::getAdminToken('AdminModules'.(Tab::getIdFromClassName('AdminModules')).$this->context->employee->id),
        'logo' => $logo,
        'sections' => $pk_options,
        'pk_modules' => $this->getPkModules(),
        'modules_with_setting' => $this->getModulesWithSettings(),
        'version' => $this->versions
        )
    );

    return $this->fetch(_PS_MODULE_DIR_.$this->name.'/views/admin/main.tpl');

  }

  public function prepare_smarty($theme_settings = false)
  {
    if (!$theme_settings)
      $theme_settings = $this->getOptions("prepare_smarty");

    $theme_settings['theme_name'] = $this->theme_name;
    $theme_settings['version'] = $this->versions;
    $theme_settings['modules'] = $this->getModulesState();
    $theme_settings['cat_img_path'] = _PS_CAT_IMG_DIR_;
    $theme_settings['used_fonts'] = $this->getusedfonts($theme_settings);

    return $theme_settings;
  }

  public function setGlobalVars($settings, $admin = false)
  {
    Configuration::updateValue('ts_cart_link', $this->context->link->getPageLink('cart',null,$this->context->language->id,['action' => 'show']));
    Configuration::updateValue('ts_order_link', $this->context->link->getPageLink('order', true));
    Configuration::updateValue('ts_is_catalog', Configuration::isCatalogMode());
    if (!$admin) {
      Configuration::updateValue('ts_token', Tools::getToken(false));
    }
    Configuration::updateValue('cp_listing_view', $settings['cp_listing_view']);
    Configuration::updateValue('cp_collapse_filter', $settings['cp_collapse_filter']);
    foreach ($settings as $key => $value) {
      if (strpos($key, 'pm_') !== false && !is_array($value)) {
        Configuration::updateValue($key, $value);
      }
    }
  }

  public function getusedfonts($db_options)
  {
    $systemFonts = array("Arial", "Tahoma", "Georgia", "Times+New+Roman", "Verdana", "FontAwesome");

    $cyrillic = $latin_ext = $subset = "";
    $allfonts = $fonts = array();

    foreach ($db_options as $option => $value) {
      if (is_array($value)) {
        foreach ($value as $sub_option => $sub_value) {
          if ($sub_option == 'font_family') {
            $allfonts[] = str_replace(' ', '+', $sub_value);
          }
        }
      }
    }

    if ($db_options["cyrillic"] == true) {
      $subset = "&subset=";
      $cyrillic = "cyrillic";
    }

    if ($db_options["latin_ext"] == true) {
      $subset = "&subset=";
      $latin_ext = (($cyrillic == "") ? "" : ",")."latin-ext";
    }

    $allfonts = array_unique($allfonts);
    foreach ($allfonts as $font) {
      if (!in_array($font, $systemFonts)) {

        $style = '';
        if ($font == 'Roboto') {
          $style = ':100,400,500,500i,900';
        }
        if ($font == 'Archivo+Narrow') {
          $style = ':100,400,500,500i';
        }
        $fonts[] = $font.$style;

      }
    }

    if (isset($fonts)) {
      $font_str = implode("%7C", $fonts);
      return $font_str.$subset.$cyrillic.$latin_ext;
    }
    return false;
  }

  public function isInst($name)
  {
    $return = "not_installed";
    if (Module::isInstalled($name))
      $return = "installed";

    return $return;
  }

  public function isEn($name)
  {
    $return = "disabled";
    $id_module = Module::getModuleIdByName($name);
    if (Db::getInstance()->getValue('SELECT `id_module` FROM `'._DB_PREFIX_.'module_shop` WHERE `id_module` = '.(int)$id_module.' AND `id_shop` = '.(int)Context::getContext()->shop->id))
      $return = "enabled";

    return $return;
  }

  public function getImLink($link_rewrite, $img_id, $imgName)
  {
    return $this->context->link->getImageLink($link_rewrite, $img_id, $imgName);
  }

  public function getImg($product_id, $link_rewrite, $imgName, $imgAttr = false)
  {
    if ($imgAttr == false) {
      $imgAttr = Image::getCover($product_id);
      $imgAttr = $imgAttr["id_image"];
    }
    $img = $this->getImLink($link_rewrite, (int)$imgAttr["id_image"], $imgName);
    return $img;
  }

  public function getCover($products)
  {
    $products = json_decode($products);
    $covers = array();
    foreach ($products as $id => $link_rewrite) {
      $cover = Image::getCover($id);
      if ($cover) {
        $covers[$id] = $this->context->link->getImageLink($link_rewrite, $cover["id_image"], 'cart_default');
      }
    }

    return $covers;
  }

  public function getImgByAttr($product_id, $link_rewrite, $imgName, $imgattr)
  {
    $imgid = Image::getImages($this->context->language->id, $product_id, $imgattr);
    if (!empty($imgid[0]))
      $img = $this->getImLink($link_rewrite, (int)$imgid[0]["id_image"], $imgName);
    else
      $img = false;

    return $img;
  }

  public function getSocialAccouts($ts)
  {
    $soc = array();
    if ($ts["sa_facebook"] == 1) $soc["facebook"] = $ts["sa_facebook_link"];
    if ($ts["sa_twitter"] == 1) $soc["twitter"] = $ts["sa_twitter_link"];
    if ($ts["sa_youtube"] == 1) $soc["youtube"] = $ts["sa_youtube_link"];
    if ($ts["sa_flickr"] == 1) $soc["flickr"] = $ts["sa_flickr_link"];
    if ($ts["sa_instagram"] == 1) $soc["instagram"] = $ts["sa_instagram_link"];
    if ($ts["sa_pinterest"] == 1) $soc["pinterest"] = $ts["sa_pinterest_link"];
    if ($ts["sa_linkedin"] == 1) $soc["linkedin"] = $ts["sa_linkedin_link"];
    return $soc;
  }

  public function getPaymentIcons($ts)
  {
    $pay = $cs = array();
    if (isset($ts["pay_visa"]) && $ts["pay_visa"] == 1) $pay["visa"] = $ts["pay_visa"];
    if (isset($ts["pay_am_exp"]) && $ts["pay_am_exp"] == 1) $pay["am_exp"] = $ts["pay_am_exp"];
    if (isset($ts["pay_mastercard"]) && $ts["pay_mastercard"] == 1) $pay["mastercard"] = $ts["pay_mastercard"];
    if (isset($ts["pay_paypal"]) && $ts["pay_paypal"] == 1) $pay["paypal"] = $ts["pay_paypal"];
    if (isset($ts["pay_maestro"]) && $ts["pay_maestro"] == 1) $pay["maestro"] = $ts["pay_maestro"];
    if (isset($ts["pay_discover"]) && $ts["pay_discover"] == 1) $pay["discover"] = $ts["pay_discover"];
    if (isset($ts["pay_cirrus"]) && $ts["pay_cirrus"] == 1) $pay["cirrus"] = $ts["pay_cirrus"];
    if (isset($ts["pay_direct"]) && $ts["pay_direct"] == 1) $pay["direct"] = $ts["pay_direct"];
    if (isset($ts["pay_solo"]) && $ts["pay_solo"] == 1) $pay["solo"] = $ts["pay_solo"];
    if (isset($ts["pay_switch"]) && $ts["pay_switch"] == 1) $pay["switch"] = $ts["pay_switch"];
    if (isset($ts["pay_wu"]) && $ts["pay_wu"] == 1) $pay["wu"] = $ts["pay_wu"];
    if (isset($ts["pay_bitcoin"]) && $ts["pay_bitcoin"] == 1) $pay["bitcoin"] = $ts["pay_bitcoin"];
    if (isset($ts["pay_bitcoingold"]) && $ts["pay_bitcoingold"] == 1) $pay["bitcoingold"] = $ts["pay_bitcoingold"];
    if (isset($ts["pay_litecoin"]) && $ts["pay_litecoin"] == 1) $pay["litecoin"] = $ts["pay_litecoin"];
    if (isset($ts["pay_ethereum"]) && $ts["pay_ethereum"] == 1) $pay["ethereum"] = $ts["pay_ethereum"];
    if (isset($ts["pay_dogecoin"]) && $ts["pay_dogecoin"] == 1) $pay["dogecoin"] = $ts["pay_dogecoin"];
    if (isset($ts["pay_monacoin"]) && $ts["pay_monacoin"] == 1) $pay["monacoin"] = $ts["pay_monacoin"];
    return $pay;
  }

  /* CUSTOM HOOKS */
  public function hookcomingsoon($params)
  {
    $theme_settings = $this->getOptions("hookcomingsoon");
    $cs["status"] = Configuration::get('PS_SHOP_ENABLE');
    if (isset($theme_settings['mt_date_until']) && !empty($theme_settings['mt_date_until'])) {
      $date_array = explode('/', $theme_settings['mt_date_until']);
      if (!empty($date_array)) {
        $cs['day'] = $date_array[0];
        $cs['month'] = (int)$date_array[1]-1;
        $cs['year'] = $date_array[2];
      }
    }

    if (isset($theme_settings['mt_notify'])) {
      $cs['notify'] = $theme_settings['mt_notify'];
    }
    if (isset($theme_settings['mt_countdown'])) {
        $cs['countdown'] = $theme_settings['mt_countdown'];
    }

    $this->context->smarty->assign(
      array(
          'cs' => $cs,
          'module_dir' => $this->context->link->getBaseLink().'modules/'.$this->name,
          'mainURL' => $this->context->link->getBaseLink()
      )
    );

    return $this->fetch('module:'.$this->name.'/views/frontend/comingsoon.tpl');
  }

  public function hookfooter_bottom($params)
  {
    $ts = $this->getOptions("hookfooter_bottom");

    $smarty = array("module_dir" => $this->context->shop->physical_uri.$this->context->shop->virtual_uri.'modules/'.$this->name.'/assets/images/payment_icons/32/');

    if ($ts['footer_bottom_pcards'] == 1) {
      $smarty["pay"] = $this->getPaymentIcons($ts);
    }
    if ($ts['footer_bottom_social'] == 1) {
      $smarty["soc"] = $this->getSocialAccouts($ts);
    }

    $this->context->smarty->assign($smarty);

    return $this->fetch('module:'.$this->name.'/views/frontend/footer_bottom.tpl');

  }

  public function hookDisplayHeader($params)
  {
    $opts = $this->getOptions();
    $ctrl = $this->context->controller;
    //$ctrl->unregisterJavascript('jquery-ui');
    $ctrl->unregisterStylesheet('jquery-ui');
    $ctrl->unregisterStylesheet('jquery-ui-theme');

    $ctrl->addCSS($this->_path.'assets/css/styles.css', 'all');
    $ctrl->addCSS($this->local_path."assets/css/presets/".$opts["preset"].".css", 'all');
    $ctrl->addCSS($this->generatedFile, 'all');
    if (file_exists($this->customcssFile)) {
      if (filesize($this->customcssFile) != false) {
        $ctrl->addCSS($this->customcssFile, 'all');
      }
    }
    if (!isset($ctrl->php_self) || $ctrl->php_self == 'category')
      $this->context->controller->registerJavascript($this->name.'-backgr', 'modules/'.$this->name.'/assets/js/background-check.js', ['position' => 'bottom', 'priority' => 510, 'attributes' => 'async']);

    $this->context->controller->registerJavascript($this->name, 'modules/'.$this->name.'/assets/js/commonscripts.js', ['position' => 'bottom', 'priority' => 160, 'attributes' => 'async']);

    if (file_exists($this->customjsFile)) {
      if (filesize($this->customjsFile) != false) {
        $this->context->controller->registerJavascript($this->name.'-custom', $this->customjsFile, ['position' => 'bottom', 'priority' => 520, 'attributes' => 'async']);
      }
    }

    $smarty_options = $this->prepare_smarty($opts);

    $page = $this->context->smarty->tpl_vars['page'];
    if (isset($opts['pm_details_layout'])) {
      $page->value['body_classes'][$opts['pm_details_layout']] = true;
    }
    if (isset($opts['pm_filter_image']) && $opts['pm_filter_image'] == 1) {
      $page->value['body_classes']['pm_filter_image'] = true;
    }
    if (isset($opts['header_position'])) {
      $page->value['body_classes'][$opts['header_position']] = true;
    }
    if (isset($opts['cp_only_filter']) && $opts['cp_only_filter'] == 1) {
      $page->value['body_classes']['cp-only-filter'] = true;
    }
    if (isset($opts['cp_columns_number'])) {
      $page->value['body_classes']['product-grid-4'] = true;
    }
    if (isset($opts['pp_updownbuttons']) && $opts['pp_updownbuttons'] == 0) {
      $page->value['body_classes']['hide-updownbuttons'] = true;
    }
    if (isset($opts['header_elements_icons']) && $opts['header_elements_icons'] == 0) {
      $page->value['body_classes']['hide-header-icons'] = true;
    }
    if (isset($opts['header_elements_text']) && $opts['header_elements_text'] == 0) {
      $page->value['body_classes']['hide-header-text'] = true;
    }
    if (isset($opts['gs_lazy_load']) && $opts['gs_lazy_load'] == 1) {
      $page->value['body_classes']['gs_lazy_load'] = true;
    }
    if (isset($opts['gs_popup_search']) && $opts['gs_popup_search'] == 1) {
      $page->value['body_classes']['gs-popup-search'] = true;
    }
    $this->context->smarty->assign((array)$page);

    $this->context->smarty->assign(array(
      'pkts' => $smarty_options,
      'shopID' => (int)$this->context->shop->id
    ));

    $exclude_items = array('fonts_list', 'defaultFonts', 'systemFonts', 'selectors', 'modules', 'used_fonts', 'sizes', 'gs_envato_purchase_id');
    
    foreach ($opts as $key => $value) {
      if (in_array($key, $exclude_items)) {
        unset($opts[$key]);
      }
    }
    $opts['ps_version'] = str_replace('.', '', _PS_VERSION_);

    Media::addJsDef(
        array('theme_cfg' => $opts)
    );

  }

  public function hookDisplayBeforeBodyClosingTag($params)
  {
    $theme_settings = $this->getOptions();
    if ( (isset($theme_settings['gs_cookie_pages']) && ($theme_settings['gs_cookie_message'] == 1)) ) {

      if ($theme_settings['gs_cookie_pages'] == 0) {
        $cookie_link = $theme_settings['gs_cookie_link'];
      } else {
        $cookie_link = $this->context->link->getCMSLink((int)$theme_settings['gs_cookie_pages']);
      }
      $this->context->smarty->assign(array(
        'cookie_link' => $cookie_link
      ));

      return ($this->fetch('module:'.$this->name.'/views/frontend/cookie-message.tpl'));

    }
  }

  public function injectDisplayBackOfficeHeader()
  {
    $ctrl = $this->context->controller;
    $ctrl->addJqueryPlugin('colorpicker');
    $ctrl->addJqueryPlugin('sortable');
    $ctrl->addJqueryUI('ui.datepicker');
    $ctrl->addJS($this->_path.'assets/js/ace/ace.js');
    $ctrl->addJS($this->_path.'assets/js/admin.js');
    $ctrl->addCSS($this->_path.'assets/css/admin.css');
  }

}