<?php
/**
* Promokit Wishlist Module
*
* @package   alysum
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(dirname(__FILE__).'/../../config/config.inc.php');
require_once(dirname(__FILE__).'/../../init.php');
require_once(dirname(__FILE__).'/Ws_WishList.php');
require_once(dirname(__FILE__).'/pk_wishlist.php');

$error = '';

// Instance of module class for translations
$module = new pk_wishlist();

$token = Tools::getValue('token');
$id_product = (int)Tools::getValue('id_product');
$id_product_attribute = (int)Tools::getValue('id_product_attribute');
$context = Context::getContext();
$cart = $context->cart;
if (Configuration::get('PS_TOKEN_ENABLE') == 1 && strcmp(Tools::getToken(false), Tools::getValue('static_token'))) {
    $error = $module->l('Invalid token', 'buywishlistproduct');
}

if (!Tools::strlen($error) &&
    empty($token) === false &&
    empty($id_product) === false) {
    $wishlist = Ws_WishList::getByToken($token);
    if ($wishlist !== false) {
        Ws_WishList::addBoughtProduct($wishlist['id_wishlist'], $id_product, $id_product_attribute, $cart->id, 1);
    }
} else {
    $error = $module->l('You must log in', 'buywishlistproduct');
}

if (empty($error) === false) {
    echo $error;
}
