<?php
/**
* Promokit Wishlist Module
*
* @package   alysum
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(dirname(__FILE__).'/../../config/config.inc.php');
require_once(dirname(__FILE__).'/../../init.php');
require_once(dirname(__FILE__).'/Ws_WishList.php');
require_once(dirname(__FILE__).'/pk_wishlist.php');

$context = Context::getContext();
$action = Tools::getValue('action');
$add = (!strcmp($action, 'add') ? 1 : 0);
$delete = (!strcmp($action, 'delete') ? 1 : 0);
$id_wishlist = (int)Tools::getValue('id_wishlist');
$id_product = (int)Tools::getValue('id_product');
$quantity = (int)Tools::getValue('quantity');
$id_product_attribute = (int)Tools::getValue('id_product_attribute');

// Instance of module class for translations
$module = new pk_wishlist();

if (Configuration::get('PS_TOKEN_ENABLE') == 1 &&
    strcmp(Tools::getToken(false), Tools::getValue('token')) &&
    $context->customer->isLogged() === true
) {
    echo $module->l('Invalid token', 'cart');
}
if ($context->customer->isLogged()) {
    if ($id_wishlist && Ws_WishList::exists($id_wishlist, $context->customer->id) === true) {
        $context->cookie->id_wishlist = (int)$id_wishlist;
    }

    if ((int)$context->cookie->id_wishlist > 0 && !Ws_WishList::exists($context->cookie->id_wishlist, $context->customer->id)) {
        $context->cookie->id_wishlist = '';
    }


    if (empty($context->cookie->id_wishlist) === true || $context->cookie->id_wishlist == false) {
        $context->smarty->assign('error', true);
    }
    
    if (($add || $delete) && empty($id_product) === false) {
        if (!isset($context->cookie->id_wishlist) || $context->cookie->id_wishlist == '') {
            $wishlist = new Ws_WishList();
            $wishlist->id_shop = $context->shop->id;
            $wishlist->id_shop_group = $context->shop->id_shop_group;
            $wishlist->default = 1;

            $mod_wishlist = new pk_wishlist();
            $wishlist->name = $mod_wishlist->default_wishlist_name;
            $wishlist->id_customer = (int)$context->customer->id;
            list($us, $s) = explode(' ', microtime());
            srand($s * $us);
            $wishlist->token = Tools::strtoupper(Tools::substr(sha1(uniqid(rand(), true)._COOKIE_KEY_.$context->customer->id), 0, 16));
            $wishlist->add();
            $context->cookie->id_wishlist = (int)$wishlist->id;
        }
        if ($add && $quantity) {
            Ws_WishList::addProduct($context->cookie->id_wishlist, $context->customer->id, $id_product, $id_product_attribute, $quantity);
        } elseif ($delete) {
            Ws_WishList::removeProduct($context->cookie->id_wishlist, $context->customer->id, $id_product, $id_product_attribute);
        }
    }
    $context->smarty->assign('products', Ws_WishList::getProductByIdCustomer($context->cookie->id_wishlist, $context->customer->id, $context->language->id, null, true));

    if (Tools::file_exists_cache(_PS_THEME_DIR_.'modules/pk_wishlist/blockwishlist-ajax.tpl')) {
        $context->smarty->display(_PS_THEME_DIR_.'modules/pk_wishlist/blockwishlist-ajax.tpl');
    } elseif (Tools::file_exists_cache(dirname(__FILE__).'/views/templates/hook/blockwishlist-ajax.tpl')) {
        $context->smarty->display(dirname(__FILE__).'/views/templates/hook/blockwishlist-ajax.tpl');
    } else {
        echo $module->l('No template found', 'cart');
    }
} else {
    echo $module->l('You must be logged in to manage your wishlist.', 'cart');
}
