<?php
/**
* Promokit Wishlist Module
*
* @package   pk_wishlist
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

// Include Module
include_once(dirname(__FILE__).'/../../pk_wishlist.php');
// Include Models
include_once(dirname(__FILE__).'/../../Ws_WishList.php');

class pk_wishlistDefaultModuleFrontController extends ModuleFrontController
{
    public function __construct()
    {
        parent::__construct();

        $this->context = Context::getContext();
    }

    public function init()
    {
        if (!$this->context->customer->isLogged()) {
            Tools::redirect('index.php?controller=authentication');
        }
        parent::init();
    }
    
    public function initContent()
    {
        parent::initContent();
        
        $id_wishlist = (int)Tools::getValue('id_wishlist');
        $id_product = (int)Tools::getValue('id_product');
        $id_product_attribute = (int)Tools::getValue('id_product_attribute');
        $quantity = (int)Tools::getValue('quantity');
        $priority = Tools::getValue('priority');
        $wishlist = new Ws_WishList((int)($id_wishlist));
        $refresh = ((Tools::getValue('refresh') == 'true') ? 1 : 0);
        
        
        if (empty($id_wishlist) === false) {
            switch (Tools::getValue('action')) {
                case 'update':
                    Ws_WishList::updateProduct($id_wishlist, $id_product, $id_product_attribute, $priority, $quantity);
                break;
                case 'delete':
                    Ws_WishList::removeProduct($id_wishlist, (int)$this->context->customer->id, $id_product, $id_product_attribute);
                break;
            }

            $products = Ws_WishList::getProductByIdCustomer($id_wishlist, $this->context->customer->id, $this->context->language->id);
            $bought = Ws_WishList::getBoughtProduct($id_wishlist);
            
            //echo '<pre>'; var_dump($products); echo '</pre>';
            
            for ($i = 0; $i < sizeof($products); ++$i) {
                $obj = new Product((int)($products[$i]['id_product']), false, $this->context->language->id);
                if (!Validate::isLoadedObject($obj)) {
                    continue;
                } else {
                    if ($products[$i]['id_product_attribute'] != 0) {
                        $combination_imgs = $obj->getCombinationImages($this->context->language->id);
                        if (isset($combination_imgs[$products[$i]['id_product_attribute']][0])) {
                            $products[$i]['cover'] = $obj->id.'-'.$combination_imgs[$products[$i]['id_product_attribute']][0]['id_image'];
                        } else {
                            $cover = Product::getCover($obj->id);
                            $products[$i]['cover'] = $obj->id.'-'.$cover['id_image'];
                        }
                    } else {
                        $images = $obj->getImages($this->context->language->id);
                        foreach ($images as $k => $image) {
                            if ($image['cover']) {
                                $products[$i]['cover'] = $obj->id.'-'.$image['id_image'];
                                break;
                            }
                        }
                    }
                    if (!isset($products[$i]['cover'])) {
                        $products[$i]['cover'] = $this->context->language->iso_code.'-default';
                    }
                }
                $products[$i]['bought'] = false;
                for ($j = 0, $k = 0; $j < sizeof($bought); ++$j) {
                    if ($bought[$j]['id_product'] == $products[$i]['id_product'] and
                        $bought[$j]['id_product_attribute'] == $products[$i]['id_product_attribute']) {
                        $products[$i]['bought'][$k++] = $bought[$j];
                    }
                }
            }

            $productBoughts = array();
            
            foreach ($products as $product) {
                if (isset($product['bought'])) {
                    $productBoughts[] = $product;
                }
            }
            
            $this->context->smarty->assign(array(
                    'products' => $products,
                    'productsBoughts' => $productBoughts,
                    'id_wishlist' => $id_wishlist,
                    'refresh' => $refresh,
                    'token_wish' => $wishlist->token,
                    'wishlists' => Ws_WishList::getByIdCustomer($this->context->cookie->id_customer)
            ));
            $this->setTemplate('module:pk_wishlist/views/templates/front/managewishlist.tpl');
        }
    }
}