<?php
/**
* Promokit Wishlist Module
*
* @package   pk_wishlist
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class pk_wishlistViewModuleFrontController extends ModuleFrontController
{

    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        include_once($this->module->getLocalPath().'Ws_WishList.php');
        include_once($this->module->getLocalPath().'pk_wishlist.php');
    }

    public function initContent()
    {
        parent::initContent();
        $token = Tools::getValue('token');

        $module = new pk_wishlist();

        if ($token) {
            $wishlist = Ws_WishList::getByToken($token);

            Ws_WishList::refreshWishList($wishlist['id_wishlist']);
            $products = Ws_WishList::getProductByIdCustomer((int)$wishlist['id_wishlist'], (int)$wishlist['id_customer'], $this->context->language->id, null, true);

            $nb_products = count($products);
            $priority_names = array(0=> $module->l('High'), 1=>$module->l('Medium'), 2=>$module->l('Low'));

            for ($i = 0; $i < $nb_products; ++$i) {
                $obj = new Product((int)$products[$i]['id_product'], true, $this->context->language->id);
                if (!Validate::isLoadedObject($obj)) {
                    continue;
                } else {
                    $products[$i]['priority_name'] = $priority_names[$products[$i]['priority']];
                    $quantity = Product::getQuantity((int)$products[$i]['id_product'], $products[$i]['id_product_attribute']);
                    $products[$i]['attribute_quantity'] = $quantity;
                    $products[$i]['product_quantity'] = $quantity;
                    $products[$i]['allow_oosp'] = $obj->isAvailableWhenOutOfStock((int)$obj->out_of_stock);
                    if ($products[$i]['id_product_attribute'] != 0) {
                        $combination_imgs = $obj->getCombinationImages($this->context->language->id);
                        if (isset($combination_imgs[$products[$i]['id_product_attribute']][0])) {
                            $products[$i]['cover'] = $obj->id.'-'.$combination_imgs[$products[$i]['id_product_attribute']][0]['id_image'];
                        } else {
                            $cover = Product::getCover($obj->id);
                            $products[$i]['cover'] = $obj->id.'-'.$cover['id_image'];
                        }
                    } else {
                        $images = $obj->getImages($this->context->language->id);
                        foreach ($images as $image) {
                            if ($image['cover']) {
                                $products[$i]['cover'] = $obj->id.'-'.$image['id_image'];
                                break;
                            }
                        }
                    }
                    if (!isset($products[$i]['cover'])) {
                        $products[$i]['cover'] = $this->context->language->iso_code.'-default';
                    }
                }
                $products[$i]['bought'] = false;
                
            }

            Ws_WishList::incCounter((int)$wishlist['id_wishlist']);

            $wishlists = Ws_WishList::getByIdCustomer((int)$wishlist['id_customer']);

            foreach ($wishlists as $key => $item) {
                if ($item['id_wishlist'] == $wishlist['id_wishlist']) {
                    unset($wishlists[$key]);
                    break;
                }
            }
            
            if (version_compare(_PS_VERSION_, '1.7', '>')) {
                $f_medium = ImageType::getFormattedName('medium');
            } else {
                $f_medium = ImageType::getFormatedName('medium');
            }

            $this->context->smarty->assign(
                array(
                    'current_wishlist' => $wishlist,
                    'f_medium' => $f_medium,
                    'token' => $token,
                    'ajax' => false,
                    'wishlists' => $wishlists,
                    'products' => $products
                )
            );
        }
        $this->setTemplate('module:pk_wishlist/views/templates/front/view17.tpl');
    }
}