<?php
/**
* Promokit Wishlist Module
*
* @package   alysum
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

require_once(dirname(__FILE__).'/../../config/config.inc.php');
require_once(dirname(__FILE__).'/../../init.php');
require_once(dirname(__FILE__).'/Ws_WishList.php');
require_once(dirname(__FILE__).'/pk_wishlist.php');

$context = Context::getContext();

// Instance of module class for translations
$module = new pk_wishlist();

if (Configuration::get('PS_TOKEN_ENABLE') == 1 and
    strcmp(Tools::getToken(false), Tools::getValue('token')) and
    $context->customer->isLogged() === true
) {
    exit($module->l('invalid token', 'sendwishlist'));
}

if ($context->customer->isLogged()) {
    $id_wishlist = (int)Tools::getValue('id_wishlist');
    if (empty($id_wishlist) === true) {
        exit($module->l('Invalid wishlist', 'sendwishlist'));
    }
    for ($i = 1; empty(Tools::getValue('email'.$i)) === false; ++$i) {
        $to = Tools::getValue('email'.$i);
        $wishlist = Ws_WishList::exists($id_wishlist, $context->customer->id, true);
        if ($wishlist === false) {
            exit($module->l('Invalid wishlist', 'sendwishlist'));
        }
        if (Ws_WishList::addEmail($id_wishlist, $to) === false) {
            exit($module->l('Wishlist send error', 'sendwishlist'));
        }
        $toName = Configuration::get('PS_SHOP_NAME');
        $customer = $context->customer;
        if (Validate::isLoadedObject($customer)) {
            Mail::Send(
                $context->language->id,
                'wishlist',
                sprintf(Mail::l('Message from %1$s %2$s', $context->language->id), $customer->lastname, $customer->firstname),
                array(
                    '{lastname}' => $customer->lastname,
                    '{firstname}' => $customer->firstname,
                    '{wishlist}' => $wishlist['name'],
                    '{message}' => $context->link->getModuleLink('pk_wishlist', 'view', array('token' => $wishlist['token']))
                ),
                $to, $toName, $customer->email, $customer->firstname.' '.$customer->lastname, null, null, dirname(__FILE__).'/mails/'
            );
        }
    }
}
