{*
* Promokit Wishlist Module
*
* @package   pk_wishlist
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}
{if $products}

	{if !$refresh}
	<div class="wishlistLinkTop">
	
        <a id="hideWishlist" class="button_account icon pull-right" style="display:none" href="#" onclick="WishlistVisibility('wishlistLinkTop', 'Wishlist'); return false;" rel="nofollow" title="{l s='Close this wishlist' mod='pk_wishlist'}">
            <svg class="svgic"><use xlink:href="#si-cross"></use></svg>
        </a>
        
        <div class="flex-container current-wishlist-buttons">
          <a id="hideBoughtProducts" class="btn button_account" href="#" onclick="WishlistVisibility('wlp_bought', 'BoughtProducts'); return false;" title="{l s='Hide products' mod='pk_wishlist'}">
              {l s='Hide products' mod='pk_wishlist'}
          </a>
          <a id="showBoughtProducts" class="btn button_account" href="#" onclick="WishlistVisibility('wlp_bought', 'BoughtProducts'); return false;" title="{l s='Show products' mod='pk_wishlist'}" style="display:none">
              {l s='Show products' mod='pk_wishlist'}
          </a>

            
          {if count($productsBoughts)}

              <a id="hideBoughtProductsInfos" class="btn button_account" href="#" onclick="WishlistVisibility('wlp_bought_infos', 'BoughtProductsInfos'); return false;" title="{l s='Hide products' mod='pk_wishlist'}">
                  {l s='Hide bought products info' mod='pk_wishlist'}
              </a>
              <a id="showBoughtProductsInfos" class="btn button_account" href="#" onclick="WishlistVisibility('wlp_bought_infos', 'BoughtProductsInfos'); return false;" title="{l s='Show products' mod='pk_wishlist'}" style="display:none">
                  {l s='Show bought products info' mod='pk_wishlist'}
              </a>

          {/if}
            
        </div>
        
        <p class="wishlisturl form-group">
            <label>{l s='Permalink' mod='pk_wishlist'}:</label>
            <input type="text" class="form-control" value="{$link->getModuleLink('pk_wishlist', 'view', ['token' => $token_wish])}" readonly="readonly"/>
        </p>
        <p class="submit">
            <div id="showSendWishlist" class="hidden">
                <a class="btn btn-default button button-small" href="#" onclick="WishlistVisibility('wl_send', 'SendWishlist'); return false;" title="{l s='Send this wishlist' mod='pk_wishlist'}">
                    <span>{l s='Send this wishlist' mod='pk_wishlist'}</span>
                </a>
            </div>
        </p>
        
	{/if}
	
	<div class="wlp_bought">
		<table class="table table-striped table-hover wlp_bought_list" id="table_wishlist" data-id-wishlist="{$id_wishlist}">
		<thead>
		<tr>
		<th class="col-xs-1 col-md-1 checkbox-col nopadding-right"></th>
		<th class="col-xs-3 col-md-2 wishlist-product-img"></th>
		<th class="col-xs-4 col-md-3 wishlist-product-desc">{l s='Items' mod='pk_wishlist'}</th>
		<th class="col-xs-0 hidden-xs-down col-md-1 wishlist-product-price">{l s='Price' mod='pk_wishlist'}</th>
		<th class="col-xs-1 col-md-1 wishlist-product-quantity">{l s='Quantity' mod='pk_wishlist'}</th>
		<th class="col-xs-3 col-md-2 wishlist-product-priority">{l s='Priority' mod='pk_wishlist'}</th>
		<th class="col-xs-0 col-md-2 wishlist-product-actions"></th>
		</tr>
		</thead>
		{foreach from=$products item=product name=i}
			<tr id="wlp_{$product.id_product}_{$product.id_product_attribute}">
				<td class="col-xs-1 col-md-1 checkbox-col nopadding-right">
				<input type="checkbox" data-id-product="{$product.id_product}" data-id-pa="{$product.id_product_attribute}" name="wishlist_group" class="wishlist_group_chb" />
				</td>
				<td class="col-xs-3 col-md-2 wishlist-product-img">
				   <div class="product_image">
                        <a href="{$link->getProductlink($product.id_product, $product.link_rewrite, $product.category_rewrite)}" title="{l s='Product detail' mod='pk_wishlist'}">
                            <img src="{$link->getImageLink($product.link_rewrite, $product.cover, 'small_default')}" alt="{$product.name}" />
                        </a>
                    </div>
				</td>
				<td class="col-xs-4 col-md-3 wishlist-product-desc">
				        <div class="product_infos">
                        <p class="product_name">{$product.name|truncate:30:'...'}</p>
                        <span class="wishlist_product_detail">
                        {if isset($product.attributes_small)}
                            <a href="{$link->getProductlink($product.id_product, $product.link_rewrite, $product.category_rewrite)}" title="{l s='Product detail' mod='pk_wishlist'}">{$product.attributes_small}</a>
                        {/if}
                        </span>
                        <span class="hidden-sm-up">{$product.price}</span>
                        </div>
				</td>
				<td class="col-xs-0 hidden-xs-down col-md-1 wishlist-product-price">
				{$product.price}
				</td>
				<td class="col-xs-1 col-md-1 wishlist-product-quantity">
				<input type="text" class="wl_product_qty" id="quantity_{$product.id_product}_{$product.id_product_attribute}" value="{$product.wl_quantity|intval}"  />
				</td>
				<td class="col-xs-3 col-md-2 wishlist-product-priority">
				<select id="priority_{$product.id_product}_{$product.id_product_attribute}">
                                <option value="0"{if $product.priority eq 0} selected="selected"{/if}>{l s='High' mod='pk_wishlist'}</option>
                                <option value="1"{if $product.priority eq 1} selected="selected"{/if}>{l s='Medium' mod='pk_wishlist'}</option>
                                <option value="2"{if $product.priority eq 2} selected="selected"{/if}>{l s='Low' mod='pk_wishlist'}</option>
                            </select>
                </td>
                <td class="col-xs-12 col-md-2 wishlist-product-actions">
				<div class="btn_action flex-container align-items-center">

				    
				    {*<a class="btn btn-primary add_cart ajax_add_to_cart_button exclusive" data-id-product-attribute="{$product.id_product_attribute|intval}" data-id-product="{$product.id_product|intval}" data-minimal_quantity="{if isset($product.product_attribute_minimal_quantity) && $product.product_attribute_minimal_quantity >= 1}{$product.product_attribute_minimal_quantity|intval}{else}{$product.wl_quantity|intval}{/if}" 
                    class="button ajax_add_to_cart_button btn btn-default" href="{$link->getPageLink('cart', true, NULL, $smarty.capture.default, false)}" rel="nofollow" title="{l s='Add to cart' mod='pk_wishlist'}">{l s='Add to cart' mod='pk_wishlist'}</a>*}
				                                {if $wishlists|count > 1}
                                <span style="white-space: nowrap;">{l s='Move to'  mod='pk_wishlist'}:</span>
                                {foreach name=wl from=$wishlists item=wishlist}
                                    {if $smarty.foreach.wl.first}
                                       <select class="wishlist_change_button">
                                       <option>---</option>
                                    {/if}
                                    {if $id_wishlist != {$wishlist.id_wishlist}}
                                            <option title="{$wishlist.name}" value="{$wishlist.id_wishlist}" data-id-product="{$product.id_product}" data-id-product-attribute="{$product.id_product_attribute}" data-quantity="{$product.wl_quantity|intval}" data-priority="{$product.priority}" data-id-old-wishlist="{$id_wishlist}" data-id-new-wishlist="{$wishlist.id_wishlist}">
                                              {$wishlist.name}
                                            </option>
                                    {/if}
                                    {if $smarty.foreach.wl.last}
                                        </select>
                                    {/if}
                                {/foreach}
                            {/if}
				    <a href="javascript:;" class="lnksave db" onclick="WishlistProductManage('wlp_bought_{$product.id_product_attribute}', 'update', '{$id_wishlist}', '{$product.id_product}', '{$product.id_product_attribute}', $('#quantity_{$product.id_product}_{$product.id_product_attribute}').val(), $('#priority_{$product.id_product}_{$product.id_product_attribute}').val());" title="{l s='Save' mod='pk_wishlist'}"><svg class="svgic"><use xlink:href="#si-save"></use></svg></a>
				                
				    <a href="javascript:;" class="lnkdel db" onclick="WishlistProductManage('wlp_bought', 'delete', '{$id_wishlist}', '{$product.id_product}', '{$product.id_product_attribute}', $('#quantity_{$product.id_product}_{$product.id_product_attribute}').val(), $('#priority_{$product.id_product}_{$product.id_product_attribute}').val());" title="{l s='Delete' mod='pk_wishlist'}">
                    <svg class="svgic"><use xlink:href="#si-cross"></use></svg>
                </a>
            {if (!isset($product.customization_required) || !$product.customization_required) && ($product.allow_oosp || $product.quantity > 0)}
            <a class="add_cart wishlist_add_to_cart ajax_add_to_cart_button exclusive" href="{$link->getAddToCartURL({$product.id_product|intval}, {$product.id_product_attribute})}" rel="nofollow" title="{l s='Add to cart' mod='pk_wishlist'}" data-id-product-attribute="{$product.id_product_attribute|intval}" data-id-product="{$product.id_product|intval}" data-minimal_quantity="{if isset($product.product_attribute_minimal_quantity) && $product.product_attribute_minimal_quantity >= 1}{$product.product_attribute_minimal_quantity|intval}{else}{$product.minimal_quantity|intval}{/if}">
                <svg class="svgic"><use xlink:href="#si-cart"></use></svg>
            </a>
          {else}
            <span class="ajax_add_to_cart_button disabled">
                <svg class="svgic"><use xlink:href="#si-cart"></use></svg>
            </span>
          {/if}
				</div>
				</td>
			</tr>
		{/foreach}
		
		</table>
		
		{l s='Group actions:' mod='pk_wishlist'}
		<select class="wishlist_group_actions">
		<option value="0">---</option>
		<option value="1">{l s='Delete Selected' mod='pk_wishlist'}</option>
		</select>
		
	</div>
	{if !$refresh}
	<form method="post" class="wl_send std" onsubmit="return (false);" style="display: none;">
		<a id="hideSendWishlist" class="button_account btn icon"  href="#" onclick="WishlistVisibility('wl_send', 'SendWishlist'); return false;" rel="nofollow" title="{l s='Close this wishlist' mod='pk_wishlist'}">
      <i class="material-icons">delete_forever</i>
		</a>
		<fieldset>
			<p class="required">
				<label for="email1">{l s='Email' mod='pk_wishlist'}1 <sup>*</sup></label>
				<input type="text" name="email1" id="email1" />
			</p>
			{section name=i loop=11 start=2}
			<p>
				<label for="email{$smarty.section.i.index}">{l s='Email' mod='pk_wishlist'}{$smarty.section.i.index}</label>
				<input type="text" name="email{$smarty.section.i.index}" id="email{$smarty.section.i.index}" />
			</p>
			{/section}
			<p class="submit">
				<input class="button" type="submit" value="{l s='Send' mod='pk_wishlist'}" name="submitWishlist" onclick="WishlistSend('wl_send', '{$id_wishlist}', 'email');" />
			</p>
			<p class="required">
				<sup>*</sup> {l s='Required field' mod='pk_wishlist'}
			</p>
		</fieldset>
	</form>
	{if count($productsBoughts)}
	<table class="wlp_bought_infos hidden std">
		<thead>
			<tr>
				<th class="first_item">{l s='Product' mod='pk_wishlist'}</th>
				<th class="item">{l s='Quantity' mod='pk_wishlist'}</th>
				<th class="item">{l s='Offered by' mod='pk_wishlist'}</th>
				<th class="last_item">{l s='Date' mod='pk_wishlist'}</th>
			</tr>
		</thead>
		<tbody>
		{foreach from=$productsBoughts item=product name=i}
			{foreach from=$product.bought item=bought name=j}
			{if $bought.wl_quantity > 0}
				<tr>
					<td class="first_item">
						<span style="float:left;"><img src="{$link->getImageLink($product.link_rewrite, $product.cover, 'small_default')|escape:'html'}" alt="{$product.name}" /></span>
						<span style="float:left;">
							{$product.name|truncate:40:'...'}
						{if isset($product.attributes_small)}
							<br /><i>{$product.attributes_small}</i>
						{/if}
						</span>
					</td>
					<td class="item align_center">{$bought.wl_quantity|intval}</td>
					<td class="item align_center">{$bought.firstname} {$bought.lastname}</td>
					<td class="last_item align_center">{$bought.date_add|date_format:"%Y-%m-%d"}</td>
				</tr>
			{/if}
			{/foreach}
		{/foreach}
		</tbody>
	</table>
	{/if}
	{/if}
{else}
	<p class="warning">{l s='No products' mod='pk_wishlist'}</p>
{/if}
