{*
* Promokit Wishlist Module
*
* @package   pk_wishlist
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}
<div id="mywishlist" class="mywishlist_17">
    {if $id_customer|intval neq 0}
        {if $wishlists}
            <div id="block-history" class="block-center">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th class="col-xs-2 col-md-2">{l s='Name' mod='pk_wishlist'}</th>
                            <th class="col-xs-1 col-md-1">{l s='Qty' mod='pk_wishlist'}</th>
                            <th class="col-xs-1 col-md-1">{l s='Viewed' mod='pk_wishlist'}</th>
                            <th class="col-xs-2 col-md-2">{l s='Created' mod='pk_wishlist'}</th>
                            <th class="col-xs-2 col-md-2">{l s='Direct Link' mod='pk_wishlist'}</th>
                            <th class="col-xs-2 col-md-2">{l s='Default' mod='pk_wishlist'}</th>
                            <th class="col-xs-2 col-md-2">{l s='Delete' mod='pk_wishlist'}</th>
                        </tr>
                    </thead>
                    <tbody>
                        {section name=i loop=$wishlists}
                            <tr id="wishlist_{$wishlists[i].id_wishlist|intval}">
                                <td class="col-xs-2 col-md-2">
                                    <a href="#" onclick="javascript:event.preventDefault();WishlistManage('block-order-detail', '{$wishlists[i].id_wishlist|intval}');">
                                        {$wishlists[i].name|truncate:30:'...'}
                                    </a>
                                </td>
                                <td class="col-xs-1 col-md-1">
                                    {assign var=n value=0}
                                    {foreach from=$nbProducts item=nb name=i}
                                        {if $nb.id_wishlist eq $wishlists[i].id_wishlist}
                                            {assign var=n value=$nb.nbProducts|intval}
                                        {/if}
                                    {/foreach}
                                    {if $n}
                                        {$n|intval}
                                    {else}
                                        0
                                    {/if}
                                </td>
                                <td class="col-xs-1 col-md-1">{$wishlists[i].counter|intval}</td>
                                <td class="col-xs-2 col-md-2">{$wishlists[i].date_add|date_format:"%Y-%m-%d"}</td>
                                <td class="col-xs-2 col-md-2">
                                    <a href="#" onclick="javascript:event.preventDefault();WishlistManage('block-order-detail', '{$wishlists[i].id_wishlist|intval}');">
                                        {l s='View' mod='pk_wishlist'}
                                    </a>
                                </td>
                                <td class="col-xs-2 col-md-2 default-section">
                                    {if isset($wishlists[i].default) && $wishlists[i].default == 1}
                                        <span class="db is_wish_list_default"><svg class="svgic"><use xlink:href="#si-done"></use></svg></span>
                                    {else}
                                        <a href="#" class="db" onclick="javascript:event.preventDefault();(WishlistDefault('wishlist_{$wishlists[i].id_wishlist|intval}', '{$wishlists[i].id_wishlist|intval}'));">
                                            <svg class="svgic"><use xlink:href="#si-done"></use></svg>
                                        </a>
                                    {/if}
                                </td>
                                <td class="col-xs-2 col-md-2 wishlist_delete">
                                    <a class="icon db" href="#" onclick="javascript:event.preventDefault();return (WishlistDelete('wishlist_{$wishlists[i].id_wishlist|intval}', '{$wishlists[i].id_wishlist|intval}', '{l s='Do you really want to delete this wishlist ?' mod='pk_wishlist' js=1}'));">
                                        <svg class="svgic"><use xlink:href="#si-cross"></use></svg>
                                    </a>
                                </td>
                            </tr>
                        {/section}
                    </tbody>
                </table>
            </div>
            <div id="block-order-detail">&nbsp;</div>
        {/if}

        <form method="post" class="std box" id="form_wishlist">
            <h3 class="page-subheading">{l s='Create New Wishlist' mod='pk_wishlist'}</h3>
            <div class="flex-container">
                <input type="hidden" name="token" value="{$token}" />
                <input type="text" id="name" name="name" class="inputTxt form-control" placeholder="{l s='Name' mod='pk_wishlist'}" value="{if isset($smarty.post.name) and $errors|@count > 0}{$smarty.post.name}{/if}" />
                <button id="submitWishlist" class="btn btn-default button button-medium" type="submit" name="submitWishlist">
                    {l s='Save' mod='pk_wishlist'}
                </button>
            </div>
        </form>

    {/if}
</div>
