{*
* Promokit Wishlist Module
*
* @package   pk_wishlist
* @version   1.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}
<div id="advansedwishlist_block" class="block account hidden-sm-down advansedwishlist_17">
    <h4 class="title_block">
        <a href="{$link->getModuleLink('pk_wishlist', 'mywishlist', array(), true)|addslashes}" title="{l s='My wishlists' mod='pk_wishlist'}" rel="nofollow">{l s='Wishlist' mod='pk_wishlist'}</a>
    </h4>
    <div class="block_content">
        <div id="ws_wishlist_block_list" class="expanded">
        {if $wishlist_products}
            <dl class="products">
            {foreach from=$wishlist_products item=product name=i}
                <dt class="{if $smarty.foreach.i.first}first_item{elseif $smarty.foreach.i.last}last_item{else}item{/if}">
                    <a class="cart_block_product_name"
                    href="{$link->getProductLink($product.id_product, $product.link_rewrite, $product.category_rewrite)|escape:'html'}" title="{$product.name}">{$product.name|truncate:30:'...'}</a>
                    <a class="ajax_cart_block_remove_link" href="javascript:;" onclick="javascript:WishlistCart('ws_wishlist_block_list', 'delete', '{$product.id_product}', {$product.id_product_attribute}, '0', '{if isset($token)}{$token}{/if}');" title="{l s='remove this product from my wishlist' mod='pk_wishlist'}" rel="nofollow">
                        <i class="material-icons">delete_forever</i>
                    </a>
                </dt>
                {if isset($product.attributes_small)}
                <dd class="{if $smarty.foreach.i.first}first_item{elseif $smarty.foreach.i.last}last_item{else}item{/if}">
                    <a href="{$link->getProductLink($product.id_product, $product.link_rewrite, $product.category_rewrite)|escape:'html'}" title="{l s='Product detail' mod='pk_wishlist'}">{$product.attributes_small}</a>
                </dd>
                {/if}
            {/foreach}
            </dl>
        {else}
            <dl class="products">
                <dt>{l s='No products' mod='pk_wishlist'}</dt>
            </dl>
        {/if}
        </div>
        <p class="lnk">
        {if $wishlists}
            <select name="wishlists" id="wishlists" onchange="WishlistChangeDefault('wishlist_block_list', $('#wishlists').val());">
            {foreach from=$wishlists item=wishlist name=i}
                <option value="{$wishlist.id_wishlist}"{if $id_wishlist eq $wishlist.id_wishlist or ($id_wishlist == false and $smarty.foreach.i.first)} selected="selected"{/if}>{$wishlist.name|truncate:22:'...'}</option>
            {/foreach}
            </select>
        {/if}
            <a href="{$link->getModuleLink('pk_wishlist', 'mywishlist', array(), true)|addslashes}" title="{l s='My wishlists' mod='pk_wishlist'}" rel="nofollow">&raquo; {l s='My wishlists' mod='pk_wishlist'}</a>
        </p>
    </div>
</div>
