<?php

class Przelewy24ServicePaymentReturn extends Przelewy24Service
{
    /**
     * hookPaymentReturn implementation.
     */
    public function execute($params)
    {
        if (!$this->getPrzelewy24()->active) {
            return false;
        }

        /** @var $order \PrestaShop\PrestaShop\Adapter\Entity\Order */
        if(is_array($params) && isset($params['order'])){
            $order = $params['order'];
            $cart = Cart::getCartByOrderId($order->id);
        }
        else if(isset($params->cart)){
            $cart = $params->cart;
        }

        $this->getPrzelewy24()->getSmarty()->assign('logo_url',
            $this->getPrzelewy24()->getPathUri() . 'views/img/logo.png');

        $s_sid = md5(time());

        if(isset($order) && $order->module == 'przelewy24' ){
            if($order->current_state != (int)Configuration::get('P24_ORDER_STATE_1'))
            {
                $order->setCurrentState((int)Configuration::get('P24_ORDER_STATE_1'));
            }

            $currency = new Currency($order->id_currency);
            $shipping = $cart->getPackageShippingCost((int)$order->id_carrier) * 100;
            $amount = Przelewy24Helper::p24AmountFormat($order->total_paid);
            $products = $order->getProducts();
            $productsInfo = array();
            foreach ($products as $key => $value) {
                $product = new Product($value['product_id']);
                $productsInfo[] = array(
                    'name' => $product->name[1],
                    'description' => $product->description_short[1],
                    'quantity' => (int)$value['product_quantity'],
                    'price' => (int)($value['product_price'] * 100),
                    'number' => $value['product_id'],
                );
            }
            $customerId = $order->id_customer;
            $description = $this->getPrzelewy24()->l("Order") . ': ' . $order->id;
            $IdLang = $cart->id_lang;
            $totalToPay = Tools::displayPrice(
                Przelewy24Helper::p24AmountFormat($order->total_paid)/100,
                $currency,
                false
            );
        }
        else{
            $currency = new Currency($cart->id_currency);
            $shipping = $cart->getPackageShippingCost((int)$cart->id_carrier) * 100;
            $amount = Przelewy24Helper::p24AmountFormat($cart->getOrderTotal( true, Cart::BOTH ));
            $products = $cart->getProducts();
            $productsInfo = array();
            foreach ($products as $key => $product) {
                $productsInfo[] = array(
                    'name' => $product['name'],
                    'description' => $product['description_short'],
                    'quantity' => (int)$product['cart_quantity'],
                    'price' => (int)($product['price'] * 100),
                    'number' => $product['id_product'],
                );
            }
            $customerId = $cart->id_customer;
            $description = $this->getPrzelewy24()->l("Cart") . ': ' . $cart->id;
            $IdLang = $cart->id_lang;
            $totalToPay = Tools::displayPrice(
                $cart->getOrderTotal( true, Cart::BOTH ),
                $currency,
                false
            );
        }

            $sufix = ($currency->iso_code == "PLN") ? "" : "_".$currency->iso_code;

            $merchantId = Configuration::get('P24_MERCHANT_ID'.$sufix);
            $shopId = Configuration::get('P24_SHOP_ID'.$sufix);
            $salt = Configuration::get('P24_SALT'.$sufix);
            $testMode = (bool)Configuration::get('P24_TEST_MODE'.$sufix);
            $p24Class = new Przelewy24Class($merchantId, $shopId, $salt, $testMode);
            $p24Soap = new Przelewy24Soap($sufix, $merchantId, $shopId, $salt, $testMode);

            $sessionId = $cart->id . '|' . $s_sid;
            $customer = new Customer((int)($customerId));

            $translations = array(
                'virtual_product_name' => $this->getPrzelewy24()->l('Extra charge [VAT and discounts]'),
                'cart_as_product' => $this->getPrzelewy24()->l('Your order'),
            );
            $p24Product = new Przelewy24Product($translations);
            $p24ProductItems = $p24Product->prepareCartItems($amount, $productsInfo, $shipping);

            $addresses = $customer->getAddresses((int)Configuration::get('PS_LANG_DEFAULT'));
            $addressObj = array_pop($addresses);
            $address = new Address((int)$addressObj['id_address']);
            $s_lang = new Country((int)($address->id_country));

            $data = array(
                'p24_session_id' => $sessionId,
                'p24_merchant_id' => Configuration::get('P24_MERCHANT_ID'.$sufix),
                'p24_pos_id' => Configuration::get('P24_SHOP_ID'.$sufix),
                'p24_email' => $customer->email,
                'p24_address' => $address->address1 . " " . $address->address2,
                'p24_zip' => $address->postcode,
                'p24_city' => $address->city,
                'p24_country' => $s_lang->iso_code,
                'p24_amount' => $amount,
                'p24_currency' => $currency->iso_code,
                'shop_name' => $this->getPrzelewy24()->getContext()->shop->name,
                'p24_description' => $description,
                'cartId' => $cart->id,
                'status' => 'ok',
                'p24_url' => $p24Class->trnDirectUrl(),
                'p24_url_status' => $this->getPrzelewy24()->getContext()->link->getModuleLink('przelewy24',
                    'paymentStatus', array(),
                    Configuration::get('PS_SSL_ENABLED') == 1),
                'p24_url_return' => $this->getPrzelewy24()->getContext()->link->getModuleLink('przelewy24',
                    'paymentSuccessful', array(),
                    Configuration::get('PS_SSL_ENABLED') == 1),
                'p24_api_version' => P24_VERSION,
                'p24_ecommerce' => 'prestashop_' . _PS_VERSION_,
                'p24_ecommerce2' => Configuration::get('P24_PLUGIN_VERSION'),
                'p24_language' => strtolower(Language::getIsoById($IdLang)),
                'p24_client' => $customer->firstname . ' ' . $customer->lastname,
                'p24ProductItems' => $p24ProductItems,
                'p24_wait_for_result' => 0,
                'p24_shipping' => $shipping,
                'total_to_pay' => $totalToPay,
                'pay_card_inside_shop' =>  (int)Configuration::get('P24_PAY_CARD_INSIDE_ENABLE'),
                'customer_is_guest' => (int) $customer->is_guest,
                'logo_url' => $this->getPrzelewy24()->getPathUri() . 'views/img/logo.png',
                'validationRequired'=>Configuration::get('P24_VERIFYORDER'.$sufix),
                'validationLink'=> $this->getPrzelewy24()->getContext()->link->getModuleLink('przelewy24',
                    'validateOrderRequest', array(),
                    Configuration::get('PS_SSL_ENABLED') == 1)
            );

            $data['p24_sign'] = $p24Class->trnDirectSign($data);
            $data['p24_paymethod_graphics'] = Configuration::get('P24_GRAPHICS_PAYMENT_METHOD_LIST'.$sufix);
            $data['nav_more_less_path'] = dirname($this->getPrzelewy24()->getBaseFile()) . '/views/templates/hook/parts/nav_more_less.tpl';

            $paymentMethod = (int)Tools::getValue('payment_method');
            if ($paymentMethod > 0 && Configuration::get('P24_PAYMENT_METHOD_LIST'.$sufix)) {
                $paymentMethod = (int)Tools::getValue('payment_method');
                $promotePaymethodList = $p24Soap->getPromotedPaymentList(Configuration::get('P24_API_KEY'.$sufix), $currency->iso_code);
                if (!empty($promotePaymethodList['p24_paymethod_list_promote']) && !empty($promotePaymethodList['p24_paymethod_list_promote'][$paymentMethod])) {
                    $data['payment_method_selected_name'] = $promotePaymethodList['p24_paymethod_list_promote'][$paymentMethod];
                } else {
                    $paymentMethod = 0;// not available method
                }
            }

            $data['payment_method_selected_id'] = $paymentMethod;
            $data['card_remember_input'] = false;
            $data['remember_customer_cards'] = Przelewy24OneClickHelper::rememberCardForCustomer($customer->id);

            // oneClick
            if (Przelewy24OneClickHelper::isOneClickEnable($sufix)) {
                if ($paymentMethod === 0 || in_array($paymentMethod, Przelewy24OneClickHelper::getCardPaymentIds())) {
                    $data['card_remember_input'] = true;
                }

                $data['p24_ajax_notices_url'] = $this->getPrzelewy24()->getContext()->link->getModuleLink('przelewy24',
                    'ajaxNotices', array('card_remember' => 1),
                    Configuration::get('PS_SSL_ENABLED') == 1);
                $data['customer_cards'] = Przelewy24OneClickHelper::getCustomerCards($customer->id);
                $data['charge_card_url'] = $this->getPrzelewy24()->getContext()->link->getModuleLink('przelewy24',
                    'chargeCard', array('id_cart' => (int)$cart->id));
            }

            if ($paymentMethod) {
                $data['P24_PAYMENT_METHOD_LIST'] = false;
            } else {
                $data['P24_PAYMENT_METHOD_LIST'] = Configuration::get('P24_PAYMENT_METHOD_LIST'.$sufix);
            }

            if (Configuration::get('P24_PAYMENT_METHOD_LIST'.$sufix)) {
                // payments method list and order
                $paymethodList = $p24Soap->getFirstAndSecondPaymentList(Configuration::get('P24_API_KEY'.$sufix), $currency->iso_code);

                $data['p24_paymethod_list_first'] = $paymethodList['p24_paymethod_list_first'];
                $data['p24_paymethod_list_second'] = $paymethodList['p24_paymethod_list_second'];
            }

            $data['p24_method'] = false;
            // Payment with BLIK UID
            if (Tools::getValue('blik_type') === 'UID') {
                $blikAlias = false;
                if ($customer->id) {
                    $blikAlias = Przelewy24BlikHelper::getSavedAlias($customer->id);
                }

                $data['p24_method'] = 'blik_uid';
                $data['P24_PAYMENT_METHOD_LIST'] = false;
                $data['card_remember_input'] = false;
                $data['p24_blik_code'] = true;
                $data['p24_blik_alias'] = $blikAlias;
                $data['p24_url'] = $this->getPrzelewy24()->getContext()->link->getModuleLink('przelewy24',
                    'chargeBlik', array('id_order' => (int)Tools::getValue('id_order')));
                $data['p24_blik_websocket'] = Przelewy24BlikHelper::getWebsocketHost((bool)Configuration::get('P24_TEST_MODE'.$sufix));
                $data['p24_shop_order_id'] = (int)Tools::getValue('id_order');

                $data['p24_payment_failed_url'] = $this->getPrzelewy24()->getContext()->link->getModuleLink('przelewy24',
                    'paymentFailed', array('id_order' => (int)Tools::getValue('id_order')));

                $data['p24_blik_ajax_verify_url'] = $this->getPrzelewy24()->getContext()->link->getModuleLink('przelewy24',
                    'ajaxVerifyBlik');

                $data['p24_blik_error_url'] = $this->getPrzelewy24()->getContext()->link->getModuleLink('przelewy24',
                    'ajaxBlikError');
            }

            if((int)Configuration::get('P24_VERIFYORDER'.$sufix) === 0 || $order)
            {
                return $this->getPrzelewy24()->getSmarty()->assign($data);
            }
            else{
                return $data;
            }
    }
}