<?php

class Przelewy24Controller extends ModuleFrontController
{
    protected $output = [];

    public function initContent()
    {
        parent::initContent();
        $this->output = [];
    }

    protected function response($httpCode, $infoMessage, $log = true)
    {
        http_response_code($httpCode);
        if ($log) {
            $this->log($infoMessage);
        }
        echo filter_var(json_encode($this->output), FILTER_SANITIZE_STRING);
        exit;
    }

    protected function log($infoMessage)
    {
        Logger::addLog('Przelewy24Controller - ' . $infoMessage, 1);
    }
}