<?php


class przelewy24ajaxRememberOneclickOrderIdModuleFrontController extends ModuleFrontController
{
    protected function renderJson($data)
    {
        header("Content-Type: application/json;charset=utf-8");
        print json_encode($data);
        exit;
    }

    public function initContent()
    {
        try {
            $orderId = $this->sanitizeOrderId(Tools::getValue('orderId'));
            $oneclickOrderId = $this->sanitizeOrderId(Tools::getValue('oneclickOrderId'));
            $sessionId = $this->sanitizeSessionId(Tools::getValue('sessionId'));
            $sign = $this->sanitizeSign(Tools::getValue('sign'));
            $signValidation = $this->checkSign($sign, $sessionId);
            if ($orderId && ($oneclickOrderId || $oneclickOrderId === 0) && $sessionId && $sign && $signValidation) {
                Db::getInstance()->Execute("INSERT INTO " . _DB_PREFIX_ . "przelewy24_oneclick (`p24_order_id`, `oneclick_order_id`, `p24_session_id`) VALUES (" . $orderId . ", " . $oneclickOrderId . ", '" . $sessionId . "')");
                $data['success'] = 1;
                $data['error'] = '';
            } else {
                $data['success'] = 0;
                $data['error'] = 'wrong data';
            }
        } catch (Exception $e) {
            $data['success'] = 0;
            $data['error'] = 'Data not added';
        }
        $this->renderJson($data);
    }

    private function sanitizeOrderId($orderId)
    {
        if (strlen($orderId) === 9 || (int)$orderId === 0) {
            return (int)$orderId;
        } else {
            return false;
        }
    }

    private function sanitizeSessionId($sessionId)
    {
        if (strlen($sessionId) > 0 && filter_var($sessionId, FILTER_SANITIZE_STRING)) {
            return filter_var($sessionId, FILTER_SANITIZE_STRING);
        } else {
            return false;
        }
    }

    private function sanitizeSign($sign)
    {
        if (strlen($sign) > 0 && strlen($sign) <= 100 && filter_var($sign, FILTER_SANITIZE_STRING)) {
            return filter_var($sign, FILTER_SANITIZE_STRING);
        } else {
            return false;
        }
    }

    private function checkSign($sign, $sessionId)
    {
        list($cartId, $sa_sid) = explode('|', $sessionId, 2);

        $cartId = (int)$cartId;

        $cart = new Cart($cartId);
        $amount = Przelewy24Helper::p24AmountFormat($cart->getOrderTotal(true, Cart::BOTH));
        $currency = new Currency($cart->id_currency);
        $sufix = ($currency->iso_code == "PLN") ? "" : "_" . $currency->iso_code;
        $merchantId = Configuration::get('P24_MERCHANT_ID' . $sufix);
        $salt = Configuration::get('P24_SALT' . $sufix);
        $countedSign = md5($sessionId . '|' . $merchantId . '|' . $amount . '|' . $currency->iso_code . '|' . $salt);

        if ($sign === $countedSign) {
            return true;
        }
        return false;
    }
}
