<?php

class przelewy24paymentStatusModuleFrontController extends ModuleFrontController
{
    public function postProcess()
    {
        Logger::addLog('postProcess ' . var_export($_POST, true), 1);

        if (Tools::getValue('p24_session_id')) {

            Logger::addLog('przelewy24paymentStatusModuleFrontController', 1);
            
            list($cartId, $sa_sid) = explode('|', Tools::getValue('p24_session_id'), 2);
            $cartId = (int)$cartId;

            $cart = new Cart($cartId);

            if (empty($cart) || !isset($cart->id) || $cartId < 1) {
                // not valid request
                exit;
            }

            Context::getContext()->currency = Currency::getCurrencyInstance((int)$cart->id_currency);

            $orderId = Order::getIdByCartId($cart->id);

            $total = (float)$cart->getOrderTotal(true, Cart::BOTH);
            $idOrderState = (int)Configuration::get('P24_ORDER_STATE_1');
            $customer = new Customer($cart->id_customer);
            $currency = new Currency($cart->id_currency);

            if(!$orderId){
                $this->module->validateOrder((int)$cart->id, $idOrderState, $total,
                    $this->module->displayName, NULL, array(), (int)$currency->id, false, $customer->secure_key);
            }

            $orderId = Order::getIdByCartId($cart->id);
            $order = new Order($orderId);


            $amount = Przelewy24Helper::p24AmountFormat($order->total_paid);
            $currency = new Currency($order->id_currency);
            $sufix = ($currency->iso_code == "PLN") ? "" : "_".$currency->iso_code;
            $validation = array('p24_amount' => $amount, 'p24_currency' => $currency->iso_code);

            $P24C = new Przelewy24Class(
                Configuration::get('P24_MERCHANT_ID' . $sufix),
                Configuration::get('P24_SHOP_ID' . $sufix),
                Configuration::get('P24_SALT' . $sufix),
                Configuration::get('P24_TEST_MODE' . $sufix)
            );

            $trnVerify = $P24C->trnVerifyEx($validation);
            Logger::addLog('postProcess trnVerify' . var_export($trnVerify, true), 1);

            if ($trnVerify === true) {
                $order->setCurrentState((int)Configuration::get('P24_ORDER_STATE_2'));

                if (Przelewy24OneClickHelper::isOneClickEnable($sufix)
                    && in_array((int)Tools::getValue('p24_method'), Przelewy24OneClickHelper::getCardPaymentIds())
                ) {
                    if (Przelewy24OneClickHelper::rememberCardForCustomer((int)$order->id_customer)) {
                        $p24Soap = new Przelewy24Soap($sufix);
                        $p24OrderId = (int)Tools::getValue('p24_order_id');
                        $result = Przelewy24OneClickHelper::getOneclickOrderId($p24OrderId);
                        if(isset($result['oneclick_order_id'])) {
                            $res = $p24Soap->getCardReferenceOneClick(Configuration::get('P24_API_KEY' . $sufix),
                                $p24OrderId, $result['oneclick_order_id']);
                            if (!empty($res)) {
                                $expires = substr($res->cardExp, 2, 2) . substr($res->cardExp, 0, 2);
                                if (date('ym') <= $expires) {
                                    Przelewy24OneClickHelper::saveCard($order->id_customer, $res->refId, $expires,
                                        $res->mask,
                                        $res->cardType);
                                } else {
                                    Logger::addLog('Błąd: termin ważności ' . var_export($expires, true), 1);
                                }
                            }
                        }
                        elseif(!isset($result['oneclick_order_id']) && !isset($result['p24_order_id']) && Configuration::get('P24_ONECLICK_ENABLE') && !Configuration::get('P24_PAY_CARD_INSIDE_ENABLE')){
                            $res = $p24Soap->getCardReferenceOneClickWithCheckCard(Configuration::get('P24_API_KEY' . $sufix),
                                $p24OrderId);
                            if (!empty($res)) {
                                $expires = substr($res->cardExp, 2, 2) . substr($res->cardExp, 0, 2);
                                if (date('ym') <= $expires) {
                                    Przelewy24OneClickHelper::saveCard($order->id_customer, $res->refId, $expires,
                                        $res->mask,
                                        $res->cardType);
                                } else {
                                    Logger::addLog('Błąd: termin ważności ' . var_export($expires, true), 1);
                                }
                            }
                        }
                        else{
                            Logger::addLog('Brak oneclick_order_id dla orderId: ' . $orderId, 1);
                        }
                    } else {
                        Logger::addLog('Nie pamiętaj karty dla userID: ' . $order->id_customer, 1);
                    }
                }

                Hook::exec('actionPaymentConfirmation', array('id_order' => $order->id));
            } else {
                $order->setCurrentState((int)Configuration::get('PS_OS_ERROR'));
            }
        }
        exit;
    }
}
