<?php


class przelewy24validateOrderRequestModuleFrontController extends ModuleFrontController
{
    protected function renderJson($data)
    {
        header("Content-Type: application/json;charset=utf-8");
        print json_encode($data);
        exit;
    }

    public function initContent()
    {
        parent::initContent();

        /** @var CartCore $cart */
        $cart = Context::getContext()->cart;
        /** @var CustomerCore $customer */
        $customer = Context::getContext()->customer;

        $requestCartId = (int)Tools::getValue('cartId');

        $currency = new Currency($cart->id_currency);

        $sufix = ($currency->iso_code == "PLN") ? "" : "_".$currency->iso_code;


        if ($requestCartId === (int)$cart->id) {

            if ($cart && Configuration::get('P24_VERIFYORDER' . $sufix) == 2) {

                if ($cart->OrderExists() == null) {
                    $amount = $cart->getOrderTotal(true, Cart::BOTH);

                    $orderBeginingState = Configuration::get('P24_ORDER_STATE_1');

                    $this->module->validateOrder((int)$cart->id, (int)$orderBeginingState, floatval($amount),
                        $this->module->displayName, NULL, array(), (int)$cart->id_currency, false, $customer->secure_key);
                }

                $orderId = (int)Order::getIdByCartId($cart->id);

                $this->renderJson(array('orderId' => $orderId, 'description' => $this->module->l('Order') . ' ' . $orderId));

            }
        }
        $this->renderJson([]);

    }

}