{extends file=$layout}

{block name='content'}
    <section id="main">
        <div class="box">
            {if $message}
                <div class="alert alert-success">
                    <span class="message">{$message}</span>
                    <button type="button" class="close" data-dismiss="alert">×</button>
                </div>
            {/if}

            <h1 class="page-heading">
                {l s='My stored cards' mod='przelewy24'}
            </h1>

            <div class="p24-account-card-form" data-translate-error="{l s='Something wrong' mod='przelewy24'}">
                <form action="" method="post">
                    <div>
                        <label>
                            <input type="checkbox"
                                   {if $remember_customer_cards}checked="checked"{/if}
                                   name="remember_credit_cards" value="1"/>
                            {l s='Memorize payment cards, which I pay' mod='przelewy24'}
                        </label>
                        <p>
                            <button type="submit" name="submit" class="btn btn-default" value="submit">
                                {l s='Save' mod='przelewy24'}
                            </button>
                        </p>
                    </div>
                    <input type="hidden" name="remember_cc_post" value="1">
                </form>
            </div>

            <div class="row p24-account-cards">
                {foreach $customer_cards as $ccard}
                    {if $ccard@first}
                        <div class="col-xs-12">
                            <p>{l s='Your credit cards are listed below.' mod='przelewy24'}</p>
                        </div>
                    {/if}
                    <div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
                        <div class="p24-ccbox">
                            <h1 class="page-heading">{$ccard.card_type}</h1>
                            <p>{$ccard.mask}</p>
                            <p>{$ccard.expires|substr:0:2}/{$ccard.expires|substr:2:2}</p>

                            <form action="" method="post"
                                  onsubmit="return confirm('{l s='Are you sure?' js=1 mod='przelewy24'}');">
                                <button type="submit" name="submit" class="btn btn-danger" value="submit">
                                    {l s='Delete' mod='przelewy24'}
                                </button>
                                <input type="hidden" name="remove_card" value="{$ccard.id}">
                            </form>

                        </div>
                    </div>
                    {foreachelse}
                    <div class="col-xs-12">
                        <h3>{l s='Credit cards not found' mod='przelewy24'}</h3>
                    </div>
                {/foreach}
            </div>
            <div id="P24FormAreaHolder" onclick="hidePayJsPopup();showRegisterCardButton();" style="display: none">
                <div onclick="arguments[0].stopPropagation();" id="P24FormArea" class="popup"
                     style="visibility: hidden"></div>
                <div id="p24-card-loader"></div>
                <div id="p24-card-alert" style="display: none"></div>
            </div>
            <div class="row p24-register-card-wrapper"
                 data-dictionary='{
                        "cardHolderLabel":"{l s='Cardholder name' mod='przelewy24'}",
                        "cardNumberLabel":"{l s='Card number' mod='przelewy24'}",
                        "cvvLabel":"{l s='cvv' mod='przelewy24'}",
                        "expDateLabel":"{l s='Expiry date' mod='przelewy24'}",
                        "payButtonCaption":"{l s='Save card data' mod='przelewy24'}",
                        "description":"{l s='Register card' mod='przelewy24'}"
                    }'
                 data-card-action="cardRegister"
                 data-successCallback="registerCardInPanelSuccess"
                 data-failureCallback="registerCardInPanelFailure"
                 data-action-register-card-confirm="{$link->getModuleLink('przelewy24', 'ajaxRegisterCardConfirm', [], true)|escape:'html'}"
                 data-action-register-card-form="{$link->getModuleLink('przelewy24', 'ajaxRegisterCardForm', [], true)|escape:'html'}">
                {*<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12 p24-register-card-row">*}
                    {*<p>*}
                        {*{l s='Register new credit card' mod='przelewy24'}:*}
                    {*</p>*}
                    {*<div id="p24-register-card-form" class="p24-register-card-form"></div>*}
                    {*<div class="p24-loader"></div>*}
                    {*<div class="p24-loader-bg"></div>*}
                    {*<p>*}
                        {*<a href="#" onclick="showPayJsPopup();hideRegisterCardButton();" class="btn btn-primary p24-add-credit-card">*}
                            {*{l s='Add credit card' mod='przelewy24'}*}
                        {*</a>*}
                    {*</p>*}
                {*</div>*}
            </div>

            <p class="p24-account-bottom-nav">
                <a class="btn btn-primary" href="{$link->getPageLink('my-account', true)|escape:'html':'UTF-8'}">
                    {l s='Back to your account' mod='przelewy24'}
                </a>
                <a href="{$urls.base_url}" class="btn btn-primary">
                    {l s='Return to shop' mod='przelewy24'}
                </a>
            </p>
        </div>
    </section>
{/block}