<?php
/**
* Promokit AmpGallery Widget
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class PsWidgetAmpGallery extends PsWidgetPageBuilder {

	public $is_footer = 0;
	public $is_header = 0;
	public $is_menu = 0;
	public $is_amp = 1;

	protected $max_image_size = 1048576;
	public $name = 'gallery_shortcode( $attr );';
	public $group = 'image';

	public function beforeAdminProcess($controller)
	{
		if (!Tools::getValue('widgetaction')) {
			$controller->addJS(_PAGEBUILDER_DIR_.'views/js/admin/image_gallery.js');
    }
	}

	public static function getWidgetInfo()
	{
		return array('label' => ('Images Gallery'), 'explain' => 'Create Images Mini Gallery From Folder', 'group' => 'images');
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();
		$key = time();
		$types = array();
		
		$types[] = array(
			'value' => 'tab',
			'text' => $this->l('Tab')
		);
		$types[] = array(
			'value' => 'carousel',
			'text' => $this->l('Carousel')
		);

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'switch',
					'label' => $this->l('Description Position Absolute'),
					'name' => 'position',
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Absolute')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('Static')
						)
					),
					'default' => '1'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Slide Image #1'),
					'name' => 'imagefile1',
					'class' => 'imageupload',
					'default' => '',
					'id' => 'imagefile1'.$key,
					'desc' => 'Put image folder in the image folder ROOT_SHOP_DIR/img/'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Slide Link #1'),
					'name' => 'link1',
					'default' => ''
				),
				array(
					'type' => 'textarea',
					'label' => $this->l('Slide Description #1'),
					'name' => 'description1',
					'default' => '',
					'lang' => true,
					'autoload_rte' => true,
				),
				array(
					'type' => 'text',
					'label' => $this->l('Slide Image #2'),
					'name' => 'imagefile2',
					'class' => 'imageupload',
					'default' => '',
					'id' => 'imagefile2'.$key,
					'desc' => 'Put image folder in the image folder ROOT_SHOP_DIR/img/'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Slide Link #2'),
					'name' => 'link2',
					'default' => ''
				),
				array(
					'type' => 'textarea',
					'label' => $this->l('Slide Description #2'),
					'name' => 'description2',
					'default' => '',
					'lang' => true,
					'autoload_rte' => true,
				),
				array(
					'type' => 'text',
					'label' => $this->l('Slide Image #3'),
					'name' => 'imagefile3',
					'class' => 'imageupload',
					'default' => '',
					'id' => 'imagefile3'.$key,
					'desc' => 'Put image folder in the image folder ROOT_SHOP_DIR/img/'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Slide Link #3'),
					'name' => 'link3',
					'default' => ''
				),
				array(
					'type' => 'textarea',
					'label' => $this->l('Slide Description #3'),
					'name' => 'description3',
					'default' => '',
					'lang' => true,
					'autoload_rte' => true,
				),
				array(
					'type' => 'text',
					'label' => $this->l('Slide Image #4'),
					'name' => 'imagefile4',
					'class' => 'imageupload',
					'default' => '',
					'id' => 'imagefile4'.$key,
					'desc' => 'Put image folder in the image folder ROOT_SHOP_DIR/img/'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Slide Link #4'),
					'name' => 'link4',
					'default' => ''
				),
				array(
					'type' => 'textarea',
					'label' => $this->l('Slide Description #4'),
					'name' => 'description4',
					'default' => '',
					'lang' => true,
					'autoload_rte' => true,
				),
				array(
					'type' => 'text',
					'label' => $this->l('Slide Image #5'),
					'name' => 'imagefile5',
					'class' => 'imageupload',
					'default' => '',
					'id' => 'imagefile5'.$key,
					'desc' => 'Put image folder in the image folder ROOT_SHOP_DIR/img/'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Slide Link #5'),
					'name' => 'link5',
					'default' => ''
				),
				array(
					'type' => 'textarea',
					'label' => $this->l('Slide Description #5'),
					'name' => 'description5',
					'default' => '',
					'lang' => true,
					'autoload_rte' => true,
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
		$fields_value = $this->getConfigFieldsValues($data);

		$helper->tpl_vars = array(
			'fields_value' => $fields_value,
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);

		return '<div id="imageslist'.$key.'">'.$helper->generateForm($this->fields_form).'<script>$(".imageupload").WPO_Gallery({gallery:false});</script></div>';
	}

	public function renderContent($setting)
	{
		$t = array(
			'position' => '',
			'description1' => '',
			'link1' => '',
			'imagefile1' => '',
			'description2' => '',
			'link2' => '',
			'imagefile2' => '',
			'description3' => '',
			'link3' => '',
			'imagefile3' => '',
			'description4' => '',
			'link4' => '',
			'imagefile4' => '',
			'description5' => '',
			'link5' => '',
			'imagefile5' => '',
		);
		
		$setting = array_merge($t, $setting);

		$language_id = Context::getContext()->language->id;

		for ($i=1; $i <= 5; $i++) { 

			$setting['slides'][$i]['description'] = isset($setting['description'.$i.'_'.$language_id]) ? ($setting['description'.$i.'_'.$language_id]) : '';
			$setting['slides'][$i]['link'] = isset($setting['link'.$i]) ? ($setting['link'.$i]) : '';

			if ($setting['imagefile'.$i]) {
				$img = _PS_MODULE_DIR_.'pspagebuilder/views/img/'.$setting['imagefile'.$i];
				$setting['slides'][$i]['imageurl'] = _PAGEBUILDER_IMAGE_URL_.$setting['imagefile'.$i];	
				if (file_exists($img)) {
          $setting['slides'][$i]['size'] = getimagesize($img);
        }
			}

		}

		$output = array('type' => 'ampgallery', 'data' => $setting);

		return $output;
	}
}