<?php
/**
* Promokit AmpInstagram Widget
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class PsWidgetAmpInstagram extends PsWidgetPageBuilder
{
	public $name = 'ampinstagram';
	public $group = 'Social';
	public $is_footer = 1;
	public $is_amp = 1;
	
	public function beforeAdminProcess($controller)
	{
		if (!Tools::getValue('widgetaction'))
			$controller->addJS(__PS_BASE_URI__.'modules/pspagebuilder/views/js/admin/image_gallery.js');
	}

	public static function getWidgetInfo()
	{
		return array('label' => ('Instagram'), 'explain' => 'Create Instagram Images Gallery From Instagram Account', 'group' => 'social');
	}

	public function renderForm($data)
	{
		$key = time();

		$helper = $this->getFormHelper();
		$soption = array(
			array(
				'id' => 'active_on',
				'value' => 1,
				'label' => $this->l('Enabled')
			),
			array(
				'id' => 'active_off',
				'value' => 0,
				'label' => $this->l('Disabled')
			)
		);

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'text',
					'label' => $this->l('User ID'),
					'name' => 'i_user',
					'default' => '2209812505',
					'desc' => 'Enter Instagram User ID'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Token code'),
					'name' => 'i_token',
					'default' => '2209812505.7ed9053.744d4d23c0854d4fb1eb37b85d89cd06',
					'desc' => "Enter Instagram Token Code; <a target='_blank' href='https://jelled.com/instagram/access-token'>How to get it?</a>"
				),
				array(
					'type' => 'select',
					'label' => $this->l( 'Carousel Auto Play' ),
					'name' => 'auto_play',
					'options' => array(  'query' => array(
						array('id' => 1, 'name' => $this->l('Enabled')),
						array('id' => 0, 'name' => $this->l('Disabled'))
						),
					'id' => 'id',
					'name' => 'name' ),
					'default' => ""
				),
				array(
					'type' => 'select',
					'label' => $this->l( 'Display Mode' ),
					'name' => 'display_mode',
					'options' => array(  'query' => array(
						array('id' => 'carousel', 'name' => $this->l('Carousel')),
						array('id' => 'normal', 'name' => $this->l('Normal'))
						),
					'id' => 'id',
					'name' => 'name' ),
					'default' => "carousel",
				),
				array(
					'type' => 'text',
					'label' => $this->l('How many images to show?'),
					'name' => 'limit',
					'default' => '6',
					'desc' => "Enter limit amount of images to show",
					'class' => 'fixed-width-xs'
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);

		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{

		$url = "https://api.instagram.com/v1/users/".$setting['i_user']."/media/recent?access_token=".$setting['i_token']."&count=".$setting['limit'];

		$ch = curl_init($url);

		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

		$json = curl_exec($ch);
		curl_close($ch);
		$result = Tools::jsonDecode($json,true);

		
		$setting['i_images'] = (isset($result['data']) && $result['data']) ? $result['data'] : "" ;

		$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? 'https://' : 'http://';
		$url = Tools::htmlentitiesutf8($protocol.$_SERVER['HTTP_HOST'].__PS_BASE_URI__);
		$list_mode_tpl = _PS_MODULE_DIR_.'/pspagebuilder/views/templates/front/widgets/sub/item_instagram.tpl';
		$tlist_mode_tpl = _PS_ALL_THEMES_DIR_._THEME_NAME_.'/modules/pspagebuilder/views/templates/front/widgets/sub/item_instagram.tpl';
		if (file_exists($tlist_mode_tpl)) {
			$list_mode_tpl = $tlist_mode_tpl;
		}
		$setting['list_mode_tpl'] = $list_mode_tpl;

		$output = array('type' => 'ampinstagram', 'data' => $setting);

		return $output;
	}

}