<?php
/**
* Promokit AmpLookbook Widget
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/
use PrestaShop\PrestaShop\Adapter\Image\ImageRetriever;
use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;
use PrestaShop\PrestaShop\Adapter\Product\ProductDataProvider;
use PrestaShop\PrestaShop\Core\Product\ProductListingPresenter;
use PrestaShop\PrestaShop\Adapter\Product\ProductColorsRetriever;
use PrestaShop\PrestaShop\Adapter\PricesDrop\PricesDropProductSearchProvider;
use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchContext;
use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchQuery;
use PrestaShop\PrestaShop\Core\Product\Search\SortOrder;

class PsWidgetAmpLookbook extends PsWidgetPageBuilder {

    public $is_footer = 0;
    public $is_header = 0;
    public $is_menu = 0;
    public $is_amp = 1;

    protected $max_image_size = 1048576;
    public $name = 'gallery_shortcode( $attr );';
    public $group = 'image';

    public static function getWidgetInfo()
    {
        return array('label' => ('Lookbook'), 'explain' => 'Shows content from module Lookbook', 'group' => 'images');
    }

    public function renderForm($data)
    {
        $helper = $this->getFormHelper();
        $key = time();
        $types = array();
        
        $types[] = array(
            'value' => 'tab',
            'text' => $this->l('Tab')
        );
        $types[] = array(
            'value' => 'carousel',
            'text' => $this->l('Carousel')
        );

        $this->fields_form[1]['form'] = array(
            'input' => array()
        );

        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
        $fields_value = $this->getConfigFieldsValues($data);

        $helper->tpl_vars = array(
            'fields_value' => $fields_value,
            'languages' => Context::getContext()->controller->getLanguages(),
            'id_language' => $default_lang
        );

        return $helper->generateForm($this->fields_form);
    }

    public function renderContent($setting)
    {
        $this->context = Context::getContext();
        $this->id_lang = $this->context->language->id;
        $this->id_shop = $this->context->shop->id;      

        $output = array('type' => 'amplookbook', 'data' => array('slides' => $this->getSlides(true)));

        return $output;
    }

    public function getSlides($active = null)
    {
        $slides = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT hs.`id_lookbook` as id_slide, hss.`position`, hss.`active`, hss.`products`, hssl.`title`,
            hssl.`url`, hssl.`legend`, hssl.`description`, hssl.`image`
            FROM '._DB_PREFIX_.'pk_lookbook hs
            LEFT JOIN '._DB_PREFIX_.'pk_lookbook_item hss ON (hs.id_lookbook = hss.id_lookbook)
            LEFT JOIN '._DB_PREFIX_.'pk_lookbook_item_lang hssl ON (hss.id_lookbook = hssl.id_lookbook)
            WHERE id_shop = '.(int)$this->id_shop.'
            AND hssl.id_lang = '.(int)$this->id_lang.
            ($active ? ' AND hss.`active` = 1' : ' ').'
            ORDER BY hss.position'
        );

        foreach ($slides as $id => &$slide)
        {
            $img = 'pk_lookbook/views/assets/images/'.$slide['image'];
            $imgPath = _PS_MODULE_DIR_.$img;
            $slide['image_url'] = $this->context->link->getMediaLink(_MODULE_DIR_.$img);

            if (file_exists($imgPath)) {
              $slide['size'] = getimagesize($imgPath);
            }

            $slide['points'] = json_decode($slide['products']);
            if (is_object($slide['points'])) {
                $products = '';
                foreach ($slide['points'] as $point) {                
                  $point->prod = $this->getSelectedProduct($point->pid);
                }
            }
        }

        return $slides;
    }

    public function getSelectedProduct($prod_id)
    {
        $product_ready = array();
        $product = new Product((int)$prod_id, true, $this->context->language->id);
        if (Validate::isLoadedObject($product) && isset($product->name[$this->context->language->id])) {
           $product = array((array)$product);
           $product[0]['id_product'] = $product[0]['id'];
           $product_ready = $this->prepareBlocksProducts( $product );
        }
    
        return $product_ready;
    }
    
    public function prepareBlocksProducts($block) {

        $blocks_for_template = [];
        $products_for_template = [];

        $assembler = new ProductAssembler($this->context);
        $presenterFactory = new ProductPresenterFactory($this->context);
        $presentationSettings = $presenterFactory->getPresentationSettings();
        $presenter = new ProductListingPresenter(new ImageRetriever($this->context->link), $this->context->link, new PriceFormatter(), new ProductColorsRetriever(), $this->context->getTranslator());
        $products_for_template = [];
        if ($block){
            foreach ($block as $key => $rawProduct) {
                $products_for_template[$key] = $presenter->present($presentationSettings, $assembler->assembleProduct($rawProduct), $this->context->language);
                $products_for_template[$key]['quantity_wanted'] = 1;
                if ($products_for_template[$key]['manufacturer_name'] == '') {
                    $products_for_template[$key]['manufacturer_name'] = Manufacturer::getNameById($rawProduct['id_manufacturer']);
                }
            }
        }

        return $products_for_template[0];
    }
}