<?php
/**
* Promokit AmpRevolution Slider Widget
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class PsWidgetAmpRevSlider extends PsWidgetPageBuilder {

	public $is_footer = 0;
  public $is_header = 0;
  public $is_menu = 0;
  public $is_amp = 1;

  public $name = 'amprevslider';
  public $group = 'image';
  public $module_name = 'revsliderprestashop';
	

	public static function getWidgetInfo()
	{
		return array('label' => 'Revolution Slider', 'explain' => 'Just select created slider to show', 'group' => 'images');
	}

  public static function getAllSliders(){
    $sliders = array();
    $query = 'SELECT * FROM `'._DB_PREFIX_.'revslider_sliders`;';
    $sliders_raw = Db::getInstance()->ExecuteS($query);
    foreach ($sliders_raw as $key => $slide) {
      $sliders[$key] = array('value' => $slide['id'], 'text' => $slide['alias']);
    }
    return $sliders;
  }

  // public static function getSlider($id){
  //   $query = 'SELECT * FROM `'._DB_PREFIX_.'revslider_sliders` WHERE id='.$id.';';
  //   $slider_raw = Db::getInstance()->ExecuteS($query);
  //   return $slider_raw;
  // }

  public static function getSliderSize($id){
    $query = 'SELECT `params` FROM `'._DB_PREFIX_.'revslider_sliders` WHERE id='.$id.';';
    $slider_raw = Db::getInstance()->ExecuteS($query);
    $slider_raw = json_decode($slider_raw[0]['params'], true);
    $slider_size['width'] = $slider_raw['width'];
    $slider_size['height'] = $slider_raw['height'];
    return $slider_size;
  }

  public function getAllSliderSlides($id){  
    $slider_size = $this->getSliderSize($id);
    $query = 'SELECT `id`, `params`, `layers` FROM `'._DB_PREFIX_.'revslider_slides` WHERE slider_id = '.$id.' ORDER BY `slide_order` ASC;';
    $sliders_raw = Db::getInstance()->ExecuteS($query);
    foreach ($sliders_raw as $k => &$val) {
      $val['params'] = json_decode($val['params'], true);
// skip if slider disabled in the settings
      if ($val['params']['state'] == 'unpublished') {
        unset($sliders_raw[$k]);
        continue;
      }
      $val['layers'] = json_decode($val['layers'], true);
      foreach ($val['layers'] as $k2 => $v) {
        $val['layers'][$k2]['pos_left'] = $v['left']['desktop'] * 100 / $slider_size['width'];
        $val['layers'][$k2]['pos_top'] = $v['top']['desktop'] * 100 / $slider_size['height'];
        
      }
    }
    return $sliders_raw;
  }  

	public function renderForm($data)
	{
    if (Module::isInstalled($this->module_name)) {
      $sliders = $this->getAllSliders();
    } else {
      return 'Slider is not Installed';
    }
		$helper = $this->getFormHelper();

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
        array(
          'type' => 'select',
          'label' => $this->l('Select Slider'),
          'name' => 'rev_slider',
          'options' => array(
            'query' => $sliders,
            'id' => 'value',
            'name' => 'text'
          ),
          'default' => '',
        ),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);
		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{


  


    if (Module::isInstalled($this->module_name)) {
  
      $arr['rev'] = $this->getAllSliderSlides($setting['rev_slider']);      
  
      $output = array(        
        'type' => 'amprevslider',
        'data' => $arr
      );
    } else {return false;}

		

		return $output;
	}
}
