<?php
/**
* Promokit BlogPosts Widget
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class PsWidgetBlogposts extends PsWidgetPageBuilder {

	public $name = 'blogposts';
	public $is_footer = 1;
	public $is_menu = 1;

	public static function getWidgetInfo()
	{
		return array('label' => 'Blog Posts (SimpleBlog)', 'explain' => 'Integrate with SimpleBlog Module to show blogs posts', 'group' => 'blog');
	}

	public function renderForm($data)
	{
		if (Module::isInstalled('ph_simpleblog') && Module::isEnabled('ph_simpleblog')) {
			require_once _PS_MODULE_DIR_.'ph_simpleblog/models/SimpleBlogCategory.php';
			$categoriesRaw = SimpleBlogCategory::getCategories($this->context->language->id, true);
			foreach ($categoriesRaw as $id => $cat) {
				$categories[$id]['value'] = $cat['id'];
				$categories[$id]['text'] = $cat['name'];
			}
		} else {
			$categories = array();
		}

		$helper = $this->getFormHelper();
		$lists = array(
			array('value' => 'list', 'text' => $this->l('List')),
			array('value' => 'grid', 'text' => $this->l('Grid'))
		);
		$carousel = array(
			array('value' => 'style-1', 'text' => $this->l('Style 1')),
			array('value' => 'style-2', 'text' => $this->l('Style 2')),
			array('value' => 'sidebar-mode', 'text' => $this->l('Sidebar'))
		);
		$arrowsPosition = array(
			array('value' => '0', 'text' => $this->l('Center')),
			array('value' => '1', 'text' => $this->l('Top Right'))
		);
		$modes = array(
			array('value' => 'normal', 'text' => $this->l('Normal List')),
			array('value' => 'carousel', 'text' => $this->l('Carousel'))
		);
		$types = array(
			array('value' => 'latest', 'text' => $this->l('Latest')),
			array('value' => 'featured', 'text' => $this->l('Featured')),
			array('value' => 'category', 'text' => $this->l('Category'))
		);
		
		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'select',
					'label' => $this->l('Display Mode'),
					'name' => 'display_mode',
					'options' => array('query' => $modes,
						'id' => 'value',
						'name' => 'text'),
					'default' => 'carousel',
				),
				array(
					'type' => 'select',
					'label' => $this->l('Display Style'),
					'name' => 'carouselStyle',
					'options' => array('query' => $carousel,
						'id' => 'value',
						'name' => 'text'),
					'default' => '',
				),
				array(
					'type' => 'select',
					'label' => $this->l('Display Posts'),
					'name' => 'posts_type',
					'options' => array(
						'query' => $types,
						'id' => 'value',
						'name' => 'text'
					),
					'default' => 'latest',
				),
				array(
					'type' => 'select',
					'label' => $this->l('Category'),
					'name' => 'category',
					'options' => array(
						'query' => $categories,
						'id' => 'value',
						'name' => 'text'
					),
					'default' => '---',
				),
				array(
					'type' => 'select',
					'label' => $this->l('Carousel Arrows Position'),
					'name' => 'arrowsPosition',
					'options' => array('query' => $arrowsPosition,
						'id' => 'value',
						'name' => 'text'),
					'default' => '',
				),
				array(
					'type' => 'text',
					'label' => $this->l('Posts to display'),
					'name' => 'nbr',
					'desc' => $this->l('Define the number of posts displayed in this block'),
					'default' => '3'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Items number per Slide'),
					'name' => 'items_per_slide',
					'default' => '1'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Items number on Desktops'),
					'name' => 'nbr_desktops',
					'default' => '2'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Items number on Tablets'),
					'name' => 'nbr_tablets',
					'default' => '2'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Items number on Mobile'),
					'name' => 'nbr_mobile',
					'default' => '1'
				),
				array(
					'type' => 'switch',
					'label' => $this->l('Show Thumbnail'),
					'name' => ('show_image'),
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Enabled')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('Disabled')
						)
					),
					'default' => '1'
				),
				array(
					'type' => 'switch',
					'label' => $this->l('Show Title'),
					'name' => ('show_title_blog'),
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('No')
						)
					),
					'default' => '1'
				),
				array(
					'type' => 'switch',
					'label' => $this->l('Show Description'),
					'name' => ('show_description'),
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('No')
						)
					),
					'default' => '200'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Description Symbols Number'),
					'name' => 'desc_size',
					'default' => '150'
				),
				array(
					'type' => 'switch',
					'label' => $this->l('Show "Read more" button'),
					'name' => ('show_readmore'),
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('No')
						)
					),
					'default' => '1'
				),
				array(
					'type' => 'switch',
					'label' => $this->l('Show Date'),
					'name' => ('show_date'),
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('No')
						)
					),
					'default' => '1'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Date Format'),
					'name' => 'post_date_format',
					'desc' => '<a href="https://www.smarty.net/docsv2/en/language.modifier.date.format.tpl" target="_blank">Date Format Description</a>',
					'default' => '%d %B'
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);
		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		$t = array(
			'name' => '',
			'html' => '',
			'nbr' => 6,
			'columns' => 4,
			'show_image' => 1,
			'show_title_blog' => 1,
			'show_info' => 1,
			'show_description' => 1,
			'desc_size' => 200,
			'show_readmore' => 1,
			'display_mode' => 'carousel',
			'nbr_desktops' => 2,
			'nbr_tablets' => 2,
			'nbr_mobile' => 1,
			'items_per_slide' => 1
		);

		$locale = str_replace('-', '_', $this->context->language->locale);
		setlocale(LC_TIME, $locale.'.utf8');

		$posts = array();
		$setting = array_merge($t, $setting);
		if (Module::isInstalled('ph_simpleblog') && Module::isEnabled('ph_simpleblog')) {
			require_once _PS_MODULE_DIR_.'ph_simpleblog/classes/BlogPostsFinder.php';
			
      $finder = new BlogPostsFinder;
      if ($setting['posts_type'] == 'featured') {
          $finder->setFeatured(true);
      } elseif ($setting['posts_type'] == 'category') {
          $finder->setIdCategory((int)$setting['category']);
      }

      $finder->setLimit((int)$setting['nbr']);
      $posts = $finder->findPosts();
		}

		$setting['posts'] = $posts;
		$setting['config'] = array();
		$setting['view_all_link'] = '----';
		$setting['modid'] = time();
		$setting['tabname'] = rand() + $setting['modid'];

		$output = array('type' => 'blogposts', 'data' => $setting);
		return $output;
	}
}