<?php
/**
 * Pts Prestashop Theme Framework for Prestashop 1.6.x
 *
 * @package   pspagebuilder
 * @version   5.0
 * @author    http://www.prestabrain.com
 * @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
 *               <info@prestabrain.com>.All rights reserved.
 * @license   GNU General Public License version 2
 */

class PsWidgetCounting extends PsWidgetPageBuilder {

	public $name = 'counting';
	public $group = 'typo';

	public static function getWidgetInfo()
	{
		return array('label' => ('Counting Number'), 'explain' => 'Play Counting Number In Effect', 'group' => 'typo');
	}

	public function beforeAdminProcess($controller)
	{
		if (!Tools::getValue('widgetaction'))
			$controller->addJS(_PAGEBUILDER_DIR_.'views/js/admin/image_gallery.js');
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();

		$key = time();
		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'text',
					'label' => $this->l('Icon File'),
					'name' => 'iconfile',
					'class' => 'imageupload',
					'default' => '',
					'id' => 'iconfile'.$key,
					'desc' => $this->l('Put image folder in the image folder')._PAGEBUILDER_IMAGE_URL_.'images/'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Icon Class'),
					'name' => 'iconclass',
					'class' => 'image',
					'default' => '',
					'desc' => $this->l('Icons Library:').'&nbsp;<a href="https://material.io/tools/icons/?style=baseline">https://material.io/tools/icons/</a>'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Counting Number'),
					'name' => 'counting_number',
					'default' => '100'
				),
				array(
					'type' => 'textarea',
					'label' => $this->l('Item Description'),
					'name' => 'item_text',
					'default' => '',
					'cols' => 40,
					'rows' => 10,
					'value' => true,
					'lang' => true,
					'autoload_rte' => true,
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
		$a = $this->getConfigFieldsValues($data);

		$helper->tpl_vars = array(
			'fields_value' => $a,
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);

		$string = '<script>$(".imageupload").WPO_Gallery({gallery:false});</script>';
		return '<div id="imageslist'.$key.'">'.$helper->generateForm($this->fields_form).$string.'</div>';
	}

	public function renderContent($setting)
	{
		$this->context->controller->addJS(_PAGEBUILDER_DIR_.'views/js/countup.js');
		$this->context->controller->addCSS('//fonts.googleapis.com/icon?family=Material+Icons');

		$t = array(
			'name' => '',
			'iconfile' => '',
			'iconclass' => '',
			'counting_number' => '',
			'item_text' => ''
		);
		$txt = '';

		$setting = array_merge($t, $setting);
		if (!empty($setting['iconfile']))
			$setting['iconurl'] = _PAGEBUILDER_IMAGE_URL_.$setting['iconfile'];

		$language_id = Context::getContext()->language->id;

		if (isset($setting['item_text_'.$language_id]))
		{
			$txt = $setting['item_text_'.$language_id];
			$txt = html_entity_decode($txt, ENT_QUOTES, 'UTF-8');
		}
		$setting['item_text_lang'] = $txt;

		$output = array('type' => 'counting', 'data' => $setting);

		return $output;
	}

}
