<?php
/**
 * Pts Prestashop Theme Framework for Prestashop 1.6.x
 *
 * @package   pspagebuilder
 * @version   5.0
 * @author    http://www.prestabrain.com
 * @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
 *               <info@prestabrain.com>.All rights reserved.
 * @license   GNU General Public License version 2
 */

class PsWidgetHtml extends PsWidgetPageBuilder {

	public $name = 'html';
	public $is_menu = 1;
	public $is_footer = 1;
	public $is_header = 1;
	public $is_amp = 0;
	public static function getWidgetInfo()
	{
		return array('label' => ('HTML'), 'explain' => 'Create HTML With multiple Language', 'group' => 'content');
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'textarea',
					'label' => $this->l('Content'),
					'name' => 'htmlcontent',
					'cols' => 40,
					'rows' => 10,
					'value' => '',
					'lang' => true,
					'default' => '',
					'autoload_rte' => true,
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);
		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);

		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		$t = array(
			'name' => '',
			'html' => '',
		);
		$content = array();
		$setting = array_merge($t, $setting);
		$language_id = Context::getContext()->language->id;
		if (isset($setting['htmlcontent_'.$language_id])) {
			$replace = array('[' => '<', ']' => '>');
      $setting['html'] = str_replace(array_keys($replace), array_values($replace), $setting['htmlcontent_'.$language_id]);
		} else {
			$setting['html'] = '';
		}

		$output = array('type' => 'html', 'data' => $setting);

		return $output;
	}

}
