<?php
/**
* Promokit Logo Widget
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class PsWidgetLogo extends PsWidgetPageBuilder {

	public $name = 'logo';
	public $is_menu = 0;
	public $is_footer = 0;
	public $is_header = 1;

	public static function getWidgetInfo()
	{
		return array('label' => 'Logo', 'explain' => 'Show your Logo', 'group' => 'content');
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();
		$aligns = array(
			array('value' => 'flex-start', 'text' => $this->l('Left')),
			array('value' => 'center', 'text' => $this->l('Center')),
			array('value' => 'flex-end', 'text' => $this->l('Right')),
		);
		$soption = array(
			array(
				'id' => 'active_on',
				'value' => 1,
			),
			array(
				'id' => 'active_off',
				'value' => 0,
			)
		);

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form'),
			),
			'input' => array(
				array(
					'type' => 'select',
					'label' => $this->l('Align Logo'),
					'name' => 'align_logo',
					'options' => array('query' => $aligns,
						'id' => 'value',
						'name' => 'text'
					),
					'default' => 'flex-start'
				),
				array(
					'type' => 'switch',
					'label' => $this->l('Logo as a Text'),
					'name' => 'logo_type',
					'values' => $soption,
					'default' => '1',
				),
				array(
					'type' => 'text',
					'label' => $this->l('Logo Text'),
					'name' => 'logo_text',
					'default' => '',
					'desc' => 'All these settings overrides your "Theme settings"',
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);
		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);

		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		$t = array(
			'name' => '',
			'align_logo' => '',
			'logo_text' => '',
			'logo_type' => '',
		);
		$content = array();
		$setting = array_merge($t, $setting);

		$output = array('type' => 'logo', 'data' => $setting);

		return $output;
	}

}