<?php
/**
 * Pts Prestashop Theme Framework for Prestashop 1.6.x
 *
 * @package   pspagebuilder
 * @version   5.0
 * @author    http://www.prestabrain.com
 * @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
 *               <info@prestabrain.com>.All rights reserved.
 * @license   GNU General Public License version 2
 */

class PsWidgetManufacturer extends PsWidgetPageBuilder {

	public $name = 'Manufacturer';
	public $is_footer = 1;
	public $is_menu = 1;

	public static function getWidgetInfo()
	{
		return array('label' => ('Manufacturer Logos'), 'explain' => 'Manufacture Logo', 'group' => 'prestashop');
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();
		$modes = array(
			array('value' => 'normal', 'text' => $this->l('Normal')),
			array('value' => 'carousel', 'text' => $this->l('Carousel'))
		);
		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'text',
					'label' => $this->l('Limit'),
					'name' => 'limit',
					'default' => 12,
				),
				array(
					'type' => 'select',
					'label' => $this->l('Display Mode'),
					'name' => 'display_mode',
					'options' => array('query' => $modes,
						'id' => 'value',
						'name' => 'text'),
					'default' => 'carousel',
				),
				array(
					'type' => 'switch',
					'label' => $this->l('Show Logo'),
					'name' => ('show_logo'),
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('No')
						)
					),
					'default' => '0'
				),
				array(
					'type' => 'switch',
					'label' => $this->l('Show Name'),
					'name' => ('show_name'),
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('No')
						)
					),
					'default' => '0'
				),
				array(
					'type' => 'switch',
					'label' => $this->l('Autoscroll'),
					'name' => 'autoscroll',
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('No')
						)
					),
					'default' => '0'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Number Columns On Desktops'),
					'name' => 'nbr_desktops',
					'default' => '4'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Number Columns On Tablets'),
					'name' => 'nbr_tablets',
					'default' => '2'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Number Columns On Mobile'),
					'name' => 'nbr_mobile',
					'default' => '1'
				)
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);
		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);
		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		$t = array(
			'name' => '',
			'html' => '',
			'columns' => 4,
			'list_mode' => 'grid',
			'display_mode' => 'carousel',
			'show_logo' => 1,
			'show_name' => 0,
			'autoscroll' => 0,
			'nbr_desktops' => 4,
			'nbr_tablets' => 2,
			'nbr_mobile' => 1,
			'widgetid' => 'manu-'.time()
		);

		$setting = array_merge($t, $setting);

		$manufacturers = Manufacturer::getManufacturers();

		foreach ($manufacturers as &$manufacturer) {
			$manufacturer['image'] = context::getContext()->link->getManufacturerImageLink($manufacturer['id_manufacturer'], 'brand_default');
      $manufacturer['url'] = context::getContext()->link->getmanufacturerLink($manufacturer['id_manufacturer']);
		}

		$setting['manufacturers'] = $manufacturers;

		$list_mode_tpl = _PS_MODULE_DIR_.'/pspagebuilder/views/templates/front/widgets/sub/item_manufacturer_'.$setting['list_mode'].'.tpl';
		$tlist_mode_tpl = _PS_ALL_THEMES_DIR_._THEME_NAME_.'/modules/pspagebuilder/views/templates/front/widgets/sub/item_manufacturer_'.$setting['list_mode'].'.tpl';
		if (file_exists($tlist_mode_tpl)) {
			$list_mode_tpl = $tlist_mode_tpl;
		}
		$setting['list_mode_tpl'] = $list_mode_tpl;
		$output = array('type' => 'manufacturer', 'data' => $setting);

		return $output;
	}

}
