<?php
/**
 * Pts Prestashop Theme Framework for Prestashop 1.6.x
 *
 * @package   pspagebuilder
 * @version   5.0
 * @author    http://www.prestabrain.com
 * @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
 *               <info@prestabrain.com>.All rights reserved.
 * @license   GNU General Public License version 2
 */

class PsWidgetModule extends PsWidgetPageBuilder {

	public $name = 'alert';
  public $is_header = 1;
	public $is_footer = 1;
  public $is_menu = 1;
  public $hooks = array(
    'displayHome',
    'displayLeftColumn',
    'displayRightColumn',
    'displayTop',
    'displayTopColumn',
    'displayFooter',
    'displayFooterBottom',
    'displayNav',
  );

	public static function getWidgetInfo()
	{
		return array('label' => ('Load Prestashop Module'), 'explain' => 'Load Prestashop Module as Widget', 'group' => 'prestashop');
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();
		$id_shop = Context::getContext()->shop->id;

		if (isset($data['params']['hookmodule']))
		{
			$hid = Hook::getIdByName($data['params']['hookmodule']);

			if ($hid)
			{
				$hms = Hook::getModulesFromHook($hid);

				foreach ($hms as $hm)
				{
					if ($data['params']['loadmodule'] == $hm['name'])
					{
						$id_module = $hm['id_module'];
						$module = Module::getInstanceById($id_module);
						if (Validate::isLoadedObject($module))
							!$module->unregisterHook((int)$hid, array($id_shop));
					}
				}
			}
		}

		$modules = Module::getModulesInstalled(0);

		$output = array();
		foreach( $modules as $mods ){
			$mod = Module::getInstanceByName( $mods['name'] );

			if( $mod && method_exists( $mod, 'renderWidget') ){
				$output[] = $mods;
			}
		}

 		$modules = $output;
		$output = array();

		//echo '<Pre>' . print_r( $modules ,1 );die;
		foreach ($this->hooks as $hook)
			$output[] = array('name' => $hook, 'id' => $hook);

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'select',
					'label' => $this->l('Select A Module Widget'),
					'name' => 'loadmodule',
					'options' => array('query' => $modules,
						'id' => 'name',
						'name' => 'name'),
					'default' => '1',
					'desc' => $this->l('Select A Module is used as widget. the hook of this module was unhooked.')
				)
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
		$a = $this->getConfigFieldsValues($data);

		$helper->tpl_vars = array(
			'fields_value' => $a,
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);

		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		$t = array(
			'name' => '',
			'loadmodule' => '',
			'hookmodule' => ''
		);

		$setting = array_merge($t, $setting);
		$widget_content = "<div class='alert-warning alert text-center'>Unable to load widget. <strong>Make sure the module \"".$setting['loadmodule']."\" is installed and enabled</strong></div>";

    $mod = Module::getInstanceByName($setting['loadmodule']);
    $enabled = Module::isEnabled($setting['loadmodule']);

    if ($mod && $enabled && method_exists($mod, 'renderWidget')) {
      $hooks = $this->getModuleHooks($setting['loadmodule']);
      $hook_name = null;
      if (isset($hooks[0]['hook_name'])) {
        $hook_name = $hooks[0]['hook_name'];
      }
			$widget_content = $mod->renderWidget($hook_name, array());
		}

		$setting['content'] = $widget_content;
		$setting['tabname'] = 'blogs'.time();

		$output = array('type' => 'module', 'data' => $setting);

		return $output;
	}

  public function getModuleHooks($module)
  {
    $id = Module::getModuleIdByName($module);
    $query = 'SELECT `id_hook` FROM `'._DB_PREFIX_.'hook_module` WHERE `id_module` = '.$id.' AND `id_shop` = '.$this->context->shop->id.';';
    $module_hooks = Db::getInstance()->ExecuteS($query);
    foreach ($module_hooks as $key => $hook) {
      $hook_name = Hook::getNameById($hook['id_hook']);
      if (in_array($hook_name, $this->hooks)) {
        $module_hooks[$key]['hook_name'] = $hook_name;
      } else {
        unset($module_hooks[$key]);
      }
    }
    return $module_hooks;
  }

}
