<?php
/**
 * Promokit Payment Systems Widget
 *
 * @package   pspagebuilder
 * @version   5.0
 * @author    https://promokit.eu
 * @copyright Copyright (C) October 2018 promokit.eu <@email:support@promokit.eu>
 * @license   GNU General Public License version 2
 */

class PsWidgetPaymentSystems extends PsWidgetPageBuilder {

	public $name = 'payment_systems';
	public $is_footer = 1;

	public static function getWidgetInfo()
	{
		return array('label' => 'Payment Systems', 'explain' => 'Display available Payment Systems', 'group' => 'prestashop');
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();

		$align = array(
			array('value' => 'flex-start', 'text' => $this->l('Left')),
			array('value' => 'center', 'text' => $this->l('Center')),
			array('value' => 'flex-end', 'text' => $this->l('Right')),
		);

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Separator Form.'),
			),
			'input' => array(
				array(
          'type' => 'select',
          'label' => $this->l('Align Icons'),
          'name' => 'align_items',
          'options' => array(
            'query' => $align,
            'id' => 'value',
            'name' => 'text'
          ),
          'default' => 'center',
        ),
        array(
					'type' => 'text',
					'label' => $this->l('Icons Width'),
					'name' => 'width_icons',
					'default' => '34'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Icons Margin'),
					'name' => 'margin_icons',
					'default' => '10'
				),
				array(
					'type' => 'color',
					'label' => $this->l('Icons Color'),
					'name' => 'color_icons',
					'default' => '#cecece',
				),
				array(
					'type' => 'switch',
					'label' => 'Visa',
					'name' => 'visa',
					'values' => array(
						array(
							'id' => 'visa_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'visa_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'Mastercard',
					'name' => 'mastercard',
					'values' => array(
						array(
							'id' => 'mastercard_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'mastercard_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'Maestro',
					'name' => 'maestro',
					'values' => array(
						array(
							'id' => 'maestro_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'maestro_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'American Express',
					'name' => 'amexpress',
					'values' => array(
						array(
							'id' => 'amexpress_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'amexpress_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'Discover',
					'name' => 'discover',
					'values' => array(
						array(
							'id' => 'discover_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'discover_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'PayPal',
					'name' => 'paypal',
					'values' => array(
						array(
							'id' => 'paypal_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'paypal_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'Skrill',
					'name' => 'skrill',
					'values' => array(
						array(
							'id' => 'skrill_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'skrill_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'Stripe',
					'name' => 'stripe',
					'values' => array(
						array(
							'id' => 'stripe_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'stripe_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),

				array(
					'type' => 'switch',
					'label' => 'Bitcoin',
					'name' => 'bitcoin',
					'values' => array(
						array(
							'id' => 'bitcoin_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'bitcoin_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'Bitcoin Gold',
					'name' => 'bitcoingold',
					'values' => array(
						array(
							'id' => 'bitcoingold_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'bitcoingold_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'Litecoin',
					'name' => 'litecoin',
					'values' => array(
						array(
							'id' => 'litecoin_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'litecoin_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'Ethereum',
					'name' => 'ethereum',
					'values' => array(
						array(
							'id' => 'ethereum_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'ethereum_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'Dogecoin',
					'name' => 'dogecoin',
					'values' => array(
						array(
							'id' => 'dogecoin_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'dogecoin_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
				array(
					'type' => 'switch',
					'label' => 'Monacoin',
					'name' => 'monacoin',
					'values' => array(
						array(
							'id' => 'monacoin_on',
							'value' => 1,
							'label' => $this->l('Show')
						),
						array(
							'id' => 'monacoin_off',
							'value' => 0,
							'label' => $this->l('Hide')
						),
					),
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			),
		);
		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);
		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		$setting = array(
      'items' => array(
  			'visa' => $setting['visa'],
  			'mastercard' => $setting['mastercard'],
  			'maestro' => $setting['maestro'],
  			'amexpress' => $setting['amexpress'],
  			'discover' => $setting['discover'],
  			'paypal' => $setting['paypal'],
  			'skrill' => $setting['skrill'],
  			'stripe' => $setting['stripe'],
  			'bitcoin' => $setting['bitcoin'],
  			'bitcoingold' => $setting['bitcoingold'],
  			'litecoin' => $setting['litecoin'],
  			'ethereum' => $setting['ethereum'],
  			'dogecoin' => $setting['dogecoin'],
  			'monacoin' => $setting['monacoin'],
      ),
      'align_items' => $setting['align_items'],
      'width_icons' => $setting['width_icons'],
      'margin_icons' => $setting['margin_icons'],
      'color_icons' => $setting['color_icons'],
		);
    $setting['footer'] = true;
		$output = array('type' => 'paymentsystems', 'data' => $setting);
		return $output;
	}

}