<?php
/**
 * Pts Prestashop Theme Framework for Prestashop 1.6.x
 *
 * @package   pspagebuilder
 * @version   5.0
 * @author    http://www.prestabrain.com
 * @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
 *               <info@prestabrain.com>.All rights reserved.
 * @license   GNU General Public License version 2
 */
require_once(_PS_MODULE_DIR_.'ps_linklist/ps_linklist.php');
class PsWidgetPrestaLinks extends PsWidgetPageBuilder {

	public $name = 'prestalinks';
	public $is_menu = 1;
	public $is_footer = 1;
  public $is_header = 1;

	public static function getWidgetInfo()
	{
		return array('label' => ('Prestashop Links'), 'explain' => 'Display Links from Link List module', 'group' => 'prestashop');
	}

  public static function getBlocks($raw = true)
	{
    $ps_links = new Ps_Linklist();
    $links = array();
    $rawLinks = $ps_links->getWidgetVariables('displayFooter', array());
    if (!empty($rawLinks['linkBlocks'])) {
      foreach ($rawLinks['linkBlocks'] as $key => $link) {
        $links[$key] = array('value' => $link['id'], 'text' => $link['title']);
      }
    }
    if ($raw) {
      return $rawLinks;
    } else {
      return $links;
    }
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();
    $links = $this->getBlocks(false);

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
        array(
          'type' => 'select',
          'label' => $this->l('Select Links Block'),
          'name' => 'links_block',
          'desc' => $this->l('Here you can only select link block. To edit or create new one, you have to go to the "Link List" module settings'),
          'options' => array(
            'query' => $links,
            'id' => 'value',
            'name' => 'text'
          ),
          'default' => '',
        ),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);
		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		$t = array(
			'name' => '',
			'html' => '',
		);

		$setting = array_merge($t, $setting);
    $rawLinks = $this->getBlocks();
    $links = array();

    if (!empty($rawLinks['linkBlocks'])) {
      foreach ($rawLinks['linkBlocks'] as $key => $block) {
        if ($block['id'] == $setting['links_block']) {
          $links = $block['links'];
        }
      }
    }

		$setting['id'] = rand();
		$setting['links'] = $links;

		$output = array('type' => 'prestalinks', 'data' => $setting);

		return $output;
	}

}
