<?php
/**
* Promokit Product Page Accessories
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class PsWidgetProductPageAccessories extends PsWidgetPageBuilder {

	public $name = 'productpageaccessories';
	public $group = 'productpage';
	public $is_menu = 0;
	public $is_footer = 0;
	public $is_header = 0;

	public static function getWidgetInfo()
	{
		return array(
			'label' => 'Accessories',
			'explain' => 'Product Page Widget',
			'group' => 'productpage'
		);
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();
		$carousel = array(
			array('value' => '', 'text' => $this->l('Default')),
			array('value' => 'mini', 'text' => $this->l('Mini Products'))
		);
		$arrowsPosition = array(
			array('value' => '0', 'text' => $this->l('Center')),
			array('value' => '1', 'text' => $this->l('Top Right'))
		);
		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'select',
					'label' => $this->l('Style Carousel'),
					'name' => 'carouselStyle',
					'options' => array(
						'query' => $carousel,
						'id' => 'value',
						'name' => 'text'
					),
					'default' => '',
				),
				array(
					'type' => 'select',
					'label' => $this->l('Arrows Position'),
					'name' => 'arrowsPosition',
					'options' => array(
						'query' => $arrowsPosition,
						'id' => 'value',
						'name' => 'text'
					),
					'default' => '',
				),
				array(
					'type' => 'text',
					'label' => $this->l('Number Items per Slide'),
					'name' => 'items_per_slide',
					'default' => '1'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Number Columns On Large Desktops.'),
					'name' => 'columns',
					'desc' => $this->l('The maximum column items  in tab.'),
					'default' => '4'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Number Columns On Small Desktops'),
					'name' => 'nbr_desktops',
					'default' => '4'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Number Columns On Tablets'),
					'name' => 'nbr_tablets',
					'default' => '2'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Number Columns On Mobile'),
					'name' => 'nbr_mobile',
					'default' => '1'
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
		);

		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		$setting['display_mode'] = 'carousel';
		$setting['list_mode_tpl'] = $this->getProductListStyleFile('grid', $setting['product_style']);
		return array('type' => $this->name, 'data' => $setting);
	}

}