<?php
/**
* Promokit Product Page Image
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class PsWidgetProductPageImage extends PsWidgetPageBuilder {

	public $name = 'productpageimage';
	public $group = 'productpage';
	public $is_menu = 0;
	public $is_footer = 0;
	public $is_header = 0;

	public static function getWidgetInfo()
	{
		return array(
			'label' => 'Image',
			'explain' => 'Product Page Widget',
			'group' => 'productpage'
		);
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'switch',
					'label' => $this->l('Show Thumbnails'),
					'name' => 'show_thumbs',
					'values' => array(
						array(
							'id' => 'active_on',
							'value' => 1,
							'label' => $this->l('Yes')
						),
						array(
							'id' => 'active_off',
							'value' => 0,
							'label' => $this->l('No')
						)
					),
					'default' => '1'
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
		);
		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		return array('type' => $this->name, 'data' => $setting);
	}

}