<?php
/**
* Promokit Product Page Tabs
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class PsWidgetProductPageTabs extends PsWidgetPageBuilder {

	public $name = 'productpagetabs';
	public $group = 'productpage';
	public $is_menu = 0;
	public $is_footer = 0;
	public $is_header = 0;

	public static function getWidgetInfo()
	{
		return array(
			'label' => 'Tabs',
			'explain' => 'Product Page Widget',
			'group' => 'productpage'
		);
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();
		$view = array(
			array('value' => 'horizontal', 'text' => $this->l('Horizontal')),
			array('value' => 'vertical', 'text' => $this->l('Vertical'))
		);
		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'select',
					'label' => $this->l('View'),
					'name' => 'view',
					'options' => array(
						'query' => $view,
						'id' => 'value',
						'name' => 'text'
					),
					'default' => 'horizontal',
				),
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
		);

		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		return array('type' => $this->name, 'data' => $setting);
	}

}