<?php
/**
* Promokit Revolution Slider Widget
*
* @package   alysum
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

class PsWidgetRevSlider extends PsWidgetPageBuilder {

  public $name = 'revslider';
  public $is_footer = 1;
  public $is_header = 1;
  public $module_name = 'revsliderprestashop';

  public static function getWidgetInfo()
  {
    return array('label' => 'Revolution Slider', 'explain' => 'Just select created slider to show', 'group' => 'images');
  }

  public static function getAllSliders(){
    $sliders = array();
    $query = 'SELECT * FROM `'._DB_PREFIX_.'revslider_sliders`;';
    $sliders_raw = Db::getInstance()->ExecuteS($query);
    foreach ($sliders_raw as $key => $slide) {
      $sliders[$key] = array('value' => $slide['alias'], 'text' => $slide['title']);
    }
    return $sliders;
  }

  public static function getSlider($alias){
    $query = 'SELECT * FROM `'._DB_PREFIX_.'revslider_sliders` WHERE alias="'.$alias.'";';
    $slider_raw = Db::getInstance()->ExecuteS($query);
    return $slider_raw;
  }

  public function renderForm($data)
  {
    if (Module::isInstalled($this->module_name)) {
      $sliders = $this->getAllSliders();
    } else {
      return 'Slider is not Installed';
    }

    $helper = $this->getFormHelper();

    $this->fields_form[1]['form'] = array(
      'legend' => array(
        'title' => $this->l('Widget Form.'),
      ),
      'input' => array(
        array(
          'type' => 'select',
          'label' => $this->l('Select Slider'),
          'name' => 'rev_slider',
          'options' => array(
            'query' => $sliders,
            'id' => 'value',
            'name' => 'text'
          ),
          'default' => '',
        ),
      ),
      'submit' => array(
        'title' => $this->l('Save'),
        'class' => 'button'
      )
    );

    $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

    $helper->tpl_vars = array(
      'fields_value' => $this->getConfigFieldsValues($data),
      'languages' => Context::getContext()->controller->getLanguages(),
      'id_language' => $default_lang
    );
    return $helper->generateForm($this->fields_form);
  }

  public function renderContent($setting)
  {
    $setting['slider'] = "<div class='alert-warning alert text-center'><strong>The slider doesn't exist. You have to import it first. Go to \"Theme Settings\" &rarr; \"Presets\"</strong></div>";

    if (Module::isInstalled($this->module_name)) {
      $slider = $this->getSlider($setting['rev_slider']);
      if (!empty($slider) && isset($slider[0]['alias'])) {
        require_once _PS_MODULE_DIR_.'revsliderprestashop/revsliderprestashop.php';
        $revsl = new RevsliderPrestashop();
        $setting['slider'] = $revsl->revSliderShortcode(array($slider['0']['alias']));
      }
    }

    $output = array(
      'type' => 'revslider',
      'data' => $setting
    );

    return $output;
  }

}