<?php
/**
 * Promokit Testimonials Widget
 *
 * @package   pspagebuilder
 * @version   5.0
 * @author    https://promokit.eu
 * @copyright Copyright (C) October 2018 promokit.eu <@email:support@promokit.eu>
 * @license   GNU General Public License version 2
 */

class PsWidgetTestimonials extends PsWidgetPageBuilder  {

	public $name = 'testimonials';
	public $group = 'content';
	public $check_profile;

	public static function getWidgetInfo()
	{
		return array(
			'label' => ('Testimonials'),
			'explain' => 'Display Customers Testimonials',
			'group' => 'content'
		);
	}

	public function renderForm($data)
	{
		$helper = $this->getFormHelper();

		$this->check_profile = str_replace('AdminPspagebuilder', '', Tools::getValue('controller'));

		$lists = array(
			array('value' => 'sidebar', 'text' => $this->l('Sidebar')),
			array('value' => 'general', 'text' => $this->l('General')),
		);

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				/*
				array(
          'type' => 'select',
					'label' => $this->l('Style'),
					'name' => 'list_mode',
					'options' => array('query' => $lists,
						'id' => 'value',
						'name' => 'text'),
					'default' => 'general',
				),
				*/
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);
		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);

		return $helper->generateForm($this->fields_form);
	}

	public function renderContent($setting)
	{
		$t = array(
			
		);

		//$setting = array_merge($t, $setting);

		if (Module::isInstalled('pk_testimonials') && Module::isEnabled('pk_testimonials')) {
			require_once _PS_MODULE_DIR_.'pk_testimonials/pk_testimonials.php';

			$pk_testimonials = new Pk_Testimonials();
			$setting['testimonials'] = $pk_testimonials->displayrandomTestimonial();

		}

		$output = array('type' => 'testimonials', 'data' => $setting);

		return $output;
	}


}