<?php

require_once(dirname(__FILE__).'/../../../../config/config.inc.php');
require_once(dirname(__FILE__).'/../../../../init.php');
use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchQuery;
use PrestaShop\PrestaShop\Core\Product\Search\SortOrder;
use PrestaShop\PrestaShop\Adapter\Search\SearchProductSearchProvider;
use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchContext;

header("access-control-allow-credentials:true");
header("access-control-allow-headers:Content-Type, Content-Length, Accept-Encoding, X-CSRF-Token");
header("access-control-allow-methods:GET");
header("access-control-expose-headers:AMP-Access-Control-Allow-Source-Origin");
header("amp-access-control-allow-source-origin: https://".$_SERVER['HTTP_HOST']);
header("access-control-allow-origin: https://".$_SERVER['HTTP_HOST']);
header("Content-Type: application/json");

$productsList = $pList = array();
$query = new ProductSearchQuery();
$link = new Link();
$productsList['emptyAndInitialTemplateJson']['query'] = $q = Tools::getValue('searchstring');
$productsList['endpoint'] = 'https://alysum5.promokit.eu/modules/pspagebuilder/controllers/front/ampsearch.php?searchstring=';
$globContext = Context::getContext();
$context = new ProductSearchContext($globContext);
$searchProvider = new SearchProductSearchProvider($globContext->getTranslator());

$query
    ->setSortOrder(new SortOrder('product', 'position', 'desc'))
    ->setSearchString($q);

$result = $searchProvider->runQuery(
    $context,
    $query
);

$productsListRaw = $result->getProducts();

if (!empty($productsListRaw)) {
  foreach ($productsListRaw as $k => $product) {

    $pList[$k]['id_product'] = $product['id_product'];
    $pList[$k]['price'] = Tools::displayPrice(Product::getPriceStatic((int)$product['id_product']));
    $pList[$k]['link_rewrite'] = $product['link_rewrite'];
    $pList[$k]['name'] = $product['name'];
    $pList[$k]['link'] = $product['link'];
    $pList[$k]['image'] = 'no-cover';

    $cover = Product::getCover($product['id_product']);
    if ($cover) {
        $pList[$k]['image'] = Tools::getShopProtocol().$link->getImageLink($product['link_rewrite'], $cover['id_image'], 'small_default');
    }

  }
  $productsList['emptyAndInitialTemplateJson']['results'] = $pList;
}
echo json_encode($productsList);