<?php
/**
* Promokit Page Builder
*
* @package   alysum
* @version   5.0.4
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*/

if (!defined('_PS_VERSION_'))
	exit;

require_once(_PS_MODULE_DIR_.'pspagebuilder/loader.php');
use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

class PsPageBuilder extends Module implements WidgetInterface {

	/**
	 * @var String $_prefix
	 */
	private $prefix;
	private $fields_form = array();
	private $profile = null;

	public function __construct()
	{
		$this->name = 'pspagebuilder';
		$this->tab = 'pricing_promotion';
		$this->version = '5.0.4';
		$this->author = 'PrestaBrain (Promokit Edition)';
		$this->need_instance = 0;

		$this->bootstrap = true;
		parent::__construct();
		$this->prefix = 'pspagebuilder';
    $this->templateFile = 'module:'.$this->name.'/views/templates/hook/pspagebuilder.tpl';
    $this->templateAmpFile = 'module:'.$this->name.'/views/templates/hook/amp_layout.tpl';

		$this->displayName = $this->l('Page Builder');
		$this->description = $this->l('Lightweigh and flexiable tool to build any kind of layout');
	}

	public function install()
	{
		$install = (
      parent::install()
      && $this->registerHook('displayHomeBuilder')
      && $this->registerHook('displayProductBuilder')
      && $this->registerHook('displayFooterBuilder')
      && $this->registerHook('displayHeaderBuilder')
      && $this->registerHook('displayHeader')
      && $this->registerHook('displayAmpContent')
      && $this->registerHook('categoryAddition')
			&& $this->registerHook('categoryUpdate')
			&& $this->registerHook('categoryDeletion')
			&& $this->registerHook('displayCMSBuilder')
			&& $this->registerHook('addproduct')
			&& $this->registerHook('updateproduct')
			&& $this->registerHook('deleteproduct')
			&& $this->registerHook('actionObjectLanguageAddAfter')
		);

		$this->clearBLHLCache();
		$this->createTables();
		$this->importDemo();

		$this->installModuleTab('Layout Builder', 'management', 'AdminPkMenu');
		$this->installModuleTab('Page Builder', 'profile', 'AdminPspagebuilderManagement');
    $this->installModuleTab('Footer Builder', 'footer', 'AdminPspagebuilderManagement');
    $this->installModuleTab('Header Builder', 'header', 'AdminPspagebuilderManagement');
    $this->installModuleTab('Sub-Menu Builder', 'menu', 'AdminPspagebuilderManagement');
    $this->installModuleTab('AMP Homepage Builder', 'amp', 'AdminPspagebuilderManagement');
    $this->installModuleTab('Images Management', 'image', 'AdminPspagebuilderManagement');

		return $install;
	}

	protected function createTables()
	{
		include_once(dirname(__FILE__).'/install/install.php');
		return true;
	}

	private function importDemo()
	{
		include_once(_PS_MODULE_DIR_.$this->name.'/install/bldpresets.php');
		$import = new BldPresets();
		return $import->start();
	}

	private function uninstallModuleTab($class_sfx = '')
	{
		$tab_class = 'Admin'.Tools::ucfirst($this->name).Tools::ucfirst($class_sfx);
		$id_tab = Tab::getIdFromClassName($tab_class);
		if ($id_tab != 0) {
			$tab = new Tab($id_tab);
			$tab->delete();
			return true;
		}
		return false;
	}

	public function installModuleTab($title, $class_sfx = '', $parent = '')
	{
		$className = 'Admin'.Tools::ucfirst($this->name).Tools::ucfirst($class_sfx);
		$class = Tab::getIdFromClassName($className);
    if (!$class) {
    	$tab = new Tab();
			$tab->active = 1;
			$tab->class_name = $className;
			$tab->name = array();
			foreach (Language::getLanguages(true) as $lang) {
				$tab->name[$lang['id_lang']] = $title;
	    }
	    if ($parent == 'AdminPkMenu') {
	    	$tab->icon = 'dashboard';
	    }
			$tab->id_parent = (int)Tab::getIdFromClassName($parent);
			$tab->module = $this->name;
			return $tab->add();
    }
	}

	public function uninstall()
	{
		$this->clearBLHLCache();
		$this->uninstallModuleTab('management');
		$this->uninstallModuleTab('profile');
		$this->uninstallModuleTab('image');
    $this->uninstallModuleTab('footer');
    $this->uninstallModuleTab('header');
    $this->uninstallModuleTab('menu');
    $this->uninstallModuleTab('amp');
    $this->deleteTables();
		return parent::uninstall();
	}

	public function deleteTables() {
		Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'pagebuilderprofile`');
		Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'pagebuilderprofile_shop`');
	}

	public function getContent()
	{
		$profile_id = PsPagebuilderprofile::getDefaultProfile();
		Tools::redirectAdmin('index.php?tab=AdminPspagebuilderProfile&id_pagebuilderprofile='.
						$profile_id.'&token='.Tools::getAdminTokenLite('AdminPspagebuilderProfile'));

		return '';
	}

	public function hookDisplayHeader()
	{
		$ctrl = $this->context->controller;
		$ctrl->addCSS($this->_path.'views/css/pagebuilder.css', 'all');
		$this->context->controller->addjqueryPlugin('fancybox');
		$this->context->controller->registerJavascript($this->name, 'modules/'.$this->name.'/views/js/pagebuilder.js', ['position' => 'bottom', 'priority' => 160, 'attributes' => 'async']);

		if (isset($ctrl->cms->id)) {
			$layoutID = $this->findLayout();
			if ($layoutID) {
				$this->context->smarty->assign(array(
					'CMSBilder' => true,
				));
			}
		}
		if (isset($ctrl->php_self) && $ctrl->php_self == 'index' && ($ctrl instanceof IndexController)) {
			$this->context->smarty->assign(array(
				'PTS_PAGEBUILDER_ACTIVED' => true,
				'PTS_PAGEBUILDER_FULL' => true,
				'PTS_PAGEBUILDER_CONTENT' => $this->processHook()
			));
		}

	}

	public function hookDisplayProductBuilder($params)
  {
  	return $this->processHook(array('is_product' => true));
	}

  public function hookDisplayFooterBuilder($params)
  {
		return $this->processHook(array('is_footer' => true));
	}

	public function hookDisplayHeaderBuilder($params)
  {
  	return $this->processHook(array('is_footer' => false, 'is_header' => true));
	}

	public function hookDisplayHomeBuilder($params)
	{
		return $this->processHook();
	}

	public function hookDisplayCMSBuilder($params)
	{
		$layoutID = $this->findLayout();
		return $this->processHook(array(), $layoutID);
	}

	public function findLayout()
	{
		$cmsAliasList = array();
		$layoutsList = array();
		$currentLayout = null;
		$obj = new PsPagebuilderprofile();
		$layoutIDs = $obj->getAllLayoutIDs();
		
		foreach ($layoutIDs as $key => $id) {
			$layoutsList[$id] = $obj->getNameByID($id);
		}

		$alias = CMS::getUrlRewriteInformations($this->context->controller->cms->id);
		$cmsAliasList[$this->context->controller->cms->id] = $alias[0]['link_rewrite'];

		$layout = array_intersect($layoutsList, $cmsAliasList);

		if (!empty($layout) && is_int(key($layout))) {
			return key($layout);
		}
		return false;
	}

	public function hookActionObjectLanguageAddAfter($params)
	{
		$id_lang_default = Configuration::get('PS_LANG_DEFAULT');
		$id_lang_current = $params['object']->id;

		$obj = new PsPagebuilderprofile();
		$profiles = $obj->getList();
		$fprofiles = $obj->getListByFooter();

		$profiles = array_merge($profiles, $fprofiles);

		if ($profiles){
			foreach ($profiles as &$profile){
				$ws = unserialize(PsPagebuilderHelper::clearUnexpected(trim($profile['widget'])));
				if ($ws){
					foreach ($ws as &$config){
						$configs = unserialize(PsPagebuilderHelper::clearUnexpected(trim($config['config'])));
						if (isset($configs['widget']) && $configs['widget']){
							foreach ($configs['widget'] as $k => $p){
								$arrs = explode('_', $k);
								$end = end($arrs);
								array_pop($arrs);
								if ($end == $id_lang_default)
									$configs['widget'][implode('_', $arrs).'_'.$id_lang_current] = $p;
							}
						}
						$config['config'] = serialize($configs);
					}
					$profile['widget'] = serialize($ws);
				}
				// save data here
				$new_obj = new PsPagebuilderprofile($profile['id_pagebuilderprofile']);
				$new_obj->widget = $profile['widget'];
				$new_obj->update();
			}
		}
	}

	public function dupplicatForAllLanguages()
	{
		$id_lang_default = Configuration::get('PS_LANG_DEFAULT');
		$languages = Language::getLanguages(false);

		$obj = new PsPagebuilderprofile();
		$profiles = $obj->getList();
		$fprofiles = $obj->getListByFooter();

		$profiles = array_merge($profiles, $fprofiles);

		if ($profiles) {
			foreach ($profiles as &$profile) {
				$ws = unserialize(PsPagebuilderHelper::clearUnexpected(trim($profile['widget'])));
				if ($ws){
					foreach ($ws as &$config) {
						$configs = unserialize(PsPagebuilderHelper::clearUnexpected(trim($config['config'])));
						if (isset($configs['widget']) && $configs['widget']){
							foreach ($configs['widget'] as $k => $p){
								$arrs = explode('_', $k);
								$end = end($arrs);
								array_pop($arrs);
								if ($end == $id_lang_default)
									foreach ($languages as $language)
										if ($language['id_lang'] != $id_lang_default)
											$configs['widget'][implode('_', $arrs).'_'.$language['id_lang']] = $p;
							}
						}
						$config['config'] = serialize($configs);
					}
					$profile['widget'] = serialize($ws);
				}
				// save data here
				$new_obj = new PsPagebuilderprofile($profile['id_pagebuilderprofile']);
				$new_obj->widget = $profile['widget'];
				$new_obj->update();
			}
		}
	}

	public function processHook($section = array(), $id = null)
	{
		$prefix = 'pagebuilder';
		$layout_tpl = _PAGEBUILDER_DIR_.'views/templates/hook/builderlayout.tpl';
    // get default ID profile pagebuilder
    if ($id == null) {
			$id = PsPagebuilderprofile::getDefaultProfile($section);
		}
		if (isset($section['is_product']) && ($section['is_product'] == true)) {
			$product_page_id = Configuration::get('pp_builder_layout');
			if (isset($product_page_id) && ($product_page_id != 0)) {
				$id = $product_page_id;
				$prefix = 'productpagebuilder';
			}
		}
		if (isset($section['is_footer']) && ($section['is_footer'] == true)) {
			$prefix = 'footerbuilder';
		}
		if (isset($section['is_header']) && ($section['is_header'] == true)) {
			$prefix = 'headerbuilder';
		}

		if (
			!$this->isCached($this->templateFile, $this->getCacheId(null, null, $id)) || 
			(isset($section['is_product']) && ($section['is_product'] == true)) || 
			(isset($section['is_header']) && ($section['is_header'] == true)))
		{
			$profile = new PsPagebuilderprofile($id, $this->context->language->id);
			$layout = $profile->getLayout();

			if (!empty($layout)) {
				$profile->loadWidgets();
				$ws = $profile->getWidgets();
				$layout = $this->buildLayoutData($layout, $ws, $profile, 1);
			}

			$this->smarty->assign(array(
				'layout' => $layout,
				'prefix' => $prefix,
				'layout_tpl' => $layout_tpl,
			));
		}
		if ( (isset($section['is_product']) && ($section['is_product'] == true)) || (isset($section['is_header']) && ($section['is_header'] == true)) ) {
			return $this->decode($this->fetch($this->templateFile));
		} else {
			return $this->decode($this->fetch($this->templateFile, $this->getCacheId(null, null, $id)));
		}
	}

  public function decode($data)
  {
     return html_entity_decode(html_entity_decode($data, ENT_QUOTES, "UTF-8"));
  }

	public function processAmp($id)
	{
		$profile = new PsPagebuilderprofile($id, $this->context->language->id);
		$layout = $profile->getLayout();

		if (!empty($layout)) {
			$profile->loadWidgets();
			$ws = $profile->getWidgets();
			$layout = $this->buildLayoutData($layout, $ws, $profile, 1);
		}

		return array('layout' => $layout);
	}

	public function hookDisplayAmpContent()
	{
		$layout_id = PsPagebuilderprofile::getDefaultProfile(array('is_amp' => true));
		$cache_id = $this->getCacheId(null, "displayAmpContent", $layout_id);
		$tmpl = $this->templateAmpFile;

		if (!$this->isCached($tmpl, $cache_id)) {
			$this->smarty->assign(
				'ampLayout', $this->processAmp($layout_id)
			);
		}

		return $this->fetch($tmpl, $cache_id);
	}

	public function buildLayoutData($rows, $ws, $profile, $rl = 1)
	{
		$layout = array();
		$mcrypt = new PtsMcrypt();

		foreach ($rows as $rkey => $row) {

			$row->level = $rl;
			$row = PsPagebuilderHelper::mergeRowData($row);

			foreach ($row->cols as $ckey => $col) {
				$col = PsPagebuilderHelper::mergeColData($col);

				foreach ($col->widgets as $wkey => $w) {
					$w->wkey = (string)$w->wkey;

					if ($w && isset($w->wkey) && isset($ws[$w->wkey])) {
						$content = trim($ws[$w->wkey]['config']);

						if ($content) {
							$widget = unserialize(PsPagebuilderHelper::clearUnexpected($content));

							if (isset($widget['widget'])) {

								foreach ($widget['widget'] as $k => $v) {

									$widget['widget'][$k] = $mcrypt->opensslDecrypt($v);
									if (PHP_VERSION < 7.2 && $widget['widget'][$k] == '') {
										//$widget['widget'][$k] = $mcrypt->decrypt($v);
									}

								}

								if (isset($widget['widget']['wtype'])) {
									$type = $widget['widget']['wtype'];
									$profile->loadWidgetObject($type, $this->context->controller);
									$tmp = $profile->getWidgetContent($type, $widget['widget']);
									if (empty($tmp['type'])) { $tmp['type'] = 'error';$tmp['data'] = 'error';}
									$col->widgets[$wkey]->content = $this->getWidgetContent($w->wkey, $tmp['type'], $tmp['data']);
								}
							}
						}
					}
				}
				if (isset($col->rows)) {
					$col->rows = $this->buildLayoutData($col->rows, $ws, $profile, $rl + 1);
        }
				$row->cols[$ckey] = $col;
			}

			$layout[$rkey] = $row;
		}

		return $layout;
	}

	public function getWidgetContent($id, $type, $data)
	{
		if ($data == 'error') return "Unable to get widget from DB";
		$data['id_lang'] = $this->context->language->id;
		if ($data) {
			foreach ($data as $key => $value) {
				if (is_string($value) && $key != 'product_tpl' && $key != 'branche_tpl_path' && $key != 'THEME_SKIN_DIR') {
					$data[$key] = Tools::stripslashes($value);
        }
      }
    }

		$this->smarty->assign($data);
		$output = '<div class="pts-widget" id="wid-'.$id.'">';
		$output .= $this->fetch('module:'.$this->name.'/views/templates/front/widgets/widget_'.$type.'.tpl');
		$output .= '</div>';

		return $output;
	}

	protected function getCacheId($name = null, $hook = '', $key = '')
	{
		$cache_array = array(
			$name !== null ? $name : $this->name,
			$hook,
			$key,
			date('Ymd'),
			(int)Tools::usingSecureMode(),
			(int)$this->context->shop->id,
			(int)Group::getCurrent()->id,
			(int)$this->context->language->id,
			(int)$this->context->currency->id,
			(int)$this->context->country->id
		);

		return implode('|', $cache_array);
	}

	public function clearBLHLCache()
	{
		$this->_clearCache('module:'.$this->name.'/views/templates/hook/builderlayout.tpl');
		$this->_clearCache($this->templateFile);
	}

	public function hookCategoryAddition()
	{
		$this->clearBLHLCache();
	}

	public function hookCategoryUpdate()
	{
		$this->clearBLHLCache();
	}

	public function hookCategoryDeletion()
	{
		$this->clearBLHLCache();
	}

	public function hookAddProduct()
	{
		$this->clearBLHLCache();
	}

	public function hookUpdateProduct()
	{
		$this->clearBLHLCache();
	}

	public function hookDeleteProduct()
	{
		$this->clearBLHLCache();
	}

	/*
	*
	*    Render Footer Builder Layout as widget
	*
	*/
	public function renderWidget($hookName = null, array $configuration = [])
  {
      return $this->processHook(array('is_footer' => true));
  }

  public function getWidgetVariables($hookName = null, array $configuration = [])
  {

  }
  public function getLayoutContent($id)
  {
		$pbkey = $id;
		if (!$this->isCached($this->templateFile, $this->getCacheId(null, null, $pbkey))) {

			$profile = new PsPagebuilderprofile($id, $this->context->language->id);
			$layout = $profile->getLayout();

			if (!empty($layout)) {
				$profile->loadWidgets();
				$ws = $profile->getWidgets();
				$layout = $this->buildLayoutData($layout, $ws, $profile, 1);
			}
			 
			$dir = _PS_MODULE_DIR_.'pspagebuilder/views/templates/hook/builderlayout.tpl';
			$tdir = _PS_ALL_THEMES_DIR_._THEME_NAME_.'/modules/pspagebuilder/views/templates/hook/builderlayout.tpl';
			if (file_exists($tdir))
				$dir = $tdir;

			$this->smarty->assign(array(
				'layout' => $layout,
				'layout_tpl' => $dir,
				'prefix' =>   'pagebuilder'
			));
		}
		$page = html_entity_decode(html_entity_decode($this->display(__FILE__, 'pspagebuilder.tpl', $this->getCacheId(null, null, $pbkey)), ENT_QUOTES, "UTF-8")); 
		return $page;
	}

}