{*
* Pts Prestashop Theme Framework for Prestashop 1.6.x
*
* @package   pspagebuilder
* @version   5.0
* @author    http://www.prestabrain.com
* @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
*               <info@prestabrain.com>.All rights reserved.
* @license   GNU General Public License version 2
*}
<div class="blog_container clearfix">
	{if $item.image && $show_image}
	<div class="blog-image">
		<a href="{$item.link}" title="{$item.title}" class="link">
			<img src="{$item.preview_url}" title="{$item.title}" class="img-responsive"/>
		</a>
	</div>
	{/if}
	<div class="blog-meta">
		{if $show_dateadd}
			<span class="blog-created">
				{strtotime($item.date_add)|date_format:"%b %d"}
			</span>
		{/if}
		{if $show_title_blog}
			<div class="text-uppercase h5">
				<a href="{$item.link}" title="{$item.title}">{$item.title|truncate:50:'...'}</a>
			</div>
		{/if}
		{if $show_category} 
			<span class="blog-cat"> <span class="icon-list">{l s='In' mod='pspagebuilder'}</span>
				<a href="{$item.category_link}" title="{$item.category_title}">{$item.category_title}</a>
			</span>
		{/if}
		{if $show_comment}<span class="blog-ctncomment">
			<span class="icon-comment">{l s='Comment' mod='pspagebuilder'}:</span> {$item.comment_count}</span>
		{/if}
		{if $show_description}
			<div class="blog-shortinfo">
				{$item.description|strip_tags|truncate:150:'...'}
			</div>
		{/if}
		{if $show_readmore}
			<div class="readmore">
				<a href="{$item.link}" title="{$item.title}" class="btn btn-default">{l s='Read more' mod='pspagebuilder'}</a>
			</div>
		{/if}
	</div>
</div>