{*
* Promokit AMP Categories Widget
*
* @package   pspagebuilder
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2018 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}

<div class="block {$addition_cls} block-borderbox{if isset($title_position)} {$title_position}{/if}">
  {if isset($widget_heading) && !empty($widget_heading)}
  {include file="_partials/heading.tpl" title={$widget_heading}}
  {/if}
  <amp-carousel height="{$amp.global.images.category.size.height}" width="{$amp.global.images.category.size.width}" layout="responsive" type="slides" data-next-button-aria-label="{l s='Next' mod='pspagebuilder'}" data-previous-button-aria-label="{l s='Previous' mod='pspagebuilder'}">
    {foreach from=$categories_info item=cat name=categories_info_name}
      {if $show_image && $cat.image}
      <div class="category relative">

        <a href="{$cat.link}" title="{$cat.name}">
          <amp-img src="{$cat.image}" width="{$amp.global.images.category.size.width}" height="{$amp.global.images.category.size.height}" layout="responsive" alt="{$cat.name}"></amp-img>
        </a>

        <div class="category-info text-center">
          {if $show_cat_title}
            <h3>
              <a href="{$cat.link}" title="{$cat.name}">{$cat.name}</a>
            </h3>
          {/if}

          {if $show_description}
          <span class="cat-desc">
            {$cat.description|strip_tags:'UTF-8'|truncate:{$limit_description}}
          </span>
          {/if}

          {if $show_shopnow}
            <a class="btn" href="{$cat.link}" title="{l s='Shop Now!' mod='pspagebuilder'}">
              {l s='Shop Now!' mod='pspagebuilder'}
            </a>
          {/if}
        </div>

      </div>
      {/if}
    {/foreach}
  </amp-carousel>
</div>