{*
* Promokit AMP Lookbook Widget
*
* @package   pspagebuilder
* @version   5.0
* @author    https://promokit.eu
* @copyright Copyright Ⓒ 2019 promokit.eu <@email:support@promokit.eu>
* @license   GNU General Public License version 2
*}
{if !empty($slides)}
<div class="pk-lookbook view_grid">
<div class="page-width">
  <h4 class="module-title"><span>{l s='Lookbook' mod='pspagebuilder'}</span></h4>
  <div class="lookbook-container">    
    <div class="lookbook-slides">
      <amp-carousel {$slides.0.size.3} layout="responsive" type="slides" data-next-button-aria-label="{l s='Next' mod='pspagebuilder'}" data-previous-button-aria-label="{l s='Previous' mod='pspagebuilder'}" controls>
      {foreach from=$slides item=slide}
        <article class="lookbook-item relative">
          <section class="lookbook-image relative">
            <div class="relative">
              <amp-img src="{$slide.image_url}" {$slide.size.3} layout="responsive" alt="{$slide.legend|escape}"></amp-img>
              <div class="pois">                  
                {foreach from=$slide.points item=point}
                  {assign var="pos" value=","|explode:$point->pos}
                  {assign var="product" value=$point->prod}
                  <div role="button" tabindex="{$product.id_product}" on="tap:lightbox-lookb-prod-{$product.id_product}" class="pk-poi smooth02 product-id{$point->pid}" data-pid="{$point->pid}" style="left:{$pos.0}%;top:{$pos.1}%">
                    <span class="pkPlus"></span>
                  </div>
                {/foreach}
              </div>
            </div>
            {if $slide.title || $slide.description}
              <span class="caption">
                {if $slide.title}<h2>{$slide.title}</h2>{/if}
                {if $slide.description}<div>{$slide.description nofilter}</div>{/if}
              </span>
            {/if}
          </section>          
        </article>
      {/foreach}
      </amp-carousel>
    </div>

    {foreach from=$slides item=slide}
      {foreach from=$slide.points item=point}
        {assign var="product" value=$point->prod}
        <amp-lightbox id="lightbox-lookb-prod-{$product.id_product}" layout="nodisplay">
          <div class="lightbox" on="tap:lightbox-lookb-prod-{$product.id_product}.close" role="button" tabindex="{$product.id_product}">
          <div class="lookbook-products-list">                          
            <article class="product-miniature {if $product.quantity == 0} out-of-stock{/if}{if (isset($product.new) && $product.new == 1)} new{/if}{if (isset($product.bestseller) && ($product.bestseller == 1))} bestsellers{/if}{if (isset($product.indexed) && $product.indexed == 1)} featured{/if}{if (isset($product.reduction) && $product.reduction > 0)} discount{/if}{if isset($product.all_cats)} {$product.all_cats}{else}{if isset($product.category)} {$product.category}{/if}{/if}" data-id-product="{$product.id_product}" data-id-product-attribute="{$product.id_product_attribute}" itemscope itemtype="http://schema.org/Product">
              <div class="thumbnail-container">
                <div class="pkClose">
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <svg class="svgic"><use xlink:href="#si-cross"></use></svg>
                  </button>
                </div>                     
                <div class="thumbnail product-thumbnail relative flex-container">
                  {if $product.has_discount}    
                    {if $product.discount_type === 'percentage'}
                      {if (isset($product.discount_percentage))}
                      <span class="discount_pk">{$product.discount_percentage}</span>
                      {/if}
                    {elseif $product.discount_type === 'amount'}
                      <span class="discount_pk">-{($product.reduction * 100 / $product.regular_price_amount)|string_format:"%d"}%</span>
                    {/if}
                  {/if}                             
                  <a href="{$product.url}" class="relative">
                    <amp-img
                      src="{$product.cover.bySize.home_default.url}"                                      
                      alt=""
                      width="{$product.cover.bySize.home_default.width}"
                      height="{$product.cover.bySize.home_default.height}"
                      class="cover-image"
                    >
                    </amp-img>
                  </a>
                </div>

                <div class="product-desc-wrap">
                  <div class="product-description">
                    <h3 class="product-title text-left{if Configuration::get('pm_title_multiline') == true} ellipsis{/if}" itemprop="name">
                      <a href="{$product.url}">{$product.name}</a>
                    </h3>
                    {if $product.show_price}
                      <div class="product-price-and-shipping">
                        {if $product.has_discount}
                          {hook h='displayProductPriceBlock' product=$product type="old_price"}
                          <span class="regular-price">{$product.regular_price}</span>
                          {if $product.discount_type === 'percentage'}
                            {if (isset($product.discount_percentage))}
                            <span class="discount-percentage discount-product">{$product.discount_percentage}</span>
                            {/if}
                          {elseif $product.discount_type === 'amount'}
                            {if (isset($product.discount_amount_to_display))}
                            <span class="discount-amount discount-product">{$product.discount_amount_to_display}</span>
                            {/if}
                          {/if}
                        {/if}
                        <span itemprop="price" class="price">{$product.price}</span>
                      </div>
                    {/if}                                    

                  </div>
                </div>
              </div>
            </article>
          </div>
      </div>
    </amp-lightbox>
    {/foreach}
    {/foreach}

  </div>
</div>
</div>
{/if}