{*
* Pts Prestashop Theme Framework for Prestashop 1.7.x
*
* @package   pspagebuilder
* @version   6.0
* @author    http://www.prestabrain.com
* @copyright Copyright (C) October 2016 prestabrain.com <@emai:prestabrain@gmail.com>
*               <info@prestabrain.com>.All rights reserved.
* @license   GNU General Public License version 2
*}
{if $page.page_name == 'product'}
{block name='page_content_container'}

  <section class="page-content" id="content">

  {if (isset($show_thumbs) && ($show_thumbs == 1))}
    {if (count($product.images)) > 1}
        <div class="pk-carousel relative pp-img-carousel" data-desktopnum="1" data-tabletnum="1" data-phonenum="1" data-loop="1" data-autoplay="0" data-navwrap="0">
          {foreach from=$product.images item=image}
            <div class="thumb-container">
              <img data-image-medium-src="{$image.bySize.medium_default.url}"
                data-image-large-src="{$image.bySize.large_default.url}"
                src="{$image.bySize.large_default.url}"
                alt="{$image.legend}"
                title="{$image.legend}"
                width="100%" itemprop="image">
            </div>
          {/foreach}
        </div>
    {/if}

  {else}

    {block name='page_content'}
      {block name='product_flags'}
        <ul class="product-flags">
          {foreach from=$product.flags item=flag}
            <li class="product-flag {$flag.type}">{$flag.label}</li>
          {/foreach}
          {if $product.has_discount}
            {if $product.discount_type === 'percentage'}
              <li class="product-flag discount">{l s='Save %percentage%' d='Shop.Theme.Catalog' sprintf=['%percentage%' => $product.discount_percentage_absolute]}</li>
            {else}
              <li class="product-flag discount">
                  {l s='Save %amount%' d='Shop.Theme.Catalog' sprintf=['%amount%' => $product.discount_to_display]}
              </li>
            {/if}
          {/if}
        </ul>
      {/block}

      {block name='product_cover_tumbnails'}
        {include file='catalog/_partials/product-cover-thumbnails.tpl'}
      {/block}
    {/block}

  {/if}

  </section>
{/block}
{/if}