{*
* Pts Prestashop Theme Framework for Prestashop 1.7.x
*
* @package   pspagebuilder
* @version   6.0
* @author    http://www.prestabrain.com
* @copyright Copyright (C) October 2016 prestabrain.com <@emai:prestabrain@gmail.com>
*               <info@prestabrain.com>.All rights reserved.
* @license   GNU General Public License version 2
*}
{if $page.page_name == 'product'}
{block name='product_tabs'}
<div class="tabs-container">
  <div class="tabs page-width">
    <ul class="nav nav-tabs flex-container">
      {if $product.description}
      <li class="nav-item">
        <a class="nav-link{if $product.description} active{/if}" data-toggle="tab" href="#description"><h5>{l s='Description' d='Shop.Theme.Catalog'}</h5></a>
      </li>
      {/if}
      <li class="nav-item">
        <a class="nav-link{if !$product.description} active{/if}" data-toggle="tab" href="#product-details"><h5>{l s='Product Details' d='Shop.Theme.Catalog'}</h5></a>
      </li>
      {if $product.attachments}
      <li class="nav-item">
        <a class="nav-link" data-toggle="tab" href="#attachments"><h5>{l s='Attachments' d='Shop.Theme.Catalog'}</h5></a>
      </li>
      {/if}
      {foreach from=$product.extraContent item=extra key=extraKey}
      <li class="nav-item">
        <a class="nav-link" data-toggle="tab" href="#extra-{$extraKey}"><h5>{$extra.title}</h5></a>
      </li>
      {/foreach}
      {hook h='productTab'}
    </ul>

    <div class="tab-content" id="tab-content">
     <div class="tab-pane fade in{if $product.description} active{/if}" id="description">
       {block name='product_description'}
         <div class="product-description">{$product.description nofilter}</div>
       {/block}
     </div>

     {block name='product_details'}
       {include file='catalog/_partials/product-details.tpl' builder=1}
     {/block}

     {block name='product_attachments'}
       {if $product.attachments}
        <div class="tab-pane fade in" id="attachments">
           <section class="product-attachments">
             <h3 class="h5 text-uppercase">{l s='Download' d='Shop.Theme.Actions'}</h3>
             {foreach from=$product.attachments item=attachment}
               <div class="attachment">
                 <h4><a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">{$attachment.name}</a></h4>
                 <p>{$attachment.description}</p
                 <a href="{url entity='attachment' params=['id_attachment' => $attachment.id_attachment]}">
                   {l s='Download' d='Shop.Theme.Actions'} ({$attachment.file_size_formatted})
                 </a>
               </div>
             {/foreach}
           </section>
         </div>
       {/if}
     {/block}
     {foreach from=$product.extraContent item=extra key=extraKey}
     <div class="tab-pane fade in {$extra.attr.class}" id="extra-{$extraKey}" {foreach $extra.attr as $key => $val} {$key}="{$val}"{/foreach}>
         {$extra.content nofilter}
     </div>
     {/foreach}
     {hook h='productTabContent'}
    </div>
  </div>
</div>
{/block}
{/if}