<?php

if (!defined('_PS_VERSION_')) {
    header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
    header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
    header('Cache-Control: no-store, no-cache, must-revalidate');
    header('Cache-Control: post-check=0, pre-check=0', false);
    header('Pragma: no-cache');
    header('Location: ../');
}

class RevPresets extends Module {

  public function start()
  {
    $installBD = $this->installDB();
    if ($installBD === true) {
      $response = true;//Module::displayConfirmation('Import succeed');
    } else {
      $response = Module::displayError($installBD);
    }
    return $response;
  }

  public function installDB()
  {
    $sql_file = dirname(__FILE__).'/presets.sql';

    if (!file_exists($sql_file)) {

      return 'There is no import file: '.$sql_file;

    } else if (!$sql = file_get_contents($sql_file)) {

      return 'SQL syntax error in import file: '.$sql_file;

    } else {

      $search = array('PREFIX_', 'SHOP_ID', 'LANG_ID');
      $replace = array(_DB_PREFIX_, $this->context->shop->id, $this->context->language->id);

      $queries = str_replace($search, $replace, $sql);
      $queries = preg_split("/;\s*[\r\n]+/", $queries);

      foreach ($queries AS $query) {

        if ($query) {

          try {
            if (!Db::getInstance()->execute(trim($query))) {
              return 'Error in SQL syntax! '.$query;
            }
          } catch (\Exception $e) {
            return 'Error in SQL syntax!';
          }

        }
      }
    }

    return true;

  }

}
