<?php
/**
 * HTMLTemplateRentalPaymentInvoicePdf.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  HTMLTemplateRentalPaymentInvoicePdf
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * HTMLTemplateRentalPaymentInvoicePdf.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */
class HTMLTemplateRentalPaymentInvoicePdf extends HTMLTemplate
{
    public $custom_object;

    public function __construct($custom_object, $smarty)
    {
        $this->custom_object = $custom_object;
        $this->smarty = $smarty;
        // header informations
        $this->title = HTMLTemplateRentalPaymentInvoicePdf::l('Rental Payment Invoice');
        $this->date = Tools::displayDate(date('Y-m-d', time()));
        $this->shop = new Shop(Context::getContext()->shop->id);
        $this->assignCommonHeaderData();
    }

    public function assignCommonHeaderData()
    {
        $id_shop = (int)$this->shop->id;
        $shop_name = Configuration::get('PS_SHOP_NAME', null, null, $id_shop);

        $path_logo = $this->getLogo();

        $width = 0;
        $height = 0;
        if (!empty($path_logo)) {
            list($width, $height) = getimagesize($path_logo);
        }

        // Limit the height of the logo for the PDF render
        $maximum_height = 100;
        if ($height > $maximum_height) {
            $ratio = $maximum_height / $height;
            $height *= $ratio;
            $width *= $ratio;
        }

        $this->smarty->assign(array(
            'logo_path' => $path_logo,
            'img_ps_dir' => 'http://'.Tools::getMediaServer(_PS_IMG_)._PS_IMG_,
            'img_update_time' => Configuration::get('PS_IMG_UPDATE_TIME'),
            'date' => $this->date,
            'title' => $this->title,
            'shop_name' => $shop_name,
            'shop_details' => Configuration::get('PS_SHOP_DETAILS', null, null, (int)$id_shop),
            'width_logo' => $width,
            'height_logo' => $height
        ));
    }

    /**
     * Returns the template's HTML content
     * @return string HTML content
     */
    public function getContent()
    {
        $payment = $this->custom_object->payment;
        $invoiceAddressPatternRules = json_decode(Configuration::get('PS_INVCE_INVOICE_ADDR_RULES'), true);
        $deliveryAddressPatternRules = json_decode(Configuration::get('PS_INVCE_DELIVERY_ADDR_RULES'), true);
        if ($payment->id_order) {
            $order = new Order($payment->id_order);
            $invoice_address = new Address((int) $order->id_address_invoice);
            $country = new Country((int) $invoice_address->id_country);
            $formatted_invoice_address = AddressFormat::generateAddress($invoice_address, $invoiceAddressPatternRules, '<br />', ' ');

            $delivery_address = null;
            $formatted_delivery_address = '';
            if (isset($this->order->id_address_delivery) && $order->id_address_delivery) {
                $delivery_address = new Address((int) $order->id_address_delivery);
                $formatted_delivery_address = AddressFormat::generateAddress($delivery_address, $deliveryAddressPatternRules, '<br />', ' ');
            }
        } else {
            if ($id_address = Address::getFirstCustomerAddressId($this->custom_object->customer->id)) {
                $address = new Address($id_address);
                $addressPatternRules = json_decode(Configuration::get('PS_INVCE_DELIVERY_ADDR_RULES'), true);
                $formatted_invoice_address = AddressFormat::generateAddress($address, $addressPatternRules, ',  ', ' ');
            } else {
            }
        }
        $customer = new Customer((int) $order->id_customer);

        $this->smarty->assign((array)$this->custom_object);
        $this->smarty->assign(array(
            'use_tax' => (int)Configuration::get('PS_TAX'),
            'delivery_address' => $formatted_delivery_address,
            'invoice_address' => $formatted_invoice_address,
            'customer' => $customer,
        ));

        $tpls = array(
            'style_tab' => $this->smarty->fetch($this->getTemplate('rentalpaymentinvoice.styles')),
            'addresses_tab' => $this->smarty->fetch($this->getTemplate('rentalpaymentinvoice.addresses-tab')),
            'summary_tab' => $this->smarty->fetch($this->getTemplate('rentalpaymentinvoice.summary-tab')),
            'template_data' => $this->custom_object,
        );
        $this->smarty->assign($tpls);

        $content = $this->smarty->fetch($this->getTemplate('rentalpaymentinvoice.content'));
        return $content;
    }

    public function getHeader()
    {
        $this->assignCommonHeaderData();
        $this->smarty->assign(
            array(
                'header' => $this->custom_object->header,
                'title' => $this->custom_object->title
            )
        );
        return $this->smarty->fetch($this->getTemplate('rentalpaymentinvoice.header'));
    }

    public function getPagination()
    {
        return $this->smarty->fetch($this->getTemplate('rentalpaymentinvoice.pagination'));
    }

    /**
     * Returns the template filename
     * @return string filename
     */
    public function getFooter()
    {
        $shop_address = $this->getShopAddress();
        $id_shop = (int)$this->shop->id;
        $this->smarty->assign(array(
            'available_in_your_account' => $this->available_in_your_account,
            'shop_address' => $shop_address,
            'shop_fax' => Configuration::get('PS_SHOP_FAX', null, null, $id_shop),
            'shop_phone' => Configuration::get('PS_SHOP_PHONE', null, null, $id_shop),
            'shop_email' => Configuration::get('PS_SHOP_EMAIL', null, null, $id_shop),
            'free_text' => Configuration::get(
                'PS_INVOICE_FREE_TEXT',
                (int)Context::getContext()->language->id,
                null,
                $id_shop
            )
        ));

        return $this->smarty->fetch($this->getTemplate('rentalpaymentinvoice.footer'));
    }

    /**
     * Returns the template filename
     * @return string filename
     */
    public function getFilename()
    {
        if ($this->custom_object->filename) {
            return $this->custom_object->filename;
        } else {
            return 'rentalconfirmation.pdf';
        }
    }

    /**
     * Returns the template filename when using bulk rendering
     * @return string filename
     */
    public function getBulkFilename()
    {
        return 'custom_pdf.pdf';
    }

    protected function getTemplate($template_name)
    {
        $template = false;
        $default_template = _PS_MODULE_DIR_ . 'roja45productrental/views/templates/front/' . $template_name . '.tpl';
        $overridden_template = _PS_ALL_THEMES_DIR_ . $this->shop->getTheme() . DIRECTORY_SEPARATOR .
            'modules/roja45productrental/views/templates/front/' . $template_name . '.tpl';
        if (file_exists($overridden_template)) {
            $template = $overridden_template;
        } elseif (file_exists($default_template)) {
            $template = $default_template;
        }

        return $template;
    }
}
