<?php
/**
 * ProductRentalDamageDeposit
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalDamageDeposit
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalDamageDeposit
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalDamageDeposit extends ObjectModel
{
    const DAMAGE_DEPOSIT_FIXED_TYPE = 1;
    const DAMAGE_DEPOSIT_PERCENTAGE_TYPE = 2;
    const DAMAGE_DEPOSIT_ASIS_METHOD = 1;
    const DAMAGE_DEPOSIT_PERITEM_METHOD = 2;
    const DAMAGE_DEPOSIT_PERITEMPERDAY_METHOD = 3;
    const DAMAGE_DEPOSIT_TOTALVALUE_SOURCE = 1;
    const DAMAGE_DEPOSIT_TOTALPAID_SOURCE = 2;
    const DAMAGE_DEPOSIT_TAXINC = 1;
    const DAMAGE_DEPOSIT_TAXEXC = 2;

    public $id_roja45_product_damagedeposit;
    public $id_deposit_type;
    public $id_deposit_method;
    public $id_deposit_source_value;
    public $with_tax;
    public $name;
    public $deposit_amount;
    public $enabled;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_damagedeposit',
        'primary' => 'id_roja45_product_damagedeposit',
        'multilang' => false,
        'fields' => array(
            'id_deposit_type' => array('type' => self::TYPE_INT, 'lang' => false),
            'id_deposit_method' => array('type' => self::TYPE_INT, 'lang' => false),
            'id_deposit_source_value' => array('type' => self::TYPE_INT, 'lang' => false),
            'with_tax' => array('type' => self::TYPE_INT, 'lang' => false),
            'name' => array('type' => self::TYPE_STRING, 'lang' => false),
            'deposit_amount' => array('type' => self::TYPE_FLOAT, 'lang' => false),
            'enabled' => array('type' => self::TYPE_BOOL, 'lang' => false),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public function isRemovable()
    {
        return true;
    }

    public static function getDamageDeposits($enabled = true)
    {
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_damagedeposit', 'dd');
        $sql->where('dd.enabled = ' . (int) $enabled);
        return Db::getInstance()->executeS($sql);
    }

    public function calculateDamageDeposit(
        $number_of_models,
        $periods,
        $total_model_to_pay_exc,
        $total_model_to_pay_inc,
        $total_model_to_pay_now_exc,
        $total_model_to_pay_now_inc
    ) {
        if ($this->id_deposit_type == ProductRentalDamageDeposit::DAMAGE_DEPOSIT_PERCENTAGE_TYPE) {
            if ($this->with_tax==ProductRentalDamageDeposit::DAMAGE_DEPOSIT_TAXINC) {
                if ($this->id_deposit_source_value == ProductRentalDamageDeposit::DAMAGE_DEPOSIT_TOTALPAID_SOURCE) {
                    $model_damage_deposit = $total_model_to_pay_inc * ($this->deposit_amount/100);
                } elseif ($this->id_deposit_source_value == ProductRentalDamageDeposit::DAMAGE_DEPOSIT_TOTALVALUE_SOURCE) {
                    $model_damage_deposit = $total_model_to_pay_now_inc * ($this->deposit_amount/100);
                }
            } elseif ($this->with_tax==ProductRentalDamageDeposit::DAMAGE_DEPOSIT_TAXEXC) {
                if ($this->id_deposit_source_value == ProductRentalDamageDeposit::DAMAGE_DEPOSIT_TOTALPAID_SOURCE) {
                    $model_damage_deposit = $total_model_to_pay_exc * ($this->deposit_amount/100);
                } elseif ($this->id_deposit_source_value == ProductRentalDamageDeposit::DAMAGE_DEPOSIT_TOTALVALUE_SOURCE) {
                    $model_damage_deposit = $total_model_to_pay_now_exc * ($this->deposit_amount/100);
                }
            }
        } elseif ($this->id_deposit_type == ProductRentalDamageDeposit::DAMAGE_DEPOSIT_FIXED_TYPE) {
            if ($this->id_deposit_method == ProductRentalDamageDeposit::DAMAGE_DEPOSIT_ASIS_METHOD) {
                $model_damage_deposit = $this->deposit_amount;
            } elseif ($this->id_deposit_method == ProductRentalDamageDeposit::DAMAGE_DEPOSIT_PERITEM_METHOD) {
                $model_damage_deposit = $this->deposit_amount * $number_of_models;
            } elseif ($this->id_deposit_method == ProductRentalDamageDeposit::DAMAGE_DEPOSIT_PERITEMPERDAY_METHOD) {
                $model_damage_deposit = $this->deposit_amount * $number_of_models * $periods;
            }
        }
        return $model_damage_deposit;
    }
}
