<?php
/**
 * ProductRentalPeriodRate
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  ProductRentalPeriodRate
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * ProductRentalPeriodRate
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

class ProductRentalDateRate extends ObjectModel
{
    public $id_roja45_product_daterate;
    public $id_roja45_product;
    public $id_roja45_product_model;
    public $id_roja45_product_rate;
    public $date;
    public $rate;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'roja45_productrental_daterate',
        'primary' => 'id_roja45_product_daterate',
        'multilang' => false,
        'fields' => array(
            'id_roja45_product' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'id_roja45_product_model' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'id_roja45_product_rate' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'date' => array('type' => self::TYPE_DATE, 'required' => true),
            'rate' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),
        ),
    );

    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public static function exists($id_roja45_product, $id_roja45_product_model, $id_roja45_product_rate, $date)
    {
        $sql = new DbQuery();
        $sql->select('id_roja45_product_daterate');
        $sql->from('roja45_productrental_daterate', 'dr');
        $sql->where('dr.id_roja45_product=' . (int) $id_roja45_product);
        $sql->where('dr.id_roja45_product_model=' . (int) $id_roja45_product_model);
        $sql->where('dr.id_roja45_product_rate=' . (int) $id_roja45_product_rate);
        $sql->where('dr.date="' . pSQL($date) . '"');
        return Db::getInstance()->getValue($sql);
    }

    public static function getRate($id_roja45_product, $id_roja45_product_model, $id_roja45_product_rate, $date)
    {
        $sql = new DbQuery();
        $sql->select('rate');
        $sql->from('roja45_productrental_daterate', 'dr');
        $sql->where('dr.id_roja45_product=' . (int) $id_roja45_product);
        $sql->where('dr.id_roja45_product_model=' . (int) $id_roja45_product_model);
        $sql->where('dr.id_roja45_product_rate=' . (int) $id_roja45_product_rate);
        $sql->where('dr.date="' . pSQL($date) . '');
        return Db::getInstance()->getValue($sql);
    }

    public static function getRates(
        $id_roja45_product,
        $id_roja45_product_model = null,
        $id_roja45_product_rate = null,
        $date = null,
        $id_lang = null
    ) {
        if ($id_lang == null) {
            $id_lang = Configuration::get('PS_DEFAULT_LANG');
        }

        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('roja45_productrental_daterate', 'dr');
        $sql->where('dr.id_roja45_product=' . (int) $id_roja45_product);
        if ($id_roja45_product_model) {
            $sql->where('dr.id_roja45_product_model=' . (int) $id_roja45_product_model);
        }
        if ($id_roja45_product_rate) {
            $sql->where('dr.id_roja45_product_rate=' . (int) $id_roja45_product_rate);
        }
        if ($date) {
            $sql->where('dr.date=' . pSQL($date));
        }
        return Db::getInstance()->executeS($sql);
    }

    public static function deleteAll($id_roja45_product_rental_model)
    {
        $sql = '
          DELETE FROM `' . _DB_PREFIX_ . 'roja45_productrental_daterate`
          WHERE `id_roja45_product_model` = ' . (int)$id_roja45_product_rental_model;
        return (bool)Db::getInstance()->execute($sql);
    }
}
